/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.io.Serializable;
import java.text.DecimalFormat;

public abstract class Stat<T>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final DecimalFormat FORMAT = new DecimalFormat("###,###,###,###,###,###,###");
    protected final StatDefinition definition;

    Stat(StatGroup group, StatDefinition definition) {
        this.definition = definition;
        group.register(this);
    }

    public abstract T get();

    public abstract void set(T var1);

    public abstract void add(Stat<T> var1);

    public abstract Stat<T> computeInterval(Stat<T> var1);

    public abstract void negate();

    public abstract void clear();

    public Stat<T> copy() {
        Object o;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException unexpected) {
            throw EnvironmentFailureException.unexpectedException(unexpected);
        }
        return (Stat)o;
    }

    public Stat<T> copyAndClear() {
        Stat<T> newCopy = this.copy();
        this.clear();
        return newCopy;
    }

    public StatDefinition getDefinition() {
        return this.definition;
    }

    protected abstract String getFormattedValue();

    public String toString() {
        return this.definition.getName() + "=" + this.getFormattedValue();
    }

    public String toStringVerbose() {
        return this.definition.getName() + "=" + this.getFormattedValue() + "\n\t\t" + this.definition.getDescription();
    }

    public abstract boolean isNotSet();
}

