/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;

public class LongStat
extends Stat<Long> {
    private static final long serialVersionUID = 1L;
    protected long counter;

    public LongStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
    }

    public LongStat(StatGroup group, StatDefinition definition, long counter) {
        super(group, definition);
        this.counter = counter;
    }

    @Override
    public Long get() {
        return this.counter;
    }

    @Override
    public void set(Long newValue) {
        this.counter = newValue;
    }

    public void increment() {
        ++this.counter;
    }

    public void add(long count) {
        this.counter += count;
    }

    @Override
    public void add(Stat<Long> other) {
        this.counter += other.get().longValue();
    }

    @Override
    public Stat<Long> computeInterval(Stat<Long> base) {
        Stat<Long> ret = this.copy();
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            ret.set(this.counter - base.get());
        }
        return ret;
    }

    @Override
    public void negate() {
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            this.counter = -this.counter;
        }
    }

    @Override
    public void clear() {
        this.counter = 0L;
    }

    @Override
    protected String getFormattedValue() {
        return Stat.FORMAT.format(this.counter);
    }

    @Override
    public boolean isNotSet() {
        return this.counter == 0L;
    }
}

