/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.WholeEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TxnChain {
    private final Map<DatabaseId, DatabaseImpl> undoDatabases;
    private final EnvironmentImpl envImpl;
    private final Set<Long> remainingLockedNodes;
    private final LinkedList<RevertInfo> revertList;
    private VLSN lastValidVLSN;

    public TxnChain(long lastLoggedLsn, long txnId, long matchpoint, EnvironmentImpl envImpl) {
        this(lastLoggedLsn, txnId, matchpoint, null, envImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TxnChain(long lastLoggedLsn, long txnId, long matchpoint, Map<DatabaseId, DatabaseImpl> undoDatabases, EnvironmentImpl envImpl) throws DatabaseException {
        this.envImpl = envImpl;
        this.undoDatabases = undoDatabases;
        LogManager logManager = envImpl.getLogManager();
        this.remainingLockedNodes = new HashSet<Long>();
        TreeMap<CompareSlot, LinkedList<Long>> keyToLsns = new TreeMap<CompareSlot, LinkedList<Long>>();
        LinkedList<VersionCalculator> chain = new LinkedList<VersionCalculator>();
        long undoLsn = lastLoggedLsn;
        try {
            this.lastValidVLSN = VLSN.NULL_VLSN;
            while (undoLsn != -1L) {
                WholeEntry wholeEntry = logManager.getLogEntryAllowInvisible(undoLsn);
                LNLogEntry undoEntry = (LNLogEntry)wholeEntry.getEntry();
                DatabaseImpl dbImpl = this.getDatabaseImpl(undoEntry.getDbId());
                undoEntry.postFetchInit(dbImpl);
                try {
                    CompareSlot entrySlot = new CompareSlot(dbImpl, undoEntry);
                    LinkedList<Long> lsns = (LinkedList<Long>)keyToLsns.get(entrySlot);
                    if (lsns == null) {
                        lsns = new LinkedList<Long>();
                        keyToLsns.put(entrySlot, lsns);
                    }
                    lsns.add(undoLsn);
                    if (DbLsn.compareTo(undoLsn, matchpoint) > 0) {
                        chain.add(new VersionCalculator(undoLsn, undoEntry.getAbortLsn(), undoEntry.getAbortKnownDeleted(), lsns));
                    } else {
                        this.remainingLockedNodes.add(undoLsn);
                        if (this.lastValidVLSN != null && this.lastValidVLSN.isNull() && wholeEntry.getHeader().getVLSN() != null && !wholeEntry.getHeader().getVLSN().isNull()) {
                            this.lastValidVLSN = wholeEntry.getHeader().getVLSN();
                        }
                    }
                    undoLsn = undoEntry.getUserTxn().getLastLsn();
                }
                finally {
                    this.releaseDatabaseImpl(dbImpl);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw EnvironmentFailureException.promote(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Problem finding intermediates for txn " + txnId + " at lsn " + DbLsn.getNoFormatString(undoLsn), e);
        }
        this.revertList = new LinkedList();
        for (VersionCalculator calculator : chain) {
            this.revertList.add(calculator.findPreviousVersion());
        }
    }

    private DatabaseImpl getDatabaseImpl(DatabaseId dbId) {
        if (this.undoDatabases != null) {
            return this.undoDatabases.get(dbId);
        }
        return this.envImpl.getDbTree().getDb(dbId);
    }

    private void releaseDatabaseImpl(DatabaseImpl dbImpl) {
        if (this.undoDatabases == null) {
            this.envImpl.getDbTree().releaseDb(dbImpl);
        }
    }

    public Set<Long> getRemainingLockedNodes() {
        return this.remainingLockedNodes;
    }

    public RevertInfo pop() {
        return this.revertList.remove();
    }

    public VLSN getLastValidVLSN() {
        return this.lastValidVLSN;
    }

    public String toString() {
        return this.revertList.toString();
    }

    public static class CompareSlot
    implements Comparable<CompareSlot> {
        private final DatabaseImpl dbImpl;
        private final byte[] key;

        public CompareSlot(DatabaseImpl dbImpl, LNLogEntry<?> undoEntry) {
            this(dbImpl, undoEntry.getKey());
        }

        private CompareSlot(DatabaseImpl dbImpl, byte[] key) {
            this.dbImpl = dbImpl;
            this.key = key;
        }

        @Override
        public int compareTo(CompareSlot other) {
            int dbCompare = this.dbImpl.getId().compareTo(other.dbImpl.getId());
            if (dbCompare != 0) {
                return dbCompare;
            }
            return Key.compareKeys(this.key, other.key, this.dbImpl.getKeyComparator());
        }

        public boolean equals(Object other) {
            if (!(other instanceof CompareSlot)) {
                return false;
            }
            return this.compareTo((CompareSlot)other) == 0;
        }

        public int hashCode() {
            throw EnvironmentFailureException.unexpectedState("Hashing not supported");
        }
    }

    private static class VersionCalculator {
        final long entryLsn;
        final long entryAbortLsn;
        final boolean entryAbortKnownDeleted;
        final LinkedList<Long> lsns;

        VersionCalculator(long entryLsn, long entryAbortLsn, boolean entryAbortKnownDeleted, LinkedList<Long> lsns) {
            this.entryLsn = entryLsn;
            this.entryAbortLsn = entryAbortLsn;
            this.entryAbortKnownDeleted = entryAbortKnownDeleted;
            this.lsns = lsns;
        }

        RevertInfo findPreviousVersion() {
            Long topVersion = this.lsns.remove();
            assert (this.entryLsn == topVersion) : "entryLsn= " + DbLsn.getNoFormatString(this.entryLsn) + "topLsn= " + DbLsn.getNoFormatString(topVersion);
            if (this.lsns.size() == 0) {
                return new RevertInfo(this.entryAbortLsn, this.entryAbortKnownDeleted, false);
            }
            return new RevertInfo(this.lsns.getFirst(), false, true);
        }
    }

    public static class RevertInfo {
        public final long revertLsn;
        public final boolean revertKnownDeleted;
        public final boolean isIntermediateVersion;

        RevertInfo(long revertLsn, boolean revertKnownDeleted, boolean isIntermediateVersion) {
            this.revertLsn = revertLsn;
            this.revertKnownDeleted = revertKnownDeleted;
            this.isIntermediateVersion = isIntermediateVersion;
        }

        public String toString() {
            return "revertLsn=" + DbLsn.getNoFormatString(this.revertLsn) + " revertKD=" + this.revertKnownDeleted + " isIntermediateVersion=" + this.isIntermediateVersion;
        }
    }
}

