/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.BTreeStatDefinition;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.latch.LatchContext;
import com.sleepycat.je.latch.LatchFactory;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.LatchTable;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.CursorsExistException;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.SplitRequiredException;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.RelatchRequiredException;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Tree
implements Loggable {
    private static final String TRACE_ROOT_SPLIT = "RootSplit:";
    private DatabaseImpl database;
    private ChildReference root;
    private int maxTreeEntriesPerNode;
    private StatGroup stats;
    private IntStat rootSplits;
    private LongStat relatchesRequired;
    private SharedLatch rootLatch;
    private final ThreadLocal<TreeWalkerStatsAccumulator> treeStatsAccumulatorTL = new ThreadLocal();
    private static SplitRequiredException splitRequiredException = new SplitRequiredException();
    private TestHook waitHook;
    private TestHook searchHook;
    private TestHook ckptHook;

    public Tree(DatabaseImpl database) {
        this.init(database);
        this.setDatabase(database);
    }

    public Tree() {
        this.init(null);
        this.maxTreeEntriesPerNode = 0;
    }

    private void init(DatabaseImpl database) {
        this.root = null;
        this.database = database;
        this.stats = new StatGroup("BTree", "Composition of btree, types and counts of nodes.");
        this.relatchesRequired = new LongStat(this.stats, BTreeStatDefinition.BTREE_RELATCHES_REQUIRED);
        this.rootSplits = new IntStat(this.stats, BTreeStatDefinition.BTREE_ROOT_SPLITS);
    }

    public void setDatabase(DatabaseImpl database) {
        this.database = database;
        final EnvironmentImpl envImpl = database.getEnvironmentImpl();
        LatchContext latchContext = new LatchContext(){

            @Override
            public int getLatchTimeoutMs() {
                return envImpl.getLatchTimeoutMs();
            }

            @Override
            public String getLatchName() {
                return "RootLatch";
            }

            @Override
            public LatchTable getLatchTable() {
                return LatchSupport.btreeLatchTable;
            }

            @Override
            public EnvironmentImpl getEnvImplForFatalException() {
                return envImpl;
            }
        };
        this.rootLatch = LatchFactory.createSharedLatch(latchContext, false);
        this.maxTreeEntriesPerNode = database.getNodeMaxTreeEntries();
    }

    public DatabaseImpl getDatabase() {
        return this.database;
    }

    public void setRoot(ChildReference newRoot, boolean notLatched) {
        assert (notLatched || this.rootLatch.isExclusiveOwner());
        this.root = newRoot;
    }

    public ChildReference makeRootChildReference(Node target, byte[] key, long lsn) {
        return new RootChildReference(target, key, lsn);
    }

    private RootChildReference makeRootChildReference() {
        return new RootChildReference();
    }

    public boolean rootExists() {
        if (this.root == null) {
            return false;
        }
        return this.root.getTarget() != null || this.root.getLsn() != -1L;
    }

    public boolean isRootResident() {
        return this.root != null && this.root.getTarget() != null;
    }

    public long getRootLsn() {
        if (this.root == null) {
            return -1L;
        }
        return this.root.getLsn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLNs() {
        int topLevelSlots;
        int levels;
        this.rootLatch.acquireShared();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            levels = rootIN.getLevel() & 0xFFFF;
            topLevelSlots = rootIN.getNEntries();
        }
        finally {
            this.rootLatch.release();
        }
        return (long)((double)topLevelSlots * Math.pow(this.database.getNodeMaxTreeEntries(), levels - 1));
    }

    public IN withRootLatchedExclusive(WithRootLatched wrl) throws DatabaseException {
        try {
            this.rootLatch.acquireExclusive();
            IN iN = wrl.doWork(this.root);
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    public IN withRootLatchedShared(WithRootLatched wrl) throws DatabaseException {
        try {
            this.rootLatch.acquireShared();
            IN iN = wrl.doWork(this.root);
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    public void latchRootLatchExclusive() throws DatabaseException {
        this.rootLatch.acquireExclusive();
    }

    public void releaseRootLatch() throws DatabaseException {
        this.rootLatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(byte[] idKey, LocalUtilizationTracker localTracker) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        EnvironmentImpl envImpl = this.database.getDbEnvironment();
        INList inList = envImpl.getInMemoryINs();
        IN subtreeRootIN = null;
        ArrayList<SplitInfo> nodeLadder = new ArrayList<SplitInfo>();
        IN rootIN = null;
        boolean rootNeedsUpdating = false;
        this.rootLatch.acquireExclusive();
        try {
            if (!this.rootExists()) {
                return;
            }
            rootIN = (IN)this.root.fetchTarget(this.database, null);
            rootIN.latch(CacheMode.UNCHANGED);
            this.searchDeletableSubTree(rootIN, idKey, nodeLadder);
            if (nodeLadder.size() == 0) {
            } else {
                SplitInfo detachPoint = nodeLadder.get(nodeLadder.size() - 1);
                boolean deleteOk = detachPoint.parent.deleteEntry(detachPoint.index, true);
                assert (deleteOk);
                subtreeRootIN = detachPoint.child;
                if (this.database.isDeferredWriteMode()) {
                    subtreeRootIN.accountForDeferredWriteSubtreeRemoval(inList, detachPoint.parent);
                }
                rootNeedsUpdating = this.cascadeUpdates(nodeLadder, -1);
            }
        }
        finally {
            this.releaseNodeLadderLatches(nodeLadder);
            if (rootIN != null) {
                rootIN.releaseLatch();
            }
            this.rootLatch.release();
        }
        if (subtreeRootIN != null) {
            if (rootNeedsUpdating) {
                envImpl.getDbTree().optionalModifyDbRoot(this.database);
                RecoveryManager.traceRootDeletion(envImpl.getLogger(), this.database);
            }
            if (!this.database.isDeferredWriteMode()) {
                subtreeRootIN.accountForSubtreeRemoval(inList, localTracker);
            }
            LoggerUtils.envLogMsg(Level.FINE, envImpl, "SubtreeRemoval: subtreeRoot = " + subtreeRootIN.getNodeId());
        }
    }

    private void releaseNodeLadderLatches(ArrayList<SplitInfo> nodeLadder) throws DatabaseException {
        ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
        while (iter.hasPrevious()) {
            SplitInfo info = iter.previous();
            info.child.releaseLatch();
        }
    }

    private boolean cascadeUpdates(ArrayList<SplitInfo> nodeLadder, int index) throws DatabaseException {
        ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
        EnvironmentImpl envImpl = this.database.getDbEnvironment();
        LogManager logManager = envImpl.getLogManager();
        long newLsn = -1L;
        SplitInfo info = null;
        while (iter.hasPrevious()) {
            info = iter.previous();
            if (newLsn != -1L) {
                info.parent.updateEntry(info.index, newLsn, 0);
            }
            newLsn = info.parent.optionalLog(logManager);
        }
        boolean rootNeedsUpdating = false;
        if (info != null) {
            assert (info.parent.isDbRoot());
            assert (this.rootLatch.isExclusiveOwner());
            this.root.updateLsnAfterOptionalLog(this.database, newLsn);
            rootNeedsUpdating = true;
        }
        return rootNeedsUpdating;
    }

    public IN getFirstNode(CacheMode cacheMode) throws DatabaseException {
        return this.search(null, SearchType.LEFT, null, cacheMode, null);
    }

    public IN getLastNode(CacheMode cacheMode) throws DatabaseException {
        return this.search(null, SearchType.RIGHT, null, cacheMode, null);
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, CacheMode cacheMode) throws DatabaseException {
        return this.getParentINForChildIN(child, requireExactMatch, cacheMode, -1, null, true);
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, CacheMode cacheMode, int targetLevel, List<TrackingInfo> trackingList, boolean doFetch) throws DatabaseException {
        if (child == null) {
            throw EnvironmentFailureException.unexpectedState("getParentNode passed null");
        }
        assert (child.isLatchExclusiveOwner());
        byte[] treeKey = child.getIdentifierKey();
        boolean isRoot = child.isRoot();
        child.releaseLatch();
        return this.getParentINForChildIN(child.getNodeId(), isRoot, treeKey, requireExactMatch, cacheMode, targetLevel, trackingList, doFetch);
    }

    public SearchResult getParentINForChildIN(long targetNodeId, boolean targetIsRoot, byte[] targetTreeKey, boolean requireExactMatch, CacheMode cacheMode, int targetLevel, List<TrackingInfo> trackingList, boolean doFetch) throws DatabaseException {
        IN rootIN = this.getRootINLatchedExclusive(cacheMode);
        SearchResult result = new SearchResult();
        if (rootIN != null) {
            if (trackingList != null) {
                trackingList.add(new TrackingInfo(this.root.getLsn(), rootIN.getNodeId(), rootIN.getNEntries()));
            }
            IN potentialParent = rootIN;
            boolean success = false;
            try {
                while (result.keepSearching) {
                    assert (TestHookExecute.doHookIfSet(this.searchHook));
                    potentialParent.findParent(SearchType.NORMAL, targetNodeId, targetIsRoot, targetTreeKey, result, requireExactMatch, cacheMode, targetLevel, doFetch);
                    if (trackingList != null) {
                        trackingList.get(trackingList.size() - 1).setIndex(result.index);
                        if (result.keepSearching) {
                            trackingList.add(new TrackingInfo(potentialParent.getLsn(result.index), result.parent.getNodeId(), result.parent.getNEntries()));
                        }
                    }
                    potentialParent = result.parent;
                }
                success = true;
            }
            catch (RelatchRequiredException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
            finally {
                if (!success) {
                    potentialParent.releaseLatch();
                }
            }
        }
        return result;
    }

    public boolean getParentBINForChildLN(TreeLocation location, byte[] key, boolean splitsAllowed, boolean findDeletedEntries, CacheMode cacheMode) throws DatabaseException {
        location.reset();
        IN searchResult = splitsAllowed ? this.searchSplitsAllowed(key, cacheMode, null) : this.search(key, SearchType.NORMAL, null, cacheMode, null);
        if (searchResult == null) {
            return false;
        }
        try {
            location.bin = (BIN)searchResult;
            boolean exactSearch = false;
            boolean indicateIfExact = true;
            if (!findDeletedEntries) {
                exactSearch = true;
                indicateIfExact = false;
            }
            location.index = location.bin.findEntry(key, indicateIfExact, exactSearch);
            boolean match = false;
            if (findDeletedEntries) {
                match = location.index >= 0 && (location.index & 0x10000) != 0;
                location.index &= 0xFFFEFFFF;
            } else {
                boolean bl = match = location.index >= 0;
            }
            if (match) {
                location.childLsn = location.bin.getLsn(location.index);
                return true;
            }
            location.lnKey = key;
            return false;
        }
        catch (RuntimeException e) {
            searchResult.releaseLatch();
            throw e;
        }
    }

    public BIN getNextBin(BIN bin, CacheMode cacheMode) throws DatabaseException {
        return (BIN)this.getNextIN(bin, true, cacheMode);
    }

    public BIN getPrevBin(BIN bin, CacheMode cacheMode) throws DatabaseException {
        return (BIN)this.getNextIN(bin, false, cacheMode);
    }

    public IN getNextIN(IN prevIn, boolean forward, CacheMode cacheMode) {
        byte[] searchKey = prevIn.getNEntries() == 0 ? prevIn.getIdentifierKey() : (forward ? prevIn.getKey(prevIn.getNEntries() - 1) : prevIn.getKey(0));
        int targetLevel = prevIn.getLevel();
        IN next = prevIn;
        boolean nextIsLatched = false;
        assert (next.isLatchExclusiveOwner()) : "what?";
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.expectBtreeLatchesHeld(1);
        }
        IN parent = null;
        IN nextIN = null;
        boolean nextINIsLatched = false;
        boolean normalExit = false;
        try {
            while (true) {
                boolean moreEntriesThisIn;
                nextIsLatched = false;
                SearchResult result = this.getParentINForChildIN(next, true, cacheMode);
                if (!result.exactParentFound) {
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(0);
                    }
                    normalExit = true;
                    IN iN = null;
                    return iN;
                }
                parent = result.parent;
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(1);
                }
                int index = parent.findEntry(searchKey, false, false);
                if (forward) {
                    moreEntriesThisIn = ++index < parent.getNEntries();
                } else {
                    moreEntriesThisIn = index > 0;
                    --index;
                }
                if (moreEntriesThisIn) {
                    nextIN = (IN)parent.fetchTargetWithExLatch(index, cacheMode);
                    nextIN.latch(cacheMode);
                    nextINIsLatched = true;
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(2);
                    }
                    if (nextIN.getLevel() == targetLevel) {
                        parent.releaseLatch();
                        parent = null;
                        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                        if (treeStatsAccumulator != null) {
                            nextIN.accumulateStats(treeStatsAccumulator);
                        }
                        normalExit = true;
                        IN iN = nextIN;
                        return iN;
                    }
                    nextINIsLatched = false;
                    IN ret = this.searchSubTree(nextIN, null, forward ? SearchType.LEFT : SearchType.RIGHT, targetLevel, null, cacheMode, null);
                    parent.releaseLatch();
                    parent = null;
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(1);
                    }
                    if (ret.getLevel() == targetLevel) {
                        normalExit = true;
                        IN iN = ret;
                        return iN;
                    }
                    throw EnvironmentFailureException.unexpectedState("subtree did not have a IN at level " + targetLevel);
                }
                next = parent;
                nextIsLatched = true;
                parent = null;
            }
        }
        finally {
            if (!normalExit) {
                if (next != null && nextIsLatched) {
                    next.releaseLatch();
                }
                if (parent != null) {
                    parent.releaseLatch();
                }
                if (nextIN != null && nextINIsLatched) {
                    nextIN.releaseLatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitRoot(CacheMode cacheMode) throws DatabaseException {
        EnvironmentImpl env = this.database.getDbEnvironment();
        LogManager logManager = env.getLogManager();
        INList inMemoryINs = env.getInMemoryINs();
        IN curRoot = null;
        curRoot = (IN)this.root.fetchTarget(this.database, null);
        curRoot.latch(cacheMode);
        long curRootLsn = 0L;
        long logLsn = 0L;
        IN newRoot = null;
        try {
            byte[] rootIdKey = curRoot.getKey(0);
            newRoot = new IN(this.database, rootIdKey, this.maxTreeEntriesPerNode, curRoot.getLevel() + 1);
            newRoot.latch(cacheMode);
            newRoot.setIsRoot(true);
            curRoot.setIsRoot(false);
            boolean logSuccess = false;
            try {
                curRootLsn = curRoot.optionalLogProvisional(logManager, newRoot);
                boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, curRootLsn));
                assert (insertOk);
                logLsn = newRoot.optionalLog(logManager);
                logSuccess = true;
            }
            finally {
                if (!logSuccess) {
                    curRoot.setIsRoot(true);
                }
            }
            inMemoryINs.add(newRoot);
            this.root.setTarget(newRoot);
            this.root.updateLsnAfterOptionalLog(this.database, logLsn);
            curRoot.split(newRoot, 0, this.maxTreeEntriesPerNode, cacheMode);
            this.root.setLsn(newRoot.getLastLoggedVersion());
        }
        finally {
            newRoot.releaseLatch();
            curRoot.releaseLatch();
        }
        this.rootSplits.increment();
        this.traceSplitRoot(Level.FINE, TRACE_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
    }

    public IN search(byte[] key, SearchType searchType, BINBoundary binBoundary, CacheMode cacheMode, Comparator<byte[]> searchComparator) {
        IN rootIN = this.getRootIN(cacheMode);
        if (rootIN != null) {
            return this.searchSubTree(rootIN, key, searchType, -1, binBoundary, cacheMode, searchComparator);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN searchSplitsAllowed(byte[] key, CacheMode cacheMode, Comparator<byte[]> searchComparator) {
        IN insertTarget = null;
        block7: while (insertTarget == null) {
            this.rootLatch.acquireShared();
            boolean rootLatched = true;
            boolean rootLatchedExclusive = false;
            boolean rootINLatched = false;
            boolean success = false;
            IN rootIN = null;
            try {
                while (this.rootExists()) {
                    rootIN = (IN)this.root.fetchTarget(this.database, null);
                    if (rootIN.needsSplitting()) {
                        if (!rootLatchedExclusive) {
                            rootIN = null;
                            this.rootLatch.release();
                            this.rootLatch.acquireExclusive();
                            rootLatchedExclusive = true;
                            continue;
                        }
                        this.splitRoot(cacheMode);
                        this.rootLatch.release();
                        rootLatched = false;
                        EnvironmentImpl env = this.database.getDbEnvironment();
                        env.getDbTree().optionalModifyDbRoot(this.database);
                        rootLatched = true;
                        this.rootLatch.acquireExclusive();
                        rootIN = (IN)this.root.fetchTarget(this.database, null);
                        rootIN.latch(cacheMode);
                    } else {
                        rootIN.latchShared(cacheMode);
                    }
                    rootINLatched = true;
                    break;
                }
                success = true;
            }
            finally {
                if (!success && rootINLatched) {
                    rootIN.releaseLatch();
                }
                if (rootLatched) {
                    this.rootLatch.release();
                }
            }
            if (rootIN == null) break;
            try {
                assert (rootINLatched);
                while (true) {
                    try {
                        insertTarget = this.searchSubTreeSplitsAllowed(rootIN, key, cacheMode, searchComparator);
                        continue block7;
                    }
                    catch (RelatchRequiredException RRE) {
                        this.relatchesRequired.increment();
                        this.database.getDbEnvironment().incRelatchesRequired();
                        this.rootLatch.acquireExclusive();
                        rootIN = (IN)this.root.fetchTarget(this.database, null);
                        rootIN.latch(cacheMode);
                        this.rootLatch.release();
                        continue;
                    }
                    break;
                }
            }
            catch (SplitRequiredException e) {
            }
        }
        return insertTarget;
    }

    private IN searchSubTree(IN parent, byte[] key, SearchType searchType, int targetLevel, BINBoundary binBoundary, CacheMode cacheMode, Comparator<byte[]> searchComparator) {
        assert (parent == null || parent.isRoot() || parent.isLatchExclusiveOwner());
        for (int i = 0; i < 2; ++i) {
            try {
                return this.searchSubTreeInternal(parent, key, searchType, targetLevel, binBoundary, cacheMode, searchComparator);
            }
            catch (RelatchRequiredException RRE) {
                parent = this.getRootINLatchedExclusive(cacheMode);
                continue;
            }
        }
        throw EnvironmentFailureException.unexpectedState("searchSubTreeInternal should have completed in two tries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN searchSubTreeInternal(IN parent, byte[] key, SearchType searchType, int targetLevel, BINBoundary binBoundary, CacheMode cacheMode, Comparator<byte[]> searchComparator) throws RelatchRequiredException {
        if (parent == null) {
            return null;
        }
        if ((searchType == SearchType.LEFT || searchType == SearchType.RIGHT) && key != null) {
            throw EnvironmentFailureException.unexpectedState("searchSubTree passed key and left/right search");
        }
        assert (parent.isLatchOwner());
        if (binBoundary != null) {
            binBoundary.isLastBin = true;
            binBoundary.isFirstBin = true;
        }
        IN child = null;
        IN grandParent = null;
        boolean childIsLatched = false;
        boolean grandParentIsLatched = false;
        boolean maintainGrandParentLatches = !parent.isLatchExclusiveOwner();
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        boolean success = false;
        try {
            do {
                int index;
                if (treeStatsAccumulator != null) {
                    parent.accumulateStats(treeStatsAccumulator);
                }
                if (parent.getNEntries() == 0) {
                    success = true;
                    IN iN = parent;
                    return iN;
                }
                if (searchType == SearchType.NORMAL) {
                    index = parent.findEntry(key, false, false, searchComparator);
                } else if (searchType == SearchType.LEFT) {
                    index = 0;
                } else if (searchType == SearchType.RIGHT) {
                    index = parent.getNEntries() - 1;
                } else {
                    throw EnvironmentFailureException.unexpectedState("Invalid value of searchType: " + searchType);
                }
                assert (index >= 0);
                if (binBoundary != null) {
                    if (index != parent.getNEntries() - 1) {
                        binBoundary.isLastBin = false;
                    }
                    if (index != 0) {
                        binBoundary.isFirstBin = false;
                    }
                }
                if (maintainGrandParentLatches && parent.getTarget(index) == null && !parent.isAlwaysLatchedExclusively()) {
                    if (grandParent == null) {
                        throw RelatchRequiredException.relatchRequiredException;
                    }
                    parent.releaseLatch();
                    parent.latch(cacheMode);
                    grandParent.releaseLatch();
                    grandParentIsLatched = false;
                    grandParent = null;
                }
                child = (IN)parent.fetchTarget(index, cacheMode);
                if (grandParent != null) {
                    grandParent.releaseLatch();
                    grandParentIsLatched = false;
                }
                if (maintainGrandParentLatches) {
                    child.latchShared(cacheMode);
                } else {
                    child.latch(cacheMode);
                }
                childIsLatched = true;
                if (treeStatsAccumulator != null) {
                    child.accumulateStats(treeStatsAccumulator);
                }
                if (maintainGrandParentLatches) {
                    grandParent = parent;
                    grandParentIsLatched = true;
                    continue;
                }
                parent.releaseLatch();
            } while (!(parent = child).isBIN() && parent.getLevel() != targetLevel);
            success = true;
            IN iN = child;
            return iN;
        }
        finally {
            if (!success) {
                try {
                    if (child != null && childIsLatched) {
                        child.releaseLatch();
                    }
                    if (parent != child) {
                        parent.releaseLatch();
                    }
                }
                catch (Exception e) {
                    LoggerUtils.traceAndLogException(this.database.getDbEnvironment(), "Tree", "searchSubTreeInternal", "", e);
                }
            }
            if (grandParent != null && grandParentIsLatched) {
                grandParent.releaseLatch();
                grandParentIsLatched = false;
            }
        }
    }

    public void searchDeletableSubTree(IN parent, byte[] key, ArrayList<SplitInfo> nodeLadder) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        assert (parent != null);
        assert (key != null);
        assert (((IN)parent).isLatchExclusiveOwner());
        Node child = null;
        IN lowestMultipleEntryIN = null;
        while (((IN)parent).getNEntries() != 0) {
            if (((IN)parent).getNEntries() > 1) {
                lowestMultipleEntryIN = parent;
            }
            int index = ((IN)parent).findEntry(key, false, false);
            assert (index >= 0);
            child = (IN)((IN)parent).fetchTargetWithExLatch(index, CacheMode.DEFAULT);
            ((IN)child).latch(CacheMode.UNCHANGED);
            nodeLadder.add(new SplitInfo((IN)parent, (IN)child, index));
            parent = child;
            if (!parent.isBIN()) continue;
        }
        if (child != null && child.isBIN()) {
            if (((IN)child).getNEntries() != 0) {
                throw NodeNotEmptyException.NODE_NOT_EMPTY;
            }
            if (((BIN)child).nCursors() > 0) {
                throw CursorsExistException.CURSORS_EXIST;
            }
        }
        if (lowestMultipleEntryIN != null) {
            ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
            while (iter.hasPrevious()) {
                SplitInfo info = iter.previous();
                if (info.parent != lowestMultipleEntryIN) {
                    info.child.releaseLatch();
                    iter.remove();
                    continue;
                }
                break;
            }
        } else {
            this.releaseNodeLadderLatches(nodeLadder);
            nodeLadder.clear();
        }
    }

    private IN searchSubTreeSplitsAllowed(IN parent, byte[] key, CacheMode cacheMode, Comparator<byte[]> searchComparator) throws RelatchRequiredException, SplitRequiredException {
        if (parent != null) {
            while (true) {
                try {
                    return this.searchSubTreeUntilSplit(parent, key, cacheMode, searchComparator);
                }
                catch (SplitRequiredException e) {
                    assert (TestHookExecute.doHookIfSet(this.waitHook));
                    parent = this.forceSplit(parent, key, cacheMode);
                    continue;
                }
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN searchSubTreeUntilSplit(IN parent, byte[] key, CacheMode cacheMode, Comparator<byte[]> searchComparator) throws RelatchRequiredException, SplitRequiredException {
        boolean latchingIsExclusive = parent.isLatchExclusiveOwner();
        IN child = null;
        boolean childIsLatched = false;
        boolean success = false;
        try {
            do {
                if (parent.getNEntries() == 0) {
                    success = true;
                    IN iN = parent;
                    return iN;
                }
                int index = parent.findEntry(key, false, false, searchComparator);
                assert (index >= 0);
                child = (IN)parent.fetchTarget(index, cacheMode);
                if (latchingIsExclusive) {
                    child.latch(cacheMode);
                } else {
                    child.latchShared(cacheMode);
                }
                childIsLatched = true;
                if (child.needsSplitting()) {
                    this.database.getDbEnvironment().lazyCompress(child);
                    if (child.needsSplitting()) {
                        throw splitRequiredException;
                    }
                }
                parent.releaseLatch();
            } while (!(parent = child).isBIN());
            success = true;
            IN iN = parent;
            return iN;
        }
        finally {
            if (!success) {
                if (child != null && childIsLatched) {
                    child.releaseLatch();
                }
                if (parent != child) {
                    parent.releaseLatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN forceSplit(IN parent, byte[] key, CacheMode cacheMode) throws DatabaseException, SplitRequiredException {
        boolean isRootLatched;
        IN originalParent;
        block25: {
            block26: {
                ArrayList<SplitInfo> nodeLadder = new ArrayList<SplitInfo>();
                boolean allLeftSideDescent = true;
                boolean allRightSideDescent = true;
                IN child = null;
                originalParent = parent;
                ListIterator iter = null;
                isRootLatched = false;
                boolean success = false;
                try {
                    int index;
                    if (originalParent.isDbRoot()) {
                        this.rootLatch.acquireExclusive();
                        isRootLatched = true;
                        originalParent = parent = (IN)this.root.fetchTarget(this.database, null);
                    }
                    originalParent.latch(cacheMode);
                    if (originalParent.needsSplitting() || !originalParent.isRoot()) {
                        throw splitRequiredException;
                    }
                    while (parent.getNEntries() != 0) {
                        index = parent.findEntry(key, false, false);
                        if (index != 0) {
                            allLeftSideDescent = false;
                        }
                        if (index != parent.getNEntries() - 1) {
                            allRightSideDescent = false;
                        }
                        assert (index >= 0);
                        if (!parent.isResident(index)) {
                            child = null;
                            break;
                        }
                        child = (IN)parent.fetchTargetWithExLatch(index, cacheMode);
                        child.latch(cacheMode);
                        nodeLadder.add(new SplitInfo(parent, child, index));
                        parent = child;
                        if (!parent.isBIN()) continue;
                    }
                    boolean startedSplits = false;
                    LogManager logManager = this.database.getDbEnvironment().getLogManager();
                    iter = nodeLadder.listIterator(nodeLadder.size());
                    long lastParentForSplit = -1L;
                    while (iter.hasPrevious()) {
                        SplitInfo info = (SplitInfo)iter.previous();
                        iter.remove();
                        child = info.child;
                        parent = info.parent;
                        index = info.index;
                        if (child.needsSplitting()) {
                            if (allLeftSideDescent || allRightSideDescent) {
                                child.splitSpecial(parent, index, this.maxTreeEntriesPerNode, key, allLeftSideDescent, cacheMode);
                            } else {
                                child.split(parent, index, this.maxTreeEntriesPerNode, cacheMode);
                            }
                            lastParentForSplit = parent.getNodeId();
                            startedSplits = true;
                            if (parent.isDbRoot()) {
                                assert (isRootLatched);
                                this.root.setLsn(parent.getLastLoggedVersion());
                                parent.setDirty(true);
                            }
                        } else if (startedSplits) {
                            long newLsn = 0L;
                            newLsn = lastParentForSplit == child.getNodeId() ? child.getLastLoggedVersion() : child.optionalLog(logManager);
                            parent.updateEntry(index, newLsn, 0);
                        }
                        child.releaseLatch();
                        child = null;
                    }
                    success = true;
                    if (success) break block25;
                    if (child != null) {
                        child.releaseLatch();
                    }
                    if (nodeLadder.size() <= 0) break block26;
                    iter = nodeLadder.listIterator(nodeLadder.size());
                }
                catch (Throwable throwable) {
                    if (!success) {
                        if (child != null) {
                            child.releaseLatch();
                        }
                        if (nodeLadder.size() > 0) {
                            iter = nodeLadder.listIterator(nodeLadder.size());
                            while (iter.hasPrevious()) {
                                SplitInfo info = (SplitInfo)iter.previous();
                                info.child.releaseLatch();
                            }
                        }
                        originalParent.releaseLatch();
                    }
                    if (isRootLatched) {
                        this.rootLatch.release();
                    }
                    throw throwable;
                }
                while (iter.hasPrevious()) {
                    SplitInfo info = (SplitInfo)iter.previous();
                    info.child.releaseLatch();
                }
            }
            originalParent.releaseLatch();
        }
        if (isRootLatched) {
            this.rootLatch.release();
        }
        return originalParent;
    }

    public IN getRootIN(CacheMode cacheMode) throws DatabaseException {
        return this.getRootINInternal(cacheMode, false);
    }

    public IN getRootINLatchedExclusive(CacheMode cacheMode) throws DatabaseException {
        return this.getRootINInternal(cacheMode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN getRootINInternal(CacheMode cacheMode, boolean exclusive) throws DatabaseException {
        this.rootLatch.acquireShared();
        try {
            IN iN = this.getRootINRootAlreadyLatched(cacheMode, exclusive);
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    public IN getRootINRootAlreadyLatched(CacheMode cacheMode, boolean exclusive) {
        if (!this.rootExists()) {
            return null;
        }
        IN rootIN = (IN)this.root.fetchTarget(this.database, null);
        if (exclusive) {
            rootIN.latch(cacheMode);
        } else {
            rootIN.latchShared(cacheMode);
        }
        return rootIN;
    }

    public IN getResidentRootIN(boolean latched) throws DatabaseException {
        IN rootIN = null;
        if (this.rootExists() && (rootIN = (IN)this.root.getTarget()) != null && latched) {
            rootIN.latchShared(CacheMode.UNCHANGED);
        }
        return rootIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findBinForInsert(byte[] key, CursorImpl cursor) {
        BIN bin;
        block11: {
            bin = cursor.latchBIN();
            if (bin != null) {
                if (!bin.needsSplitting() && bin.isKeyInBounds(key)) {
                    return;
                }
                bin.releaseLatch();
            }
            boolean rootLatchIsHeld = false;
            try {
                IN in;
                while (true) {
                    rootLatchIsHeld = true;
                    this.rootLatch.acquireShared();
                    if (!this.rootExists()) {
                        this.rootLatch.release();
                        this.rootLatch.acquireExclusive();
                        if (this.rootExists()) {
                            this.rootLatch.release();
                            rootLatchIsHeld = false;
                            continue;
                        }
                        CacheMode cacheMode = cursor.getCacheMode();
                        EnvironmentImpl env = this.database.getDbEnvironment();
                        LogManager logManager = env.getLogManager();
                        INList inMemoryINs = env.getInMemoryINs();
                        Evictor evictor = env.getEvictor();
                        bin = new BIN(this.database, key, this.maxTreeEntriesPerNode, 1);
                        bin.latch(cacheMode);
                        long logLsn = bin.optionalLogProvisional(logManager, null);
                        IN rootIN = new IN(this.database, key, this.maxTreeEntriesPerNode, 2);
                        rootIN.latch(cacheMode);
                        rootIN.setIsRoot(true);
                        boolean insertOk = rootIN.insertEntry(new ChildReference(bin, key, logLsn));
                        assert (insertOk);
                        logLsn = rootIN.optionalLog(logManager);
                        rootIN.setDirty(true);
                        this.root = this.makeRootChildReference(rootIN, new byte[0], logLsn);
                        rootIN.releaseLatch();
                        inMemoryINs.add(bin);
                        inMemoryINs.add(rootIN);
                        evictor.addBack(bin);
                        this.rootLatch.release();
                        rootLatchIsHeld = false;
                        break block11;
                    }
                    this.rootLatch.release();
                    rootLatchIsHeld = false;
                    in = this.searchSplitsAllowed(key, cursor.getCacheMode(), null);
                    if (in != null) break;
                }
                bin = (BIN)in;
            }
            finally {
                if (rootLatchIsHeld) {
                    this.rootLatch.release();
                }
            }
        }
        assert (TestHookExecute.doHookIfSet(this.ckptHook));
        cursor.setBIN(bin);
    }

    @Override
    public int getLogSize() {
        int size = 1;
        if (this.root != null) {
            size += this.root.getLogSize();
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        byte booleans = (byte)(this.root != null ? 1 : 0);
        logBuffer.put(booleans);
        if (this.root != null) {
            this.root.writeToLog(logBuffer);
        }
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        boolean rootExists = false;
        byte booleans = itemBuffer.get();
        boolean bl = rootExists = (booleans & 1) != 0;
        if (rootExists) {
            this.root = this.makeRootChildReference();
            this.root.readFromLog(itemBuffer, entryVersion);
        }
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<root>");
        if (this.root != null) {
            this.root.dumpLog(sb, verbose);
        }
        sb.append("</root>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public void rebuildINList() throws DatabaseException {
        INList inMemoryList = this.database.getDbEnvironment().getInMemoryINs();
        if (this.root != null) {
            this.rootLatch.acquireShared();
            try {
                Node rootIN = this.root.getTarget();
                if (rootIN != null) {
                    rootIN.rebuildINList(inMemoryList);
                }
            }
            finally {
                this.rootLatch.release();
            }
        }
    }

    int getTreeStats() {
        return this.rootSplits.get();
    }

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            return this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.treeStatsAccumulatorTL.set(tSA);
    }

    public void loadStats(StatsConfig config, BtreeStats btreeStats) {
        btreeStats.setTreeStats(this.stats.cloneGroup(false));
        if (config.getClear()) {
            this.relatchesRequired.clear();
            this.rootSplits.clear();
        }
    }

    public void dump() {
        System.out.println(this.dumpString(0));
    }

    public String dumpString(int nSpaces) {
        StringBuilder sb = new StringBuilder();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<tree>");
        sb.append('\n');
        if (this.root != null) {
            sb.append(DbLsn.dumpString(this.root.getLsn(), nSpaces));
            sb.append('\n');
            IN rootIN = (IN)this.root.getTarget();
            if (rootIN == null) {
                sb.append("<in/>");
            } else {
                sb.append(rootIN.toString());
            }
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("</tree>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateDelete(int index) throws DatabaseException {
        this.rootLatch.acquireShared();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            boolean bl = rootIN.validateSubtreeBeforeDelete(index);
            return bl;
        }
        finally {
            this.rootLatch.release();
        }
    }

    public void validateINList(IN parent) throws DatabaseException {
        if (parent == null) {
            parent = (IN)this.root.getTarget();
        }
        if (parent != null) {
            INList inList = this.database.getDbEnvironment().getInMemoryINs();
            if (!inList.contains(parent)) {
                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " missing from INList");
            }
            int i = 0;
            while (true) {
                block9: {
                    try {
                        Node node = parent.getTargetAllowBINDelta(i);
                        if (i >= parent.getNEntries()) {
                            if (node != null) {
                                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " has stray node " + node + " at index " + i);
                            }
                            byte[] key = parent.getKey(i);
                            if (key != null) {
                                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " has stray key " + key + " at index " + i);
                            }
                        }
                        if (!(node instanceof IN)) break block9;
                        this.validateINList((IN)node);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void setWaitHook(TestHook hook) {
        this.waitHook = hook;
    }

    public void setSearchHook(TestHook hook) {
        this.searchHook = hook;
    }

    public void setCkptHook(TestHook hook) {
        this.ckptHook = hook;
    }

    private void traceSplitRoot(Level level, String splitType, IN newRoot, long newRootLsn, IN oldRoot, long oldRootLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(splitType);
            sb.append(" newRoot=").append(newRoot.getNodeId());
            sb.append(" newRootLsn=").append(DbLsn.getNoFormatString(newRootLsn));
            sb.append(" oldRoot=").append(oldRoot.getNodeId());
            sb.append(" oldRootLsn=").append(DbLsn.getNoFormatString(oldRootLsn));
            LoggerUtils.logMsg(logger, this.database.getDbEnvironment(), level, sb.toString());
        }
    }

    private static class SplitInfo {
        IN parent;
        IN child;
        int index;

        SplitInfo(IN parent, IN child, int index) {
            this.parent = parent;
            this.child = child;
            this.index = index;
        }
    }

    private class RootChildReference
    extends ChildReference {
        private RootChildReference() {
        }

        private RootChildReference(Node target, byte[] key, long lsn) {
            super(target, key, lsn);
        }

        @Override
        public Node fetchTarget(DatabaseImpl database, IN in) throws DatabaseException {
            if (this.getTarget() == null && !Tree.this.rootLatch.isExclusiveOwner()) {
                Tree.this.rootLatch.release();
                Tree.this.rootLatch.acquireExclusive();
                if (this != Tree.this.root) {
                    throw EnvironmentFailureException.unexpectedState(database.getDbEnvironment(), "Root changed while unlatched, dbId=" + database.getId());
                }
            }
            return super.fetchTarget(database, in);
        }

        @Override
        public void setTarget(Node target) {
            assert (Tree.this.rootLatch.isExclusiveOwner());
            super.setTarget(target);
        }

        @Override
        public void clearTarget() {
            assert (Tree.this.rootLatch.isExclusiveOwner());
            super.clearTarget();
        }

        @Override
        public void setLsn(long lsn) {
            assert (Tree.this.rootLatch.isExclusiveOwner());
            super.setLsn(lsn);
        }

        @Override
        void updateLsnAfterOptionalLog(DatabaseImpl dbImpl, long lsn) {
            assert (Tree.this.rootLatch.isExclusiveOwner());
            super.updateLsnAfterOptionalLog(dbImpl, lsn);
        }
    }

    public static class SearchType {
        public static final SearchType NORMAL = new SearchType();
        public static final SearchType LEFT = new SearchType();
        public static final SearchType RIGHT = new SearchType();

        private SearchType() {
        }
    }
}

