/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import java.nio.ByteBuffer;

public final class MapLN
extends LN {
    private static final String BEGIN_TAG = "<mapLN>";
    private static final String END_TAG = "</mapLN>";
    private final DatabaseImpl databaseImpl;
    private boolean deleted;

    public MapLN(DatabaseImpl db) {
        super(new byte[0]);
        this.databaseImpl = db;
        this.deleted = false;
    }

    public MapLN() {
        this.databaseImpl = new DatabaseImpl();
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    void makeDeleted() {
        this.deleted = true;
        this.databaseImpl.getTree().setRoot(null, true);
    }

    public DatabaseImpl getDatabase() {
        return this.databaseImpl;
    }

    @Override
    boolean isEvictableInexact() {
        return this.databaseImpl.getDbEnvironment().getDbEviction() && !this.databaseImpl.isInUse() && !this.databaseImpl.getTree().isRootResident();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isEvictable(long lsn) throws DatabaseException {
        boolean evictable = false;
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        BasicLocker locker = BasicLocker.createBasicLocker(envImpl);
        DatabaseImpl idDatabaseImpl = envImpl.getDbTree().getIdDatabaseImpl();
        try {
            LockResult lockResult = locker.nonBlockingLock(lsn, LockType.WRITE, false, idDatabaseImpl);
            if (lockResult.getLockGrant() != LockGrantType.DENIED && this.isEvictableInexact()) {
                evictable = true;
            }
        }
        finally {
            locker.operationEnd();
        }
        return evictable;
    }

    @Override
    public void postFetchInit(DatabaseImpl db, long sourceLsn) {
        this.databaseImpl.setEnvironmentImpl(db.getDbEnvironment());
    }

    @Override
    public long getMemorySizeIncludedByParent() {
        return MemoryBudget.MAPLN_OVERHEAD;
    }

    @Override
    public void releaseMemoryBudget() {
        this.databaseImpl.releaseTreeAdminMemory();
    }

    @Override
    public long getTreeAdminMemory() {
        return this.databaseImpl.getTreeAdminMemory();
    }

    @Override
    public String toString() {
        return this.dumpString(0, true);
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.dumpString(nSpaces, dumpTags));
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<deleted val=\"").append(Boolean.toString(this.deleted));
        sb.append("\">");
        sb.append('\n');
        sb.append(this.databaseImpl.dumpString(nSpaces));
        return sb.toString();
    }

    @Override
    protected LogEntryType getLogType(boolean isInsert, boolean isTransactional) {
        return isTransactional ? LogEntryType.LOG_MAPLN_TRANSACTIONAL : LogEntryType.LOG_MAPLN;
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + this.databaseImpl.getLogSize() + 1;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        this.databaseImpl.writeToLog(logBuffer);
        byte booleans = (byte)(this.deleted ? 1 : 0);
        logBuffer.put(booleans);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        super.readFromLog(itemBuffer, entryVersion);
        this.databaseImpl.readFromLog(itemBuffer, entryVersion);
        byte booleans = itemBuffer.get();
        this.deleted = (booleans & 1) != 0;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    @Override
    protected void dumpLogAdditional(StringBuilder sb, boolean verbose) {
        this.databaseImpl.dumpLog(sb, verbose);
    }
}

