/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint.net;

import com.sleepycat.je.rep.net.InstanceLogger;
import com.sleepycat.je.rep.net.SSLAuthenticator;
import com.sleepycat.je.rep.utilint.net.AbstractDataChannel;
import java.io.IOException;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SSLDataChannel
extends AbstractDataChannel {
    private final SSLEngine sslEngine;
    private final ByteBuffer netRecvBuffer;
    private final ByteBuffer netXmitBuffer;
    private final ByteBuffer appRecvBuffer;
    private final ByteBuffer emptyXmitBuffer;
    private final ReentrantLock readLock = new ReentrantLock();
    private final ReentrantLock writeLock = new ReentrantLock();
    private boolean channelClosed = false;
    private volatile boolean sslInboundClosed = false;
    private final String targetHost;
    private final SSLAuthenticator authenticator;
    private final HostnameVerifier hostVerifier;
    private volatile boolean peerTrusted = false;
    private final InstanceLogger logger;

    public SSLDataChannel(SocketChannel socketChannel, SSLEngine sslEngine, String targetHost, HostnameVerifier hostVerifier, SSLAuthenticator authenticator, InstanceLogger logger) {
        super(socketChannel);
        this.sslEngine = sslEngine;
        this.targetHost = targetHost;
        this.authenticator = authenticator;
        this.hostVerifier = hostVerifier;
        this.logger = logger;
        SSLSession sslSession = sslEngine.getSession();
        int netBufferSize = sslSession.getPacketBufferSize();
        int appBufferSize = sslSession.getApplicationBufferSize();
        this.emptyXmitBuffer = ByteBuffer.allocate(1);
        this.netXmitBuffer = ByteBuffer.allocate(3 * netBufferSize);
        this.appRecvBuffer = ByteBuffer.allocate(2 * appBufferSize);
        this.netRecvBuffer = ByteBuffer.allocate(2 * netBufferSize);
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public boolean isTrustCapable() {
        return this.authenticator != null;
    }

    @Override
    public boolean isTrusted() {
        return this.peerTrusted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer toFill) throws IOException, SSLException {
        if (toFill.remaining() <= 0) {
            return 0;
        }
        if (!this.socketChannel.isBlocking()) {
            this.flush_internal();
        }
        this.readLock.lock();
        try {
            if (this.appRecvBuffer.position() > 0) {
                this.appRecvBuffer.flip();
                int count = this.transfer(this.appRecvBuffer, toFill);
                this.appRecvBuffer.compact();
                int n = count;
                return n;
            }
        }
        finally {
            this.readLock.unlock();
        }
        int readCount = 0;
        while (readCount == 0) {
            if (this.sslEngine.isInboundDone()) {
                return -1;
            }
            this.processAnyHandshakes();
            this.readLock.lock();
            try {
                if (this.appRecvBuffer.position() > 0) {
                    this.appRecvBuffer.flip();
                    readCount = this.transfer(this.appRecvBuffer, toFill);
                    this.appRecvBuffer.compact();
                    break;
                }
            }
            finally {
                this.readLock.unlock();
            }
            if (this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
            boolean progress = false;
            this.readLock.lock();
            try {
                if (this.netRecvBuffer.position() > 0) {
                    int initialPos = this.netRecvBuffer.position();
                    this.netRecvBuffer.flip();
                    SSLEngineResult engineResult = this.sslEngine.unwrap(this.netRecvBuffer, this.appRecvBuffer);
                    this.netRecvBuffer.compact();
                    int updatedPos = this.netRecvBuffer.position();
                    if (updatedPos != initialPos) {
                        progress = true;
                    }
                    switch (engineResult.getStatus()) {
                        case BUFFER_UNDERFLOW: {
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            throw new BufferOverflowException();
                        }
                        case CLOSED: {
                            this.socketChannel.socket().shutdownInput();
                            break;
                        }
                    }
                }
                if (progress) continue;
                int count = this.socketChannel.read(this.netRecvBuffer);
                if (count < 0) {
                    readCount = count;
                    continue;
                }
                if (count != 0) continue;
                break;
            }
            finally {
                this.readLock.unlock();
            }
        }
        if (readCount < 0) {
            this.sslEngine.closeInbound();
            this.sslInboundClosed = true;
        }
        if (this.sslEngine.isInboundDone()) {
            return -1;
        }
        return readCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int write(ByteBuffer toSend) throws IOException, SSLException {
        toSendCount = toSend.remaining();
        if (toSendCount == 0) {
            return 0;
        }
        this.flush_internal();
        do {
            this.writeLock.lock();
            try {
                engineResult = this.sslEngine.wrap(toSend, this.netXmitBuffer);
                switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[engineResult.getStatus().ordinal()]) {
                    case 2: {
                        ** break;
lbl13:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        throw new BufferUnderflowException();
                    }
                    case 3: {
                        throw new SSLException("Attempt to write to a closed SSL Channel");
                    }
                    ** default:
lbl19:
                    // 1 sources

                    break;
                }
            }
            finally {
                this.writeLock.unlock();
            }
            this.processAnyHandshakes();
            this.flush_internal();
        } while (toSend.remaining() != 0 && this.socketChannel.isBlocking());
        return toSendCount - toSend.remaining();
    }

    @Override
    public boolean flush() throws IOException {
        this.flush_internal();
        if (this.writeLock.tryLock()) {
            try {
                if (this.netXmitBuffer.position() == 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int flush_internal() throws IOException {
        int count = 0;
        if (this.writeLock.tryLock()) {
            try {
                if (this.netXmitBuffer.position() == 0) {
                    int n = 0;
                    return n;
                }
                this.netXmitBuffer.flip();
                try {
                    count = this.socketChannel.write(this.netXmitBuffer);
                }
                finally {
                    this.netXmitBuffer.compact();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException, SSLException {
        try {
            this.flush_internal();
            if (!this.sslEngine.isOutboundDone()) {
                this.sslEngine.closeOutbound();
                this.processAnyHandshakes();
            } else if (!this.sslEngine.isInboundDone() && this.sslInboundClosed) {
                this.processOneHandshake();
            }
        }
        finally {
            SSLDataChannel sSLDataChannel = this;
            synchronized (sSLDataChannel) {
                if (!this.channelClosed) {
                    this.channelClosed = true;
                    this.socketChannel.close();
                }
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    private int transfer(ByteBuffer src, ByteBuffer dst) {
        int transferred;
        int space = dst.remaining();
        if (src.remaining() > space) {
            ByteBuffer slice = src.slice();
            slice.limit(space);
            dst.put(slice);
            src.position(src.position() + space);
            transferred = space;
        } else {
            transferred = src.remaining();
            dst.put(src);
        }
        return transferred;
    }

    private void processAnyHandshakes() throws IOException {
        while (this.processOneHandshake()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processOneHandshake() throws IOException {
        int readCount = 0;
        int flushCount = 0;
        SSLEngineResult engineResult = null;
        switch (this.sslEngine.getHandshakeStatus()) {
            case FINISHED: {
                return false;
            }
            case NEED_TASK: {
                this.runDelegatedTasks();
                return true;
            }
            case NEED_UNWRAP: {
                boolean unwrapped = false;
                try {
                    this.flush_internal();
                }
                catch (SocketException se) {
                    // empty catch block
                }
                this.readLock.lock();
                try {
                    if (this.netRecvBuffer.position() > 0) {
                        this.netRecvBuffer.flip();
                        engineResult = this.sslEngine.unwrap(this.netRecvBuffer, this.appRecvBuffer);
                        this.netRecvBuffer.compact();
                        if (engineResult.getStatus() == SSLEngineResult.Status.OK) {
                            unwrapped = true;
                        }
                    }
                    if (unwrapped || this.sslEngine.isInboundDone()) break;
                    readCount = this.socketChannel.read(this.netRecvBuffer);
                    if (readCount < 0) {
                        try {
                            this.sslEngine.closeInbound();
                            this.sslInboundClosed = true;
                        }
                        catch (SSLException ssle) {
                            // empty catch block
                        }
                    }
                    this.netRecvBuffer.flip();
                    engineResult = this.sslEngine.unwrap(this.netRecvBuffer, this.appRecvBuffer);
                    this.netRecvBuffer.compact();
                    break;
                }
                finally {
                    this.readLock.unlock();
                }
            }
            case NEED_WRAP: {
                this.writeLock.lock();
                try {
                    engineResult = this.sslEngine.wrap(this.emptyXmitBuffer, this.netXmitBuffer);
                }
                finally {
                    this.writeLock.unlock();
                }
                if (engineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                    try {
                        this.flush_internal();
                    }
                    catch (SocketException se) {}
                    break;
                }
                flushCount = this.flush_internal();
                break;
            }
            case NOT_HANDSHAKING: {
                return false;
            }
        }
        if (engineResult == null) return true;
        if (engineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            if (this.sslEngine.getUseClientMode()) {
                if (this.hostVerifier != null) {
                    this.peerTrusted = this.hostVerifier.verify(this.targetHost, this.sslEngine.getSession());
                    if (!this.peerTrusted) {
                        this.logger.log(Level.INFO, "SSL host verifier reports that connection target is NOT valid");
                        throw new IOException("Server identity could not be verified");
                    }
                    this.logger.log(Level.FINE, "SSL host verifier reports that connection target is valid");
                }
            } else if (this.authenticator != null) {
                this.peerTrusted = this.authenticator.isTrusted(this.sslEngine.getSession());
                if (this.peerTrusted) {
                    this.logger.log(Level.FINE, "SSL authenticator reports that channel is trusted");
                } else {
                    this.logger.log(Level.INFO, "SSL authenticator reports that channel is NOT trusted");
                }
            }
        }
        switch (engineResult.getStatus()) {
            case BUFFER_UNDERFLOW: {
                if (readCount <= 0) return false;
                return true;
            }
            case BUFFER_OVERFLOW: {
                if (this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP) return false;
                if (flushCount <= 0) return false;
                return true;
            }
            case CLOSED: {
                if (!this.sslEngine.isOutboundDone()) return false;
                try {
                    this.socketChannel.socket().shutdownOutput();
                    return false;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return false;
            }
        }
        return true;
    }

    private void runDelegatedTasks() {
        Runnable task;
        while ((task = this.sslEngine.getDelegatedTask()) != null) {
            task.run();
        }
    }
}

