/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.SizeAwaitMapStatDefinition;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SizeAwaitMap<K, V>
implements Map<K, V> {
    private final EnvironmentImpl envImpl;
    private final Predicate<V> predicate;
    private final HashMap<Integer, RepUtils.ExceptionAwareCountDownLatch> thresholdLatches;
    private final Map<K, V> map = new HashMap();
    private int count = 0;
    private final StatGroup stats;
    private final LongStat nNoWaits;
    private final LongStat nRealWaits;
    private final LongStat nWaitTime;

    public SizeAwaitMap(EnvironmentImpl envImpl, Predicate<V> predicate) {
        this.envImpl = envImpl;
        this.predicate = predicate;
        this.thresholdLatches = new HashMap();
        this.stats = new StatGroup("SizeAwaitMap", "SizeAwaitMap statistics");
        this.nNoWaits = new LongStat(this.stats, SizeAwaitMapStatDefinition.N_NO_WAITS);
        this.nRealWaits = new LongStat(this.stats, SizeAwaitMapStatDefinition.N_REAL_WAITS);
        this.nWaitTime = new LongStat(this.stats, SizeAwaitMapStatDefinition.N_WAIT_TIME);
    }

    public StatGroup getStatistics() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sizeAwait(int thresholdSize, long timeout, TimeUnit unit) throws InterruptedException {
        assert (thresholdSize >= 0);
        RepUtils.ExceptionAwareCountDownLatch l = null;
        SizeAwaitMap sizeAwaitMap = this;
        synchronized (sizeAwaitMap) {
            if (thresholdSize <= this.count) {
                this.nNoWaits.increment();
                return true;
            }
            l = this.thresholdLatches.get(thresholdSize);
            if (l == null) {
                l = new RepUtils.ExceptionAwareCountDownLatch(this.envImpl, 1);
                this.thresholdLatches.put(thresholdSize, l);
            }
        }
        this.nRealWaits.increment();
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = l.awaitOrException(timeout, unit);
            return bl;
        }
        finally {
            this.nWaitTime.add(System.currentTimeMillis() - startTime);
        }
    }

    synchronized int latchCount() {
        return this.thresholdLatches.size();
    }

    @Override
    public synchronized V put(K key, V value) {
        CountDownLatch l;
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        int countDelta = this.checkPredicate(value) ? 1 : 0;
        V oldValue = this.map.put(key, value);
        if (oldValue != null && this.checkPredicate(oldValue)) {
            --countDelta;
        }
        this.count += countDelta;
        if (countDelta > 0 && (l = (CountDownLatch)this.thresholdLatches.remove(this.count)) != null) {
            l.countDown();
        }
        return oldValue;
    }

    private boolean checkPredicate(V value) {
        return this.predicate == null || this.predicate.match(value);
    }

    @Override
    public synchronized V remove(Object key) {
        V oldValue = this.map.remove(key);
        if (oldValue != null && this.checkPredicate(oldValue)) {
            --this.count;
        }
        return oldValue;
    }

    @Override
    @Deprecated
    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public synchronized void clear(Exception cause) {
        for (RepUtils.ExceptionAwareCountDownLatch l : this.thresholdLatches.values()) {
            l.releaseAwait(cause);
        }
        this.thresholdLatches.clear();
        this.map.clear();
        this.count = 0;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.map.containsKey(value);
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public synchronized V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw EnvironmentFailureException.unexpectedState("putAll not supported");
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public synchronized Collection<V> values() {
        return this.map.values();
    }

    public static interface Predicate<V> {
        public boolean match(V var1);
    }
}

