/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.FeederManager;
import com.sleepycat.je.rep.impl.node.FeederManagerStatDefinition;
import com.sleepycat.je.rep.impl.node.LocalCBVLSNUpdater;
import com.sleepycat.je.rep.impl.node.MasterTransfer;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.stream.FeederReplicaHandshake;
import com.sleepycat.je.rep.stream.FeederReplicaSyncup;
import com.sleepycat.je.rep.stream.FeederSource;
import com.sleepycat.je.rep.stream.MasterFeederSource;
import com.sleepycat.je.rep.stream.MasterStatus;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.txn.MasterTxn;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.LongMaxZeroStat;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.rep.utilint.NamedChannelWithTimeout;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.je.utilint.StringStat;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Feeder {
    private int heartbeatInterval;
    private final FeederManager feederManager;
    private final RepNode repNode;
    private final RepImpl repImpl;
    private final NamedChannelWithTimeout feederReplicaChannel;
    private final InputThread inputThread;
    private final OutputThread outputThread;
    private final FeederSource feederSource;
    private int protocolVersion;
    private VLSN feederVLSN;
    private volatile VLSN replicaTxnEndVLSN = VLSN.NULL_VLSN;
    private volatile long lastResponseTime = 0L;
    private volatile MasterTransfer masterXfr;
    private volatile boolean caughtUp = false;
    private final MasterStatus masterStatus;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final Logger logger;
    private final NameIdPair nameIdPair;
    private NameIdPair replicaNameIdPair = NameIdPair.NULL;
    private volatile int replicaLogVersion = 0;
    private volatile JEVersion replicaJEVersion = null;
    private volatile RepNodeImpl replicaNode = null;
    private volatile TestHook<BinaryProtocol.Message> writeMessageHook;
    private static volatile TestHook<BinaryProtocol.Message> initialWriteMessageHook;
    private static long sprayAfterNMessagesCount;

    private NamedChannelWithTimeout configureChannel(DataChannel channel) throws IOException {
        try {
            channel.getSocketChannel().configureBlocking(true);
            LoggerUtils.info(this.logger, this.repImpl, "Feeder accepted connection from " + channel);
            int timeoutMs = this.repNode.getConfigManager().getDuration(RepParams.PRE_HEARTBEAT_TIMEOUT);
            boolean tcpNoDelay = this.repNode.getConfigManager().getBoolean(RepParams.FEEDER_TCP_NO_DELAY);
            channel.getSocketChannel().socket().setTcpNoDelay(tcpNoDelay);
            return new NamedChannelWithTimeout(this.repNode, channel, timeoutMs);
        }
        catch (IOException e) {
            LoggerUtils.warning(this.logger, this.repImpl, "IO exception while configuring channel Exception:" + e.getMessage());
            throw e;
        }
    }

    Feeder(FeederManager feederManager, DataChannel dataChannel) throws DatabaseException, IOException {
        this.feederManager = feederManager;
        this.repNode = feederManager.repNode();
        this.repImpl = this.repNode.getRepImpl();
        this.masterStatus = this.repNode.getMasterStatus();
        this.nameIdPair = this.repNode.getNameIdPair();
        this.feederSource = new MasterFeederSource(this.repNode.getRepImpl(), this.repNode.getVLSNIndex(), this.nameIdPair);
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.feederReplicaChannel = this.configureChannel(dataChannel);
        this.inputThread = new InputThread(this.repNode.getRepImpl());
        this.outputThread = new OutputThread(this.repNode.getRepImpl());
        this.heartbeatInterval = feederManager.repNode().getHeartbeatInterval();
        this.writeMessageHook = initialWriteMessageHook;
    }

    void startFeederThreads() {
        this.inputThread.start();
    }

    public Feeder() {
        this.feederManager = null;
        this.repNode = null;
        this.repImpl = null;
        this.masterStatus = null;
        this.feederSource = null;
        this.feederReplicaChannel = null;
        this.nameIdPair = NameIdPair.NULL;
        this.logger = LoggerUtils.getLoggerFixedPrefix(this.getClass(), "TestFeeder");
        this.inputThread = null;
        this.outputThread = null;
        this.shutdown.set(true);
        this.writeMessageHook = initialWriteMessageHook;
    }

    public StatGroup getProtocolStats(StatsConfig config) {
        Protocol protocol = this.outputThread.protocol;
        return protocol != null ? protocol.getStats(config) : new StatGroup("BinaryProtocol", "Network traffic due to the replication stream.");
    }

    void resetStats() {
        Protocol protocol = this.outputThread.protocol;
        if (protocol != null) {
            protocol.resetStats();
        }
    }

    void setMasterTransfer(MasterTransfer mt) {
        this.masterXfr = mt;
        if (this.caughtUp) {
            this.adviseMasterTransferProgress();
        }
    }

    void adviseMasterTransferProgress() {
        MasterTransfer mt = this.masterXfr;
        if (mt != null) {
            mt.noteProgress(new MasterTransfer.VLSNProgress(this.replicaTxnEndVLSN, this.replicaNameIdPair.getName()));
        }
    }

    public RepNode getRepNode() {
        return this.repNode;
    }

    public NameIdPair getReplicaNameIdPair() {
        return this.replicaNameIdPair;
    }

    public VLSN getReplicaTxnEndVLSN() {
        return this.replicaTxnEndVLSN;
    }

    public JEVersion getReplicaJEVersion() {
        return this.replicaJEVersion;
    }

    public RepNodeImpl getReplicaNode() {
        return this.replicaNode;
    }

    void shutdown(Exception shutdownException) {
        StatGroup pstats;
        boolean changed = this.shutdown.compareAndSet(false, true);
        if (!changed) {
            return;
        }
        MasterTransfer mt = this.masterXfr;
        if (mt != null) {
            mt.giveUp(this.replicaNameIdPair.getName());
        }
        this.feederManager.removeFeeder(this);
        StatGroup statGroup = pstats = this.inputThread.protocol != null ? this.inputThread.protocol.getStats(StatsConfig.DEFAULT) : new StatGroup("BinaryProtocol", "Network traffic due to the replication stream.");
        if (this.outputThread.protocol != null) {
            pstats.addAll(this.outputThread.protocol.getStats(StatsConfig.DEFAULT));
        }
        this.feederManager.incStats(pstats);
        LoggerUtils.info(this.logger, this.repImpl, "Shutting down feeder for replica " + this.replicaNameIdPair.getName() + (shutdownException == null ? "" : " Reason: " + shutdownException.getMessage()) + RepUtils.writeTimesString(pstats));
        if (this.repNode.getReplicaCloseCatchupMs() >= 0L) {
            try {
                this.inputThread.join();
            }
            catch (InterruptedException e) {
                LoggerUtils.warning(this.logger, this.repImpl, "Interrupted while waiting to join thread:" + this.outputThread);
            }
        }
        this.outputThread.shutdownThread(this.logger);
        this.inputThread.shutdownThread(this.logger);
        LoggerUtils.finest(this.logger, this.repImpl, this.feederReplicaChannel + " isOpen=" + this.feederReplicaChannel.getChannel().isOpen());
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public static void setSprayAfterNMessagesCount(long sANMC) {
        sprayAfterNMessagesCount = sANMC;
    }

    private void deemAcked(long txnId) {
        VLSN commitVLSN = this.repNode.getFeederTxns().noteReplicaAck(this.replicaNode, txnId);
        if (commitVLSN != null) {
            if (commitVLSN.compareTo(this.replicaTxnEndVLSN) > 0) {
                this.replicaTxnEndVLSN = commitVLSN;
            }
            this.caughtUp = true;
            this.adviseMasterTransferProgress();
        }
    }

    public String dumpState() {
        return "feederVLSN=" + this.feederVLSN + " replicaTxnEndVLSN=" + this.replicaTxnEndVLSN + (this.replicaNode != null && !this.replicaNode.getType().isElectable() ? " nodeType=" + (Object)((Object)this.replicaNode.getType()) : "");
    }

    public void setWriteMessageHook(TestHook<BinaryProtocol.Message> writeMessageHook) {
        this.writeMessageHook = writeMessageHook;
    }

    public TestHook<BinaryProtocol.Message> getWriteMessageHook() {
        return this.writeMessageHook;
    }

    public static void setInitialWriteMessageHook(TestHook<BinaryProtocol.Message> initialWriteMessageHook) {
        Feeder.initialWriteMessageHook = initialWriteMessageHook;
    }

    static {
        sprayAfterNMessagesCount = 0L;
    }

    public static class ExitException
    extends Exception {
        public ExitException(String message) {
            super(message);
        }

        public ExitException(Throwable cause) {
            super(cause);
        }
    }

    private class IOThreadsHandler
    implements Thread.UncaughtExceptionHandler {
        private IOThreadsHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LoggerUtils.severe(Feeder.this.logger, Feeder.this.repImpl, "Uncaught exception in feeder thread " + t + e.getMessage() + LoggerUtils.getStackTrace(e));
            Feeder.this.feederManager.setRepNodeShutdownException(EnvironmentFailureException.promote(Feeder.this.repNode.getRepImpl(), EnvironmentFailureReason.UNCAUGHT_EXCEPTION, "Uncaught exception in feeder thread:" + t, e));
            Feeder.this.repNode.interrupt();
        }
    }

    private class OutputThread
    extends StoppableThread {
        private long lastHeartbeat;
        Protocol protocol;
        private long totalTransferDelay;
        private long shutdownRequestStart;
        private final RepImpl threadRepImpl;
        private final boolean commitToNetwork;
        private final int transferLoggingThresholdMs;
        private final LongMaxZeroStat nMaxReplicaLag;
        private final StringStat nMaxReplicaLagName;

        OutputThread(RepImpl repImpl) {
            super(repImpl, new IOThreadsHandler(), "Feeder Output");
            this.lastHeartbeat = 0L;
            this.protocol = null;
            this.totalTransferDelay = 0L;
            this.shutdownRequestStart = 0L;
            this.threadRepImpl = repImpl;
            DbConfigManager configManager = Feeder.this.repNode.getConfigManager();
            this.commitToNetwork = configManager.getBoolean(RepParams.COMMIT_TO_NETWORK);
            this.transferLoggingThresholdMs = configManager.getDuration(RepParams.TRANSFER_LOGGING_THRESHOLD);
            if (Feeder.this.feederManager != null) {
                this.nMaxReplicaLag = Feeder.this.feederManager.getnMaxReplicaLag();
                this.nMaxReplicaLagName = Feeder.this.feederManager.getnMaxReplicaLagName();
            } else {
                StatGroup stats = new StatGroup("FeederManager", "A feeder is a replication stream connection between a master and replica nodes.");
                this.nMaxReplicaLag = new LongMaxZeroStat(stats, FeederManagerStatDefinition.N_MAX_REPLICA_LAG);
                this.nMaxReplicaLagName = new StringStat(stats, FeederManagerStatDefinition.N_MAX_REPLICA_LAG_NAME);
            }
        }

        private boolean checkShutdown() throws IOException {
            if (!Feeder.this.shutdown.get()) {
                return false;
            }
            if (Feeder.this.repNode.getReplicaCloseCatchupMs() >= 0L) {
                boolean timedOut;
                if (this.shutdownRequestStart == 0L) {
                    this.shutdownRequestStart = System.currentTimeMillis();
                }
                boolean bl = timedOut = System.currentTimeMillis() - this.shutdownRequestStart > Feeder.this.repNode.getReplicaCloseCatchupMs();
                if (!timedOut && Feeder.this.feederVLSN.compareTo(Feeder.this.repNode.getCurrentTxnEndVLSN()) < 0) {
                    return false;
                }
                Protocol protocol = this.protocol;
                protocol.getClass();
                this.writeMessage(new Protocol.ShutdownRequest(protocol, this.shutdownRequestStart), Feeder.this.feederReplicaChannel);
                String shutdownMessage = String.format("Shutdown message sent to: %s  Shutdown elapsed time: %,dms", Feeder.this.replicaNameIdPair, System.currentTimeMillis() - this.shutdownRequestStart);
                LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, shutdownMessage);
                return true;
            }
            return true;
        }

        private void writeMessage(BinaryProtocol.Message message, NamedChannel namedChannel) throws IOException {
            assert (TestHookExecute.doHookIfSet(Feeder.this.writeMessageHook, message));
            this.protocol.write(message, namedChannel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.protocol = Protocol.get(Feeder.this.repNode, Feeder.this.protocolVersion, Feeder.this.protocolVersion, Feeder.this.replicaLogVersion);
            Thread.currentThread().setName("Feeder Output for " + Feeder.this.getReplicaNameIdPair().getName());
            int testDelayMs = Feeder.this.feederManager.getTestDelayMs();
            if (testDelayMs > 0) {
                LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, "Test delay of:" + testDelayMs + "ms." + " after each message sent");
            }
            VLSNRange range = Feeder.this.repNode.getVLSNIndex().getRange();
            LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, String.format("Feeder output thread for replica %s started at VLSN %,d master at %,d VLSN delta=%,d socket=%s", Feeder.this.replicaNameIdPair.getName(), Feeder.this.feederVLSN.getSequence(), range.getLast().getSequence(), range.getLast().getSequence() - Feeder.this.feederVLSN.getSequence(), Feeder.this.feederReplicaChannel));
            Error feederOutputError = null;
            Exception shutdownException = null;
            try {
                this.sendHeartbeat();
                int timeoutMs = Feeder.this.repNode.getConfigManager().getDuration(RepParams.FEEDER_TIMEOUT);
                Feeder.this.feederReplicaChannel.setTimeoutMs(timeoutMs);
                while (!this.checkShutdown()) {
                    if (Feeder.this.feederVLSN.compareTo(Feeder.this.repNode.getCurrentTxnEndVLSN()) >= 0) {
                        Feeder.this.repNode.getArbiter().endArbitration();
                    }
                    OutputWireRecord record = Feeder.this.feederSource.getWireRecord(Feeder.this.feederVLSN, Feeder.this.heartbeatInterval);
                    Feeder.this.masterStatus.assertSync();
                    if (record == null) {
                        this.sendHeartbeat();
                    } else {
                        long txnId;
                        BinaryProtocol.Message entry = this.createMessage(record);
                        this.validate(record);
                        this.maybeSpray(entry, record);
                        this.writeMessage(entry, Feeder.this.feederReplicaChannel);
                        if (this.commitToNetwork && (txnId = record.getCommitTxnId()) != 0L) {
                            Feeder.this.deemAcked(txnId);
                        }
                        this.sendHeartbeat();
                        Feeder.this.feederVLSN = Feeder.this.feederVLSN.getNext();
                    }
                    if (testDelayMs <= 0) continue;
                    Thread.sleep(testDelayMs);
                }
            }
            catch (IOException e) {
                shutdownException = e;
            }
            catch (MasterStatus.MasterSyncException e) {
                shutdownException = e;
            }
            catch (InterruptedException e) {
                shutdownException = e;
            }
            catch (RuntimeException e) {
                shutdownException = e;
                LoggerUtils.severe(Feeder.this.logger, this.threadRepImpl, "Unexpected exception: " + e.getMessage() + LoggerUtils.getStackTrace(e));
                throw e;
            }
            catch (Error e) {
                feederOutputError = e;
                Feeder.this.repNode.getRepImpl().invalidate(e);
            }
            finally {
                if (feederOutputError != null) {
                    throw feederOutputError;
                }
                LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, "Feeder output for replica " + Feeder.this.replicaNameIdPair.getName() + " shutdown. feeder VLSN: " + Feeder.this.feederVLSN + " currentTxnEndVLSN: " + Feeder.this.repNode.getCurrentTxnEndVLSN());
                Feeder.this.shutdown(shutdownException);
                this.cleanup();
            }
        }

        final void maybeSpray(BinaryProtocol.Message entry, OutputWireRecord record) throws IOException {
            if (--sprayAfterNMessagesCount == 0L) {
                LogEntryType entryType = LogEntryType.findType(record.getEntryType());
                if (!entryType.isUserLNType() || !entryType.isTransactional()) {
                    sprayAfterNMessagesCount++;
                    return;
                }
                LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, "Initiating message spray: " + entry);
                while (true) {
                    this.writeMessage(entry, Feeder.this.feederReplicaChannel);
                }
            }
        }

        private void sendHeartbeat() throws IOException {
            long now = System.currentTimeMillis();
            long interval = now - this.lastHeartbeat;
            if (interval <= (long)Feeder.this.heartbeatInterval) {
                return;
            }
            VLSN vlsn = Feeder.this.repNode.getCurrentTxnEndVLSN();
            Protocol protocol = this.protocol;
            protocol.getClass();
            this.writeMessage(new Protocol.Heartbeat(protocol, now, vlsn.getSequence()), Feeder.this.feederReplicaChannel);
            this.lastHeartbeat = now;
            long lag = vlsn.getSequence() - Feeder.this.feederVLSN.getSequence();
            if (this.nMaxReplicaLag.setMax(lag)) {
                this.nMaxReplicaLagName.set(Feeder.this.replicaNameIdPair.getName());
            }
        }

        @Override
        protected int initiateSoftShutdown() {
            RepUtils.shutdownChannel(Feeder.this.feederReplicaChannel);
            return Feeder.this.repNode.getThreadWaitInterval();
        }

        private BinaryProtocol.Message createMessage(OutputWireRecord wireRecord) throws DatabaseException {
            boolean needsAck;
            long txnId = wireRecord.getCommitTxnId();
            if (txnId == 0L) {
                Protocol protocol = this.protocol;
                protocol.getClass();
                return new Protocol.Entry(protocol, wireRecord);
            }
            MasterTxn ackTxn = Feeder.this.repNode.getFeederTxns().getAckTxn(txnId);
            Durability.SyncPolicy replicaSync = Durability.SyncPolicy.NO_SYNC;
            if (ackTxn != null) {
                ackTxn.stampRepWriteTime();
                long messageTransferMs = ackTxn.messageTransferMs();
                this.totalTransferDelay += messageTransferMs;
                if (messageTransferMs > (long)this.transferLoggingThresholdMs) {
                    String message = String.format("Feeder for: %s, Txn: %,d  log to rep stream time %,dms. Total transfer time: %,dms.", Feeder.this.replicaNameIdPair.getName(), txnId, messageTransferMs, this.totalTransferDelay);
                    LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, message);
                }
                needsAck = !this.commitToNetwork && Feeder.this.repNode.getDurabilityQuorum().replicaAcksQualify(Feeder.this.replicaNode);
                replicaSync = ackTxn.getCommitDurability().getReplicaSync();
            } else {
                needsAck = false;
                replicaSync = Durability.SyncPolicy.NO_SYNC;
            }
            Protocol protocol = this.protocol;
            protocol.getClass();
            return new Protocol.Commit(protocol, needsAck, replicaSync, wireRecord);
        }

        private void validate(OutputWireRecord record) {
            if (!record.getVLSN().equals(Feeder.this.feederVLSN)) {
                throw EnvironmentFailureException.unexpectedState("Expected VLSN:" + Feeder.this.feederVLSN + " log entry VLSN:" + record.getVLSN());
            }
            if (!this.threadRepImpl.isRepConverted()) assert (record.verifyNegativeSequences("node=" + Feeder.this.nameIdPair));
        }

        @Override
        protected Logger getLogger() {
            return Feeder.this.logger;
        }
    }

    private class InputThread
    extends StoppableThread {
        Protocol protocol;
        private LocalCBVLSNUpdater replicaCBVLSN;

        InputThread(RepImpl repImpl) {
            super(repImpl, new IOThreadsHandler(), "Feeder Input");
            this.protocol = null;
        }

        @Override
        public void run() {
            Error feederInputError = null;
            Exception shutdownException = null;
            try {
                FeederReplicaHandshake handshake = new FeederReplicaHandshake(Feeder.this.repNode, Feeder.this, Feeder.this.feederReplicaChannel);
                this.protocol = handshake.execute();
                Feeder.this.protocolVersion = this.protocol.getVersion();
                Feeder.this.replicaNameIdPair = handshake.getReplicaNameIdPair();
                Feeder.this.replicaLogVersion = handshake.getReplicaLogVersion();
                Feeder.this.replicaJEVersion = handshake.getReplicaJEVersion();
                Feeder.this.replicaNode = handshake.getReplicaNode();
                Thread.currentThread().setName("Feeder Input for " + Feeder.this.replicaNameIdPair.getName());
                FeederReplicaSyncup syncup = new FeederReplicaSyncup(Feeder.this, Feeder.this.feederReplicaChannel, this.protocol);
                this.replicaCBVLSN = new LocalCBVLSNUpdater(Feeder.this.replicaNameIdPair, Feeder.this.replicaNode.getType(), Feeder.this.repNode);
                VLSN startVLSN = syncup.execute(this.replicaCBVLSN);
                Feeder.this.replicaTxnEndVLSN = startVLSN.getPrev();
                if (Feeder.this.replicaTxnEndVLSN.compareTo(Feeder.this.repNode.getCurrentTxnEndVLSN()) >= 0) {
                    Feeder.this.caughtUp = true;
                }
                Feeder.this.feederVLSN = startVLSN;
                Feeder.this.feederSource.init(Feeder.this.feederVLSN);
                Feeder.this.outputThread.start();
                Feeder.this.lastResponseTime = System.currentTimeMillis();
                Feeder.this.masterStatus.assertSync();
                Feeder.this.feederManager.activateFeeder(Feeder.this);
                this.runResponseLoop();
            }
            catch (FeederReplicaSyncup.NetworkRestoreException e) {
                shutdownException = e;
                LoggerUtils.info(Feeder.this.logger, Feeder.this.repImpl, e.getMessage());
            }
            catch (IOException e) {
                shutdownException = e;
            }
            catch (MasterStatus.MasterSyncException e) {
                shutdownException = e;
            }
            catch (InterruptedException e) {
                shutdownException = e;
            }
            catch (ExitException e) {
                shutdownException = e;
                LoggerUtils.warning(Feeder.this.logger, Feeder.this.repImpl, "Exiting feeder loop: " + e.getMessage());
            }
            catch (Error e) {
                feederInputError = e;
                Feeder.this.repNode.getRepImpl().invalidate(e);
            }
            catch (ChecksumException e) {
                shutdownException = e;
                throw new EnvironmentFailureException((EnvironmentImpl)Feeder.this.repNode.getRepImpl(), EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
            }
            catch (RuntimeException e) {
                shutdownException = e;
                LoggerUtils.severe(Feeder.this.logger, Feeder.this.repImpl, "Unexpected exception: " + e.getMessage() + LoggerUtils.getStackTrace(e));
                throw e;
            }
            finally {
                if (feederInputError != null) {
                    throw feederInputError;
                }
                Feeder.this.shutdown(shutdownException);
                this.cleanup();
            }
        }

        private void runResponseLoop() throws IOException, MasterStatus.MasterSyncException {
            while (!this.checkShutdown()) {
                BinaryProtocol.Message response = this.protocol.read(Feeder.this.feederReplicaChannel);
                if (this.checkShutdown()) break;
                Feeder.this.masterStatus.assertSync();
                Feeder.this.lastResponseTime = System.currentTimeMillis();
                if (response.getOp() == Protocol.HEARTBEAT_RESPONSE) {
                    Protocol.HeartbeatResponse hbResponse = (Protocol.HeartbeatResponse)response;
                    this.replicaCBVLSN.updateForReplica(hbResponse);
                    VLSN reportedVLSN = hbResponse.getTxnEndVLSN();
                    if (reportedVLSN == null) continue;
                    Feeder.this.replicaTxnEndVLSN = reportedVLSN;
                    if (Feeder.this.replicaTxnEndVLSN.compareTo(Feeder.this.repNode.getCurrentTxnEndVLSN()) < 0) continue;
                    Feeder.this.caughtUp = true;
                    Feeder.this.adviseMasterTransferProgress();
                    continue;
                }
                if (response.getOp() == Protocol.ACK) {
                    long txnId = ((Protocol.Ack)response).getTxnId();
                    if (Feeder.this.logger.isLoggable(Level.FINE)) {
                        LoggerUtils.fine(Feeder.this.logger, Feeder.this.repImpl, "Ack for: " + txnId);
                    }
                    Feeder.this.deemAcked(txnId);
                    continue;
                }
                if (response.getOp() == Protocol.SHUTDOWN_RESPONSE) {
                    LoggerUtils.info(Feeder.this.logger, Feeder.this.repImpl, "Shutdown confirmed by replica " + Feeder.this.replicaNameIdPair.getName());
                    break;
                }
                throw EnvironmentFailureException.unexpectedState("Unexpected message: " + response);
            }
        }

        private boolean checkShutdown() {
            return Feeder.this.shutdown.get() && Feeder.this.repNode.getReplicaCloseCatchupMs() < 0L;
        }

        @Override
        protected int initiateSoftShutdown() {
            RepUtils.shutdownChannel(Feeder.this.feederReplicaChannel);
            return Feeder.this.repNode.getThreadWaitInterval();
        }

        @Override
        protected Logger getLogger() {
            return Feeder.this.logger;
        }
    }
}

