/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.FeederManager;
import com.sleepycat.je.rep.impl.node.FeederManagerStatDefinition;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.ReplayStatDefinition;
import com.sleepycat.je.rep.impl.node.Replica;
import com.sleepycat.je.rep.impl.node.ReplicaStatDefinition;
import com.sleepycat.je.rep.stream.FeederTxnStatDefinition;
import com.sleepycat.je.rep.utilint.BinaryProtocolStatDefinition;
import com.sleepycat.je.utilint.IntegralLongAvgStat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ReplicatedEnvironmentStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int VALUE_UNAVAILABLE = -1;
    private StatGroup feederManagerStats;
    private StatGroup feederTxnStats;
    private StatGroup replayStats;
    private StatGroup trackerStats;
    private StatGroup protocolStats;
    private StatGroup vlsnIndexStats;
    private final Map<String, String> tipsMap = new HashMap<String, String>();

    ReplicatedEnvironmentStats(RepImpl repImpl, StatsConfig config) {
        RepNode repNode = repImpl.getRepNode();
        FeederManager feederManager = repNode.feederManager();
        this.feederManagerStats = feederManager.getFeederManagerStats(config);
        this.feederTxnStats = repNode.getFeederTxns().getStats(config);
        Replica replica = repNode.getReplica();
        this.replayStats = replica.getReplayStats(config);
        this.trackerStats = replica.getTrackerStats(config);
        this.protocolStats = feederManager.getProtocolStats(config);
        this.vlsnIndexStats = repImpl.getVLSNIndex().getStats(config);
        this.protocolStats.addAll(replica.getProtocolStats(config));
        this.addMessageRateStats();
        this.addBytesRateStats();
    }

    public ReplicatedEnvironmentStats() {
    }

    public Collection<StatGroup> getStatGroups() {
        return this.feederTxnStats != null ? Arrays.asList(this.feederManagerStats, this.feederTxnStats, this.replayStats, this.trackerStats, this.protocolStats, this.vlsnIndexStats) : Arrays.asList(this.feederManagerStats, this.replayStats, this.trackerStats, this.protocolStats, this.vlsnIndexStats);
    }

    public Map<String, StatGroup> getStatGroupsMap() {
        HashMap<String, StatGroup> statmap = new HashMap<String, StatGroup>();
        statmap.put(this.feederManagerStats.getName(), this.feederManagerStats);
        statmap.put(this.replayStats.getName(), this.replayStats);
        statmap.put(this.trackerStats.getName(), this.trackerStats);
        statmap.put(this.protocolStats.getName(), this.protocolStats);
        statmap.put(this.vlsnIndexStats.getName(), this.vlsnIndexStats);
        if (this.feederTxnStats != null) {
            statmap.put(this.feederTxnStats.getName(), this.feederTxnStats);
        }
        return statmap;
    }

    public void setStatGroup(StatGroup sg) {
        if (sg.getName().equals("FeederManager")) {
            this.feederManagerStats = sg;
        } else if (sg.getName().equals("Replay")) {
            this.replayStats = sg;
        } else if (sg.getName().equals("ConsistencyTracker")) {
            this.trackerStats = sg;
        } else if (sg.getName().equals("BinaryProtocol")) {
            this.protocolStats = sg;
        } else if (sg.getName().equals("VLSNIndex")) {
            this.vlsnIndexStats = sg;
        } else if (sg.getName().equals("FeederTxns")) {
            this.feederTxnStats = sg;
        } else {
            throw EnvironmentFailureException.unexpectedState("Internal error stat context is not registered");
        }
    }

    public static String[] getStatGroupTitles() {
        return new String[]{"FeederManager", "FeederTxns", "BinaryProtocol", "Replay", "ConsistencyTracker", "VLSNIndex"};
    }

    private void addMessageRateStats() {
        long numerator = this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_MESSAGES_READ) == null ? 0L : this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_MESSAGES_READ).get();
        long denominator = this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_READ_NANOS) == null ? 0L : this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_READ_NANOS).get();
        IntegralLongAvgStat msgReadRate = new IntegralLongAvgStat(this.protocolStats, BinaryProtocolStatDefinition.MESSAGE_READ_RATE, numerator, denominator, 1000000000L);
        numerator = this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_MESSAGES_WRITTEN) == null ? 0L : this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_MESSAGES_WRITTEN).get();
        denominator = this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_WRITE_NANOS) == null ? 0L : this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_WRITE_NANOS).get();
        IntegralLongAvgStat msgWriteRate = new IntegralLongAvgStat(this.protocolStats, BinaryProtocolStatDefinition.MESSAGE_WRITE_RATE, numerator, denominator, 1000000000L);
    }

    private void addBytesRateStats() {
        long numerator = this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_BYTES_READ) == null ? 0L : this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_BYTES_READ).get();
        long denominator = this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_READ_NANOS) == null ? 0L : this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_READ_NANOS).get();
        IntegralLongAvgStat bytesReadRate = new IntegralLongAvgStat(this.protocolStats, BinaryProtocolStatDefinition.BYTES_READ_RATE, numerator, denominator, 1000000000L);
        numerator = this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_BYTES_WRITTEN) == null ? 0L : this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_BYTES_WRITTEN).get();
        denominator = this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_WRITE_NANOS) == null ? 0L : this.protocolStats.getLongStat(BinaryProtocolStatDefinition.N_WRITE_NANOS).get();
        IntegralLongAvgStat bytesWriteRate = new IntegralLongAvgStat(this.protocolStats, BinaryProtocolStatDefinition.BYTES_WRITE_RATE, numerator, denominator, 1000000000L);
    }

    public int getNFeedersCreated() {
        return this.feederManagerStats.getInt(FeederManagerStatDefinition.N_FEEDERS_CREATED);
    }

    public int getNFeedersShutdown() {
        return this.feederManagerStats.getInt(FeederManagerStatDefinition.N_FEEDERS_SHUTDOWN);
    }

    public long getNMaxReplicaLag() {
        return this.feederManagerStats.getLong(FeederManagerStatDefinition.N_MAX_REPLICA_LAG);
    }

    public String getNMaxReplicaLagName() {
        return this.feederManagerStats.getString(FeederManagerStatDefinition.N_MAX_REPLICA_LAG_NAME);
    }

    public long getNTxnsAcked() {
        return this.feederTxnStats == null ? -1L : this.feederTxnStats.getAtomicLong(FeederTxnStatDefinition.TXNS_ACKED);
    }

    public long getNTxnsNotAcked() {
        return this.feederTxnStats == null ? -1L : this.feederTxnStats.getAtomicLong(FeederTxnStatDefinition.TXNS_NOT_ACKED);
    }

    public long getTotalTxnMs() {
        return this.feederTxnStats == null ? -1L : this.feederTxnStats.getAtomicLong(FeederTxnStatDefinition.TOTAL_TXN_MS);
    }

    public long getAckWaitMs() {
        return this.feederTxnStats == null ? -1L : this.feederTxnStats.getAtomicLong(FeederTxnStatDefinition.ACK_WAIT_MS);
    }

    public long getNReplayCommits() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMITS);
    }

    public long getNReplayCommitAcks() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_ACKS);
    }

    public long getNReplayCommitSyncs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_SYNCS);
    }

    public long getNReplayCommitNoSyncs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_NO_SYNCS);
    }

    public long getNReplayCommitWriteNoSyncs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_WRITE_NO_SYNCS);
    }

    public long getNReplayAborts() {
        return this.replayStats.getLong(ReplayStatDefinition.N_ABORTS);
    }

    public long getNReplayNameLNs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_NAME_LNS);
    }

    public long getNReplayLNs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_LNS);
    }

    public long getReplayElapsedTxnTime() {
        return this.replayStats.getLong(ReplayStatDefinition.N_ELAPSED_TXN_TIME);
    }

    public long getNReplayGroupCommitTimeouts() {
        return this.replayStats.getLong(ReplayStatDefinition.N_GROUP_COMMIT_TIMEOUTS);
    }

    public long getNReplayGroupCommitMaxExceeded() {
        return this.replayStats.getLong(ReplayStatDefinition.N_GROUP_COMMIT_MAX_EXCEEDED);
    }

    public long getNReplayGroupCommitTxns() {
        return this.replayStats.getLong(ReplayStatDefinition.N_GROUP_COMMIT_TXNS);
    }

    public long getNReplayGroupCommits() {
        return this.replayStats.getLong(ReplayStatDefinition.N_GROUP_COMMITS);
    }

    public long getReplayMinCommitProcessingNanos() {
        return this.replayStats.getLong(ReplayStatDefinition.MIN_COMMIT_PROCESSING_NANOS);
    }

    public long getReplayMaxCommitProcessingNanos() {
        return this.replayStats.getLong(ReplayStatDefinition.MAX_COMMIT_PROCESSING_NANOS);
    }

    public long getReplayTotalCommitProcessingNanos() {
        return this.replayStats.getLong(ReplayStatDefinition.TOTAL_COMMIT_PROCESSING_NANOS);
    }

    public long getReplayTotalCommitLagMs() {
        return this.replayStats.getLong(ReplayStatDefinition.TOTAL_COMMIT_LAG_MS);
    }

    public long getReplayLatestCommitLagMs() {
        return this.replayStats.getLong(ReplayStatDefinition.LATEST_COMMIT_LAG_MS);
    }

    public long getNProtocolBytesRead() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_BYTES_READ);
    }

    public long getNProtocolMessagesRead() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_MESSAGES_READ);
    }

    public long getNProtocolBytesWritten() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_BYTES_WRITTEN);
    }

    public long getNProtocolMessagesWritten() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_MESSAGES_WRITTEN);
    }

    public long getProtocolReadNanos() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_READ_NANOS);
    }

    public long getProtocolWriteNanos() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_WRITE_NANOS);
    }

    public long getProtocolMessageReadRate() {
        IntegralLongAvgStat rstat = this.protocolStats.getIntegralLongAvgStat(BinaryProtocolStatDefinition.MESSAGE_READ_RATE);
        return rstat != null ? rstat.get().longValue() : 0L;
    }

    public long getProtocolMessageWriteRate() {
        IntegralLongAvgStat rstat = this.protocolStats.getIntegralLongAvgStat(BinaryProtocolStatDefinition.MESSAGE_WRITE_RATE);
        return rstat != null ? rstat.get().longValue() : 0L;
    }

    public long getProtocolBytesReadRate() {
        IntegralLongAvgStat rstat = this.protocolStats.getIntegralLongAvgStat(BinaryProtocolStatDefinition.BYTES_READ_RATE);
        return rstat != null ? rstat.get().longValue() : 0L;
    }

    public long getProtocolBytesWriteRate() {
        IntegralLongAvgStat rstat = this.protocolStats.getIntegralLongAvgStat(BinaryProtocolStatDefinition.BYTES_WRITE_RATE);
        return rstat != null ? rstat.get().longValue() : 0L;
    }

    public long getNProtocolEntriesWrittenOldVersion() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_ENTRIES_WRITTEN_OLD_VERSION);
    }

    public long getTrackerLagConsistencyWaits() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_LAG_CONSISTENCY_WAITS);
    }

    public long getTrackerLagConsistencyWaitMs() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_LAG_CONSISTENCY_WAIT_MS);
    }

    public long getTrackerVLSNConsistencyWaits() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAITS);
    }

    public long getTrackerVLSNConsistencyWaitMs() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAIT_MS);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (StatGroup group : this.getStatGroups()) {
            sb.append(group.toString());
        }
        return sb.toString();
    }

    public String toStringVerbose() {
        StringBuilder sb = new StringBuilder();
        for (StatGroup group : this.getStatGroups()) {
            sb.append(group.toStringVerbose());
        }
        return sb.toString();
    }

    public Map<String, String> getTips() {
        for (StatGroup group : this.getStatGroups()) {
            this.tipsMap.put(group.getName(), group.getDescription());
            for (StatDefinition def : group.getStats().keySet()) {
                this.tipsMap.put(def.getName(), def.getDescription());
            }
        }
        return this.tipsMap;
    }
}

