/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.CheckpointStart;
import com.sleepycat.je.recovery.CheckpointStatDefinition;
import com.sleepycat.je.recovery.DirtyINMap;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INLogContext;
import com.sleepycat.je.tree.INLogItem;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LSNStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;

public class Checkpointer
extends DaemonThread
implements EnvConfigObserver {
    private static final boolean MULTI_LOG = true;
    public static TestHook maxFlushLevelHook = null;
    public static TestHook beforeFlushHook = null;
    public static TestHook<IN> examineINForCheckpointHook = null;
    private EnvironmentImpl envImpl;
    private long checkpointId;
    private final long logSizeBytesInterval;
    private final long logFileMax;
    private final long timeInterval;
    private long lastCheckpointMillis;
    private boolean highPriority;
    private long nCheckpoints;
    private long lastCheckpointStart;
    private long lastCheckpointEnd;
    private long lastCheckpointInterval;
    private final FlushStats flushStats;
    private final DirtyINMap checkpointDirtyMap;

    public Checkpointer(EnvironmentImpl envImpl, long waitTime, String name) {
        super(waitTime, name, envImpl);
        this.envImpl = envImpl;
        this.logSizeBytesInterval = envImpl.getConfigManager().getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        this.logFileMax = envImpl.getConfigManager().getLong(EnvironmentParams.LOG_FILE_MAX);
        this.timeInterval = waitTime;
        this.lastCheckpointMillis = 0L;
        this.nCheckpoints = 0L;
        this.flushStats = new FlushStats();
        this.checkpointDirtyMap = new DirtyINMap(envImpl);
        this.envConfigUpdate(envImpl.getConfigManager(), null);
        envImpl.addConfigObserver(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager cm, EnvironmentMutableConfig ignore) {
        this.highPriority = cm.getBoolean(EnvironmentParams.CHECKPOINTER_HIGH_PRIORITY);
    }

    public void initIntervals(long lastCheckpointStart, long lastCheckpointEnd, long lastCheckpointMillis) {
        this.lastCheckpointStart = lastCheckpointStart;
        this.lastCheckpointEnd = lastCheckpointEnd;
        this.lastCheckpointMillis = lastCheckpointMillis;
    }

    public boolean coordinateEvictionWithCheckpoint(IN target, IN parent) {
        return this.checkpointDirtyMap.coordinateEvictionWithCheckpoint(target, parent);
    }

    public static long getWakeupPeriod(DbConfigManager configManager) throws IllegalArgumentException {
        long wakeupPeriod = configManager.getDuration(EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL);
        long bytePeriod = configManager.getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        if (wakeupPeriod == 0L && bytePeriod == 0L) {
            throw new IllegalArgumentException(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL.getName() + " and " + EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL.getName() + " cannot both be 0. ");
        }
        if (bytePeriod == 0L) {
            return wakeupPeriod;
        }
        return 0L;
    }

    public synchronized void setCheckpointId(long lastCheckpointId) {
        this.checkpointId = lastCheckpointId;
    }

    public StatGroup loadStats(StatsConfig config) {
        StatGroup stats = new StatGroup("Checkpoints", "Frequency and extent of checkpointing activity.");
        new LongStat(stats, CheckpointStatDefinition.CKPT_LAST_CKPTID, this.checkpointId);
        new LongStat(stats, CheckpointStatDefinition.CKPT_CHECKPOINTS, this.nCheckpoints);
        new LSNStat(stats, CheckpointStatDefinition.CKPT_LAST_CKPT_INTERVAL, this.lastCheckpointInterval);
        new LSNStat(stats, CheckpointStatDefinition.CKPT_LAST_CKPT_START, this.lastCheckpointStart);
        new LSNStat(stats, CheckpointStatDefinition.CKPT_LAST_CKPT_END, this.lastCheckpointEnd);
        new LongStat(stats, CheckpointStatDefinition.CKPT_FULL_IN_FLUSH, this.flushStats.nFullINFlush);
        new LongStat(stats, CheckpointStatDefinition.CKPT_FULL_BIN_FLUSH, this.flushStats.nFullBINFlush);
        new LongStat(stats, CheckpointStatDefinition.CKPT_DELTA_IN_FLUSH, this.flushStats.nDeltaINFlush);
        if (config.getClear()) {
            this.nCheckpoints = 0L;
            this.flushStats.nFullINFlush = 0L;
            this.flushStats.nFullBINFlush = 0L;
            this.flushStats.nDeltaINFlush = 0L;
        }
        return stats;
    }

    public synchronized void clearEnv() {
        this.envImpl = null;
    }

    @Override
    protected long nDeadlockRetries() {
        return this.envImpl.getConfigManager().getInt(EnvironmentParams.CHECKPOINTER_RETRY);
    }

    @Override
    protected void onWakeup() throws DatabaseException {
        if (this.envImpl.isClosed()) {
            return;
        }
        this.doCheckpoint(CheckpointConfig.DEFAULT, "daemon");
    }

    public void wakeupAfterWrite() {
        long nextLsn;
        if (this.logSizeBytesInterval != 0L && !this.isRunning() && DbLsn.getNoCleaningDistance(nextLsn = this.envImpl.getFileManager().getNextLsn(), this.lastCheckpointStart, this.logFileMax) >= this.logSizeBytesInterval) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunnable(CheckpointConfig config) {
        long useBytesInterval = 0L;
        long useTimeInterval = 0L;
        long nextLsn = -1L;
        boolean runnable = false;
        try {
            if (config.getForce()) {
                boolean bl = runnable = true;
                return bl;
            }
            if (config.getKBytes() != 0) {
                useBytesInterval = config.getKBytes() << 10;
            } else if (config.getMinutes() != 0) {
                useTimeInterval = config.getMinutes() * 60 * 1000;
            } else if (this.logSizeBytesInterval != 0L) {
                useBytesInterval = this.logSizeBytesInterval;
            } else {
                useTimeInterval = this.timeInterval;
            }
            if (useBytesInterval != 0L) {
                nextLsn = this.envImpl.getFileManager().getNextLsn();
                if (DbLsn.getNoCleaningDistance(nextLsn, this.lastCheckpointStart, this.logFileMax) >= useBytesInterval) {
                    runnable = true;
                }
            } else if (useTimeInterval != 0L) {
                long lastUsedLsn = this.envImpl.getFileManager().getLastUsedLsn();
                if (System.currentTimeMillis() - this.lastCheckpointMillis >= useTimeInterval && DbLsn.compareTo(lastUsedLsn, this.lastCheckpointEnd) != 0) {
                    runnable = true;
                }
            }
            boolean bl = runnable;
            return bl;
        }
        finally {
            StringBuilder sb = new StringBuilder();
            sb.append("size interval=").append(useBytesInterval);
            if (nextLsn != -1L) {
                sb.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
            }
            if (this.lastCheckpointEnd != -1L) {
                sb.append(" lastCkpt=");
                sb.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
            }
            sb.append(" time interval=").append(useTimeInterval);
            sb.append(" force=").append(config.getForce());
            sb.append(" runnable=").append(runnable);
            LoggerUtils.finest(this.logger, this.envImpl, sb.toString());
        }
    }

    public synchronized void doCheckpoint(CheckpointConfig config, String invokingSource) throws DatabaseException {
        if (this.envImpl.isReadOnly()) {
            return;
        }
        if (!this.isRunnable(config)) {
            return;
        }
        boolean flushAll = config.getMinimizeRecoveryTime();
        boolean allowDeltas = true;
        boolean flushExtraLevel = false;
        Cleaner cleaner = this.envImpl.getCleaner();
        FileSelector.CheckpointStartCleanerState cleanerState = cleaner.getFilesAtCheckpointStart();
        if (!cleanerState.isEmpty()) {
            flushExtraLevel = true;
        }
        this.lastCheckpointMillis = System.currentTimeMillis();
        this.flushStats.resetPerRunCounters();
        ++this.checkpointId;
        ++this.nCheckpoints;
        boolean success = false;
        boolean traced = false;
        LogManager logManager = this.envImpl.getLogManager();
        this.checkpointDirtyMap.beginCheckpoint(flushAll, flushExtraLevel);
        try {
            long checkpointStart = -1L;
            long firstActiveLsn = -1L;
            SingleItemEntry<CheckpointStart> startEntry = SingleItemEntry.create(LogEntryType.LOG_CKPT_START, new CheckpointStart(this.checkpointId, invokingSource));
            checkpointStart = logManager.log(startEntry, ReplicationContext.NO_REPLICATE);
            firstActiveLsn = this.envImpl.getTxnManager().getFirstActiveLsn();
            if (firstActiveLsn == -1L) {
                firstActiveLsn = checkpointStart;
            }
            this.envImpl.awaitVLSNConsistency();
            this.checkpointDirtyMap.selectDirtyINsForCheckpoint();
            TestHookExecute.doHookIfSet(beforeFlushHook);
            Checkpointer.flushDirtyNodes(this.envImpl, this.checkpointDirtyMap, true, checkpointStart, this.highPriority, this.flushStats);
            this.checkpointDirtyMap.flushMapLNs(checkpointStart);
            this.checkpointDirtyMap.flushRoot(checkpointStart);
            this.envImpl.preCheckpointEndFlush();
            this.envImpl.getUtilizationProfile().flushFileUtilization(this.envImpl.getUtilizationTracker().getTrackedFiles());
            DbTree dbTree = this.envImpl.getDbTree();
            boolean willDeleteFiles = !cleanerState.isEmpty();
            CheckpointEnd ckptEnd = new CheckpointEnd(invokingSource, checkpointStart, this.envImpl.getRootLsn(), firstActiveLsn, this.envImpl.getNodeSequence().getLastLocalNodeId(), this.envImpl.getNodeSequence().getLastReplicatedNodeId(), dbTree.getLastLocalDbId(), dbTree.getLastReplicatedDbId(), this.envImpl.getTxnManager().getLastLocalTxnId(), this.envImpl.getTxnManager().getLastReplicatedTxnId(), this.checkpointId, willDeleteFiles, cleaner.getLogSummary());
            SingleItemEntry<CheckpointEnd> endEntry = SingleItemEntry.create(LogEntryType.LOG_CKPT_END, ckptEnd);
            this.trace(this.envImpl, invokingSource, true);
            traced = true;
            this.lastCheckpointInterval = DbLsn.getNoCleaningDistance(checkpointStart, this.lastCheckpointStart, this.logFileMax);
            this.lastCheckpointEnd = logManager.logForceFlush(endEntry, true, ReplicationContext.NO_REPLICATE);
            this.lastCheckpointStart = checkpointStart;
            success = true;
            cleaner.updateFilesAtCheckpointEnd(cleanerState);
        }
        catch (DatabaseException e) {
            LoggerUtils.traceAndLogException(this.envImpl, "Checkpointer", "doCheckpoint", "checkpointId=" + this.checkpointId, e);
            throw e;
        }
        finally {
            this.checkpointDirtyMap.reset();
            if (!traced) {
                this.trace(this.envImpl, invokingSource, success);
            }
        }
    }

    private void trace(EnvironmentImpl envImpl, String invokingSource, boolean success) {
        StringBuilder sb = new StringBuilder();
        sb.append("Checkpoint ").append(this.checkpointId);
        sb.append(": source=").append(invokingSource);
        sb.append(" success=").append(success);
        sb.append(" nFullINFlushThisRun=");
        sb.append(this.flushStats.nFullINFlushThisRun);
        sb.append(" nDeltaINFlushThisRun=");
        sb.append(this.flushStats.nDeltaINFlushThisRun);
        LoggerUtils.logMsg(this.logger, envImpl, Level.CONFIG, sb.toString());
    }

    public void syncDatabase(EnvironmentImpl envImpl, DatabaseImpl dbImpl, boolean flushLog) throws DatabaseException {
        if (envImpl.isReadOnly()) {
            return;
        }
        DirtyINMap dirtyMap = new DirtyINMap(envImpl);
        FlushStats fstats = new FlushStats();
        try {
            dirtyMap.selectDirtyINsForDbSync(dbImpl);
            if (dirtyMap.getNumEntries() > 0) {
                Checkpointer.flushDirtyNodes(envImpl, dirtyMap, false, -1L, false, fstats);
                if (flushLog) {
                    envImpl.getLogManager().flush();
                }
            }
        }
        catch (DatabaseException e) {
            LoggerUtils.traceAndLogException(envImpl, "Checkpointer", "syncDatabase", "of " + dbImpl.getDebugName(), e);
            throw e;
        }
        finally {
            dirtyMap.reset();
        }
    }

    public static void setMaxFlushLevelHook(TestHook hook) {
        maxFlushLevelHook = hook;
    }

    public static void setBeforeFlushHook(TestHook hook) {
        beforeFlushHook = hook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushDirtyNodes(EnvironmentImpl envImpl, DirtyINMap dirtyMap, boolean allowDeltas, long checkpointStart, boolean highPriority, FlushStats fstats) throws DatabaseException {
        LogManager logManager = envImpl.getLogManager();
        DbTree dbTree = envImpl.getDbTree();
        HashMap<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
        try {
            while (dirtyMap.getNumLevels() > 0) {
                CheckpointReference targetRef;
                Integer currentLevel = dirtyMap.getLowestLevelSet();
                int currentLevelVal = currentLevel;
                if (currentLevelVal == 131072) {
                    dirtyMap.flushMapLNs(checkpointStart);
                }
                while ((targetRef = dirtyMap.removeNextNode(currentLevel)) != null) {
                    int maxFlushLevel;
                    DatabaseImpl db = dbTree.getDb(targetRef.dbId, -1L, dbCache);
                    if (db != null && !db.isDeleted() && currentLevelVal <= (maxFlushLevel = dirtyMap.getHighestFlushLevel(db))) {
                        Checkpointer.flushIN(envImpl, db, logManager, targetRef, dirtyMap, currentLevelVal, maxFlushLevel, allowDeltas, highPriority, fstats, true);
                        envImpl.sleepAfterBackgroundIO();
                    }
                    envImpl.checkIfInvalid();
                }
                dirtyMap.removeLevel(currentLevel);
            }
        }
        finally {
            dbTree.releaseDbs(dbCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushIN(EnvironmentImpl envImpl, DatabaseImpl db, LogManager logManager, CheckpointReference targetRef, DirtyINMap dirtyMap, int currentLevel, int maxFlushLevel, boolean allowDeltas, boolean highPriority, FlushStats fstats, boolean allowLogSubtree) throws DatabaseException {
        assert (currentLevel < maxFlushLevel || TestHookExecute.doHookIfSet(maxFlushLevelHook));
        Tree tree = db.getTree();
        boolean targetWasRoot = false;
        if (targetRef.isDbRoot) {
            RootFlusher flusher = new RootFlusher(db, logManager, targetRef.nodeId);
            tree.withRootLatchedExclusive(flusher);
            boolean flushed = flusher.getFlushed();
            targetWasRoot = flusher.stillRoot();
            if (flushed) {
                DbTree dbTree = envImpl.getDbTree();
                dbTree.modifyDbRoot(db);
                ++fstats.nFullINFlushThisRun;
                ++fstats.nFullINFlush;
            }
        }
        if (!targetWasRoot) {
            SearchResult result = tree.getParentINForChildIN(targetRef.nodeId, false, targetRef.treeKey, false, CacheMode.UNCHANGED, -1, null, false);
            if (result.parent != null) {
                CheckpointReference parentRef;
                boolean bottomLevelTarget;
                IN parent = result.parent;
                int parentLevel = parent.getLevel();
                boolean mustLogParent = false;
                boolean bl = bottomLevelTarget = (parentLevel & 0xFFFF) == 2;
                Provisional provisional = currentLevel >= maxFlushLevel ? Provisional.NO : (bottomLevelTarget ? Provisional.YES : Provisional.BEFORE_CKPT_END);
                boolean logSubtree = bottomLevelTarget && allowLogSubtree;
                boolean logSiblingsWithParentLatchHeld = logSubtree && highPriority && !db.isDurableDeferredWrite();
                boolean logTargetWithOtherSiblings = false;
                TreeMap<Long, Integer> siblingsToLog = null;
                try {
                    if (result.exactParentFound) {
                        IN renewedTarget = (IN)parent.getTargetAllowBINDelta(result.index);
                        if (renewedTarget == null) {
                            mustLogParent |= true;
                        } else if (logSiblingsWithParentLatchHeld) {
                            logTargetWithOtherSiblings = true;
                        } else {
                            mustLogParent |= Checkpointer.logSiblings(envImpl, dirtyMap, parent, Collections.singleton(result.index), allowDeltas, highPriority, provisional, fstats);
                        }
                    } else {
                        logSubtree = false;
                        if (result.childNotResident && parentLevel > currentLevel) {
                            mustLogParent |= true;
                        }
                    }
                    if (logSubtree) {
                        siblingsToLog = new TreeMap<Long, Integer>();
                        for (int index = 0; index < parent.getNEntries(); ++index) {
                            IN child = (IN)parent.getTargetAllowBINDelta(index);
                            if (child == null) continue;
                            Long childId = child.getNodeId();
                            if ((!logTargetWithOtherSiblings || targetRef.nodeId != childId) && !dirtyMap.containsNode(child.getLevel(), childId)) continue;
                            siblingsToLog.put(childId, index);
                        }
                        if (logSiblingsWithParentLatchHeld) {
                            mustLogParent |= Checkpointer.logSiblings(envImpl, dirtyMap, parent, siblingsToLog.values(), allowDeltas, highPriority, provisional, fstats);
                            siblingsToLog = null;
                        }
                    }
                    if (mustLogParent) {
                        assert (Checkpointer.checkParentChildRelationship(result, currentLevel)) : Checkpointer.dumpParentChildInfo(result, parent, targetRef.nodeId, currentLevel, tree);
                        dirtyMap.addIN(parent, true);
                    }
                }
                finally {
                    parent.releaseLatch();
                }
                if (siblingsToLog != null) {
                    assert (logSubtree);
                    assert (!logSiblingsWithParentLatchHeld);
                    Iterator index = siblingsToLog.keySet().iterator();
                    while (index.hasNext()) {
                        long childId = (Long)index.next();
                        assert (targetRef.nodeId != childId);
                        CheckpointReference childRef = dirtyMap.removeNode(currentLevel, childId);
                        if (childRef == null) continue;
                        Checkpointer.flushIN(envImpl, db, logManager, childRef, dirtyMap, currentLevel, maxFlushLevel, allowDeltas, highPriority, fstats, false);
                    }
                }
                if (logSubtree && parentLevel <= maxFlushLevel && (parentRef = dirtyMap.removeNode(parentLevel, parent.getNodeId())) != null) {
                    Checkpointer.flushIN(envImpl, db, logManager, parentRef, dirtyMap, parentLevel, maxFlushLevel, allowDeltas, highPriority, fstats, false);
                }
            }
        }
    }

    private static boolean checkParentChildRelationship(SearchResult result, int childLevel) {
        if (result.childNotResident && !result.exactParentFound) {
            return true;
        }
        return result.parent.getLevel() == childLevel + 1;
    }

    private static String dumpParentChildInfo(SearchResult result, IN parent, long childNodeId, int currentLevel, Tree tree) {
        StringBuilder sb = new StringBuilder();
        sb.append(" result=").append(result);
        sb.append(" parent node=").append(parent.getNodeId());
        sb.append(" level=").append(parent.getLevel());
        sb.append(" child node=").append(childNodeId);
        sb.append(" level=").append(currentLevel);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean logSiblings(EnvironmentImpl envImpl, DirtyINMap dirtyMap, IN parent, Collection<Integer> indicesToLog, boolean allowDeltas, boolean highPriority, Provisional provisional, FlushStats fstats) throws DatabaseException {
        boolean bl;
        LogManager logManager = envImpl.getLogManager();
        INLogContext context = new INLogContext();
        context.nodeDb = parent.getDatabase();
        context.backgroundIO = true;
        context.allowDeltas = allowDeltas;
        context.allowCompress = true;
        boolean mustLogParent = false;
        ArrayList<INLogItem> itemList = new ArrayList<INLogItem>();
        try {
            for (int index : indicesToLog) {
                IN child = (IN)parent.getTargetAllowBINDelta(index);
                dirtyMap.removeNode(child.getLevel(), child.getNodeId());
                child.latch(CacheMode.UNCHANGED);
                INLogItem item = new INLogItem();
                item.parentIndex = index;
                itemList.add(item);
                if (child.getDirty()) {
                    if (child.getDatabase().isDurableDeferredWrite()) {
                        child.logDirtyChildren();
                    }
                    item.provisional = provisional;
                    item.repContext = ReplicationContext.NO_REPLICATE;
                    item.parent = parent;
                    child.beforeLog(logManager, item, context);
                    continue;
                }
                itemList.remove(itemList.size() - 1);
                child.releaseLatch();
                mustLogParent = true;
            }
            LogItem[] itemArray = new LogItem[itemList.size()];
            logManager.multiLog(itemList.toArray(itemArray), context);
            for (INLogItem item : itemList) {
                IN child = (IN)parent.getTargetAllowBINDelta(item.parentIndex);
                child.afterLog(logManager, item, context);
                assert (item.newLsn != -1L);
                parent.updateEntry(item.parentIndex, item.newLsn, 0);
                if (item.isDelta) {
                    ++fstats.nDeltaINFlushThisRun;
                    ++fstats.nDeltaINFlush;
                } else {
                    ++fstats.nFullINFlushThisRun;
                    ++fstats.nFullINFlush;
                    if (child.isBIN()) {
                        ++fstats.nFullBINFlush;
                        ++fstats.nFullBINFlushThisRun;
                    }
                }
                mustLogParent = true;
            }
            bl = mustLogParent;
        }
        catch (Throwable throwable) {
            for (INLogItem item : itemList) {
                IN child = (IN)parent.getTargetAllowBINDelta(item.parentIndex);
                child.releaseLatch();
            }
            throw throwable;
        }
        for (INLogItem item : itemList) {
            IN child = (IN)parent.getTargetAllowBINDelta(item.parentIndex);
            child.releaseLatch();
        }
        return bl;
    }

    public static class FlushStats {
        public long nFullINFlush;
        public long nFullBINFlush;
        public long nDeltaINFlush;
        public long nFullINFlushThisRun;
        public long nFullBINFlushThisRun;
        public long nDeltaINFlushThisRun;

        void resetPerRunCounters() {
            this.nFullINFlushThisRun = 0L;
            this.nFullBINFlushThisRun = 0L;
            this.nDeltaINFlushThisRun = 0L;
        }
    }

    public static class CheckpointReference {
        DatabaseId dbId;
        long nodeId;
        boolean isDbRoot;
        byte[] treeKey;

        public CheckpointReference(DatabaseId dbId, long nodeId, boolean isDbRoot, byte[] treeKey) {
            this.dbId = dbId;
            this.nodeId = nodeId;
            this.isDbRoot = isDbRoot;
            this.treeKey = treeKey;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CheckpointReference)) {
                return false;
            }
            CheckpointReference other = (CheckpointReference)o;
            return this.nodeId == other.nodeId;
        }

        public int hashCode() {
            return (int)this.nodeId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("db=").append(this.dbId);
            sb.append(" nodeId=").append(this.nodeId);
            return sb.toString();
        }
    }

    private static class RootFlusher
    implements WithRootLatched {
        private final DatabaseImpl db;
        private boolean flushed;
        private boolean stillRoot;
        private final LogManager logManager;
        private final long targetNodeId;

        RootFlusher(DatabaseImpl db, LogManager logManager, long targetNodeId) {
            this.db = db;
            this.flushed = false;
            this.logManager = logManager;
            this.targetNodeId = targetNodeId;
            this.stillRoot = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null) {
                return null;
            }
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            rootIN.latch(CacheMode.UNCHANGED);
            try {
                if (rootIN.getNodeId() == this.targetNodeId) {
                    if (rootIN.getDatabase().isDurableDeferredWrite()) {
                        rootIN.logDirtyChildren();
                    }
                    this.stillRoot = true;
                    if (rootIN.getDirty()) {
                        long newLsn = rootIN.log(this.logManager);
                        root.setLsn(newLsn);
                        this.flushed = true;
                    }
                }
            }
            finally {
                rootIN.releaseLatch();
            }
            return null;
        }

        boolean getFlushed() {
            return this.flushed;
        }

        boolean stillRoot() {
            return this.stillRoot;
        }
    }
}

