/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class BINDeltaLogEntry
extends INLogEntry<BIN> {
    public BINDeltaLogEntry(Class<BIN> logClass) {
        super(logClass);
    }

    public BINDeltaLogEntry(BIN bin) {
        super(bin, true);
    }

    @Override
    void readMainItem(BIN bin, ByteBuffer entryBuffer, int logVersion) {
        bin.readDeltasFromLog(entryBuffer, logVersion);
        bin.setLastFullLsn(LogUtils.readPackedLong(entryBuffer));
    }

    @Override
    int getMainItemSize(BIN bin) {
        return bin.getDeltasLogSize() + LogUtils.getPackedLongLogSize(bin.getLastFullVersion());
    }

    @Override
    void writeMainItem(BIN bin, ByteBuffer destBuffer) {
        bin.writeDeltasToLog(destBuffer);
        LogUtils.writePackedLong(destBuffer, this.getLastFullLsn());
    }

    @Override
    public IN getIN(DatabaseImpl dbImpl) {
        return ((BIN)this.getMainItem()).reconstituteBIN(dbImpl);
    }

    public long getLastFullLsn() {
        return ((BIN)this.getMainItem()).getLastFullVersion();
    }

    @Override
    public long getPrevFullLsn() {
        return -1L;
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        super.dumpEntry(sb, verbose);
        if (this.getLastFullLsn() != -1L) {
            sb.append("<lastFullLsn>");
            sb.append(DbLsn.getNoFormatString(this.getLastFullLsn()));
            sb.append("</lastFullLsn>");
        }
        return sb;
    }
}

