/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.evictor.TargetSelector;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class LRUEvictor
extends Evictor {
    private final List<EnvInfo> envInfos;
    private int specialEvictionIndex = 0;
    private final int numLRULists;
    private final boolean useDirtyLRUSet;
    private LRUList[] mixedLRUSet;
    private LRUList[] dirtyLRUSet;
    private int nextMixedLRUList = 0;
    private int nextDirtyLRUList = 0;
    private boolean isEnabled = false;
    private final LongStat nNodesSelected;
    private final IntStat sharedCacheEnvs;
    private static final boolean doTrace = false;
    private static final boolean collectEvictionDebugStats = false;

    public LRUEvictor(EnvironmentImpl envImpl) {
        super(envImpl);
        DbConfigManager configManager = envImpl.getConfigManager();
        this.numLRULists = configManager.getInt(EnvironmentParams.EVICTOR_N_LRU_LISTS);
        this.useDirtyLRUSet = configManager.getBoolean(EnvironmentParams.EVICTOR_USE_DIRTY_LRU);
        this.mixedLRUSet = new LRUList[this.numLRULists];
        this.dirtyLRUSet = new LRUList[this.numLRULists];
        for (int i = 0; i < this.numLRULists; ++i) {
            this.mixedLRUSet[i] = new LRUList(i);
            this.dirtyLRUSet[i] = new LRUList(this.numLRULists + i);
        }
        this.envInfos = this.isShared ? new ArrayList<EnvInfo>() : null;
        this.nNodesSelected = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_SELECTED);
        this.sharedCacheEnvs = new IntStat(this.stats, EvictorStatDefinition.EVICTOR_SHARED_CACHE_ENVS);
    }

    @Override
    public boolean isNewEvictor() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean v) {
        this.isEnabled = v;
    }

    @Override
    public boolean useDirtyLRUSet() {
        return this.useDirtyLRUSet;
    }

    @Override
    public void addBack(IN node) {
        if (this.isEnabled && node.getEnv().getInMemoryINs().isEnabled()) {
            assert (node.getInListResident());
            node.setInDirtyLRU(false);
            this.mixedLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].addBack(node);
        }
    }

    @Override
    public void addFront(IN node) {
        if (this.isEnabled && node.getEnv().getInMemoryINs().isEnabled()) {
            assert (node.getInListResident());
            node.setInDirtyLRU(false);
            this.mixedLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].addFront(node);
        }
    }

    private void dirtyAddBack(IN node) {
        assert (node.isLatchExclusiveOwner());
        assert (node.getInListResident());
        assert (this.useDirtyLRUSet);
        node.setInDirtyLRU(true);
        this.dirtyLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].addBack(node);
    }

    private void dirtyAddFront(IN node) {
        assert (node.isLatchExclusiveOwner());
        assert (node.getInListResident());
        assert (this.useDirtyLRUSet);
        node.setInDirtyLRU(true);
        this.dirtyLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].addFront(node);
    }

    @Override
    public void moveBack(IN node) {
        assert (node.isLatchOwner());
        if (node.isInDirtyLRU()) {
            this.dirtyLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].moveBack(node);
        } else {
            this.mixedLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].moveBack(node);
        }
    }

    @Override
    public void moveFront(IN node) {
        assert (node.isLatchOwner());
        if (node.isInDirtyLRU()) {
            this.dirtyLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].moveFront(node);
        } else {
            this.mixedLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].moveFront(node);
        }
    }

    @Override
    public void remove(IN node) {
        assert (node.isLatchOwner());
        int listId = (int)(node.getNodeId() % (long)this.numLRULists);
        if (node.isInDirtyLRU()) {
            this.dirtyLRUSet[listId].remove(node);
        } else {
            this.mixedLRUSet[listId].remove(node);
        }
    }

    @Override
    public void moveToMixedLRU(IN node) {
        if (this.useDirtyLRUSet) {
            int listId;
            assert (node.isLatchExclusiveOwner());
            if (node.isInDirtyLRU() && this.dirtyLRUSet[listId = (int)(node.getNodeId() % (long)this.numLRULists)].remove(node)) {
                assert (node.getInListResident());
                node.setInDirtyLRU(false);
                this.mixedLRUSet[listId].addBack(node);
            }
        }
    }

    @Override
    public boolean contains(IN node) {
        assert (node.isLatchOwner());
        int listId = (int)(node.getNodeId() % (long)this.numLRULists);
        if (node.isInDirtyLRU()) {
            return this.dirtyLRUSet[listId].contains(node);
        }
        return this.mixedLRUSet[listId].contains(node);
    }

    long getMixedLRUSize() {
        long size = 0L;
        for (int i = 0; i < this.numLRULists; ++i) {
            size += (long)this.mixedLRUSet[i].getSize();
        }
        return size;
    }

    long getDirtyLRUSize() {
        long size = 0L;
        for (int i = 0; i < this.numLRULists; ++i) {
            size += (long)this.dirtyLRUSet[i].getSize();
        }
        return size;
    }

    void getMixedLRUStats(EnvironmentImpl env, LRUDebugStats stats) {
        stats.reset();
        for (int i = 0; i < this.numLRULists; ++i) {
            this.mixedLRUSet[i].getStats(env, stats);
        }
    }

    void getDirtyLRUStats(EnvironmentImpl env, LRUDebugStats stats) {
        stats.reset();
        for (int i = 0; i < this.numLRULists; ++i) {
            this.dirtyLRUSet[i].getStats(env, stats);
        }
    }

    @Override
    TargetSelector makeSelector() {
        return null;
    }

    @Override
    public void doEvictOneIN(IN target, Evictor.EvictionSource source) {
        if (!this.reentrancyGuard.enter()) {
            return;
        }
        try {
            assert (target.isBIN());
            assert (target.isLatchOwner());
            this.remove(target);
            target.releaseLatch();
            this.processTarget(null, target, null, -1, false, source, null);
        }
        finally {
            this.reentrancyGuard.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doEvict(Evictor.EvictionSource source, boolean backgroundIO) throws DatabaseException {
        if (!this.isEnabled) {
            return;
        }
        if (!this.reentrancyGuard.enter()) {
            return;
        }
        try {
            long maxEvictBytes;
            int nBatches;
            boolean progress = true;
            long bytesEvicted = 0L;
            this.numBatches[source.ordinal()].increment();
            EvictionDebugStats evictionStats = null;
            for (nBatches = 0; progress && nBatches < 100 && !this.shutdownRequested.get() && (maxEvictBytes = this.arbiter.getEvictionPledge()) != 0L; ++nBatches) {
                bytesEvicted = this.evictBatch(source, backgroundIO, maxEvictBytes, evictionStats);
                if (bytesEvicted != 0L) continue;
                progress = false;
            }
            if (evictionStats != null) {
                System.out.println(evictionStats.toString());
            }
            if (source == Evictor.EvictionSource.EVICTORTHREAD && this.logger.isLoggable(Level.FINEST)) {
                LoggerUtils.finest(this.logger, this.firstEnvImpl, "Thread evicted " + bytesEvicted + " bytes in " + nBatches + " batches");
            }
        }
        finally {
            this.reentrancyGuard.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long evictBatch(Evictor.EvictionSource source, boolean bgIO, long maxEvictBytes, EvictionDebugStats evictionStats) throws DatabaseException {
        long totalEvictedBytes = 0L;
        boolean inMixedLRUSet = true;
        int numNodesScannedThisBatch = 0;
        long maxNodesScannedThisBatch = this.getMixedLRUSize();
        maxNodesScannedThisBatch += (long)this.numLRULists;
        this.nEvictPasses.increment();
        assert (TestHookExecute.doHookSetupIfSet(this.evictProfile));
        LRUEvictor lRUEvictor = this;
        synchronized (lRUEvictor) {
            if (this.isShared) {
                int numEnvs = this.envInfos.size();
                if (numEnvs > 0) {
                    if (this.specialEvictionIndex >= numEnvs) {
                        this.specialEvictionIndex = 0;
                    }
                    EnvInfo info = this.envInfos.get(this.specialEvictionIndex);
                    ++this.specialEvictionIndex;
                    totalEvictedBytes = info.env.specialEviction();
                }
            } else {
                totalEvictedBytes = this.firstEnvImpl.specialEviction();
            }
        }
        Evictor.DbCache dbCache = new Evictor.DbCache(this.isShared, this.dbCacheClearCount);
        MemoryBudget memBudget = this.firstEnvImpl.getMemoryBudget();
        try {
            while (totalEvictedBytes < maxEvictBytes && (long)numNodesScannedThisBatch < maxNodesScannedThisBatch && this.arbiter.stillNeedsEviction()) {
                if (!this.isShared && !memBudget.isTreeUsageAboveMinimum()) {
                    break;
                }
                IN target = this.getNextTarget(inMixedLRUSet);
                ++numNodesScannedThisBatch;
                if (target != null) {
                    this.nNodesScanned.add(1L);
                    this.nNodesSelected.increment();
                    this.numBatchTargets[source.ordinal()].incrementAndGet();
                    if (evictionStats != null) {
                        evictionStats.incNumSelected();
                    }
                    assert (TestHookExecute.doHookIfSet(this.evictProfile, target));
                    DatabaseImpl targetDb = target.getDatabase();
                    EnvironmentImpl dbEnv = targetDb.getDbEnvironment();
                    DatabaseImpl refreshedDb = dbCache.getDb(dbEnv, targetDb.getId());
                    if (refreshedDb != null && !refreshedDb.isDeleted() && refreshedDb == targetDb) {
                        long evictedBytes = 0L;
                        if (target.isDbRoot()) {
                            RootEvictor rootEvictor = new RootEvictor();
                            rootEvictor.target = target;
                            rootEvictor.backgroundIO = bgIO;
                            rootEvictor.source = source;
                            rootEvictor.stats = evictionStats;
                            targetDb.getTree().withRootLatchedExclusive(rootEvictor);
                            if (rootEvictor.flushed) {
                                dbEnv.getDbTree().modifyDbRoot(targetDb);
                            }
                            evictedBytes = rootEvictor.evictedBytes;
                        } else {
                            evictedBytes = this.processTarget(null, target, null, -1, bgIO, source, evictionStats);
                        }
                        totalEvictedBytes += evictedBytes;
                    } else if (targetDb.isDeleteFinished() && target.getInListResident()) {
                        String inInfo = " IN type=" + target.getLogType() + " id=" + target.getNodeId() + " not expected on INList";
                        String errMsg = refreshedDb == null ? inInfo : "Database " + refreshedDb.getDebugName() + " id=" + refreshedDb.getId() + " rootLsn=" + DbLsn.getNoFormatString(refreshedDb.getTree().getRootLsn()) + ' ' + inInfo;
                        throw EnvironmentFailureException.unexpectedState(errMsg);
                    }
                }
                if ((long)numNodesScannedThisBatch < maxNodesScannedThisBatch || totalEvictedBytes >= maxEvictBytes || !inMixedLRUSet) continue;
                numNodesScannedThisBatch = 0;
                maxNodesScannedThisBatch = this.getDirtyLRUSize();
                maxNodesScannedThisBatch += (long)this.numLRULists;
                inMixedLRUSet = false;
                if (evictionStats == null) continue;
                evictionStats.inMixedLRU = false;
            }
        }
        finally {
            dbCache.releaseDbs(this.firstEnvImpl);
        }
        return totalEvictedBytes;
    }

    private IN getNextTarget(boolean inMixedLRUSet) {
        int listId;
        IN target;
        if (inMixedLRUSet) {
            int listId2;
            IN target2;
            if ((target2 = this.mixedLRUSet[listId2 = Math.abs(this.nextMixedLRUList++) % this.numLRULists].removeFront()) != null) {
                // empty if block
            }
            return target2;
        }
        if ((target = this.dirtyLRUSet[listId = Math.abs(this.nextDirtyLRUList++) % this.numLRULists].removeFront()) != null) {
            // empty if block
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long processTarget(RootEvictor rootEvictor, IN target, IN parent, int index, boolean bgIO, Evictor.EvictionSource source, EvictionDebugStats stats) throws DatabaseException {
        boolean targetIsLatched = false;
        boolean parentIsLatched = false;
        long evictedBytes = 0L;
        if (stats != null) {
            stats.withParent = parent != null || rootEvictor != null;
        }
        try {
            boolean isEvictable;
            DatabaseId dbId2;
            if (parent != null) {
                assert (parent.isLatchExclusiveOwner());
                parentIsLatched = true;
                if (target != parent.getTargetAllowBINDelta(index)) {
                    this.skip(target, stats);
                    long l = 0L;
                    return l;
                }
                target.latch(CacheMode.UNCHANGED);
            } else if (rootEvictor != null) {
                target = rootEvictor.target;
            } else {
                target.latch(CacheMode.UNCHANGED);
            }
            targetIsLatched = true;
            DatabaseImpl db = target.getDatabase();
            EnvironmentImpl dbEnv = db.getDbEnvironment();
            if (!target.getInListResident() || this.contains(target)) {
                this.skip(target, stats);
                long l = 0L;
                return l;
            }
            if (target.getDirty() && dbEnv.isReadOnly()) {
                this.skip(target, stats);
                long l = 0L;
                return l;
            }
            if (dbEnv.getSharedCache()) {
                if (dbEnv.isClosed() || dbEnv.isInvalid()) {
                    this.skip(target, stats);
                    long l = 0L;
                    return l;
                }
                if (!dbEnv.getMemoryBudget().isTreeUsageAboveMinimum()) {
                    this.putBack(target, stats);
                    long l = 0L;
                    return l;
                }
            }
            if (target.isRoot() && ((dbId2 = db.getId()).equals(DbTree.ID_DB_ID) || dbId2.equals(DbTree.NAME_DB_ID))) {
                this.skip(target, stats);
                long l = 0L;
                return l;
            }
            if (target.isUpperIN() && target.hasCachedChildrenFlag()) {
                assert (target.hasResidentChildren());
                this.skip(target, stats);
                long dbId2 = 0L;
                return dbId2;
            }
            if (target.isBIN() && target.getGeneration() == Long.MAX_VALUE) {
                target.setGeneration(0L);
                this.putBack(target, stats);
                long dbId2 = 0L;
                return dbId2;
            }
            for (int i = 0; i < target.getNEntries(); ++i) {
                if (target.getLsn(i) != -1L || target.isResident(i)) continue;
                this.putBack(target, stats);
                long l = 0L;
                return l;
            }
            evictedBytes = target.partialEviction();
            boolean bl = isEvictable = (evictedBytes & 0x4000000000000000L) == 0L;
            if ((evictedBytes &= 0xBFFFFFFFFFFFFFFFL) > 0L && (target.isUpperIN() || source != Evictor.EvictionSource.CACHEMODE)) {
                this.strippedPutBack(target, stats);
                long l = evictedBytes;
                return l;
            }
            if (!isEvictable) {
                this.putBack(target, stats);
                long l = evictedBytes;
                return l;
            }
            if (target.isBIN() && source != Evictor.EvictionSource.CACHEMODE && this.getMutateToBINDeltas() && ((BIN)target).canMutateToBINDelta()) {
                BIN bin = (BIN)target;
                if (parent != null) {
                    assert ((evictedBytes += bin.mutateToBINDelta()) > 0L);
                    this.binDeltaPutBack(target, stats);
                } else {
                    assert (TestHookExecute.doHookIfSet(this.preEvictINHook));
                    targetIsLatched = false;
                    evictedBytes += this.findParentAndRetry(target, bgIO, source, stats);
                }
                long l = evictedBytes;
                return l;
            }
            if ((target.isUpperIN() || source != Evictor.EvictionSource.CACHEMODE) && this.useDirtyLRUSet() && target.getDirty() && !target.isInDirtyLRU()) {
                this.moveToDirtyLRU(target, stats);
                long l = evictedBytes;
                return l;
            }
            if (rootEvictor != null) {
                evictedBytes += this.evictRoot(rootEvictor, bgIO, source, stats);
            } else if (parent != null) {
                evictedBytes += this.evict(target, parent, index, bgIO, source, stats);
            } else {
                assert (TestHookExecute.doHookIfSet(this.preEvictINHook));
                targetIsLatched = false;
                evictedBytes += this.findParentAndRetry(target, bgIO, source, stats);
            }
            long l = evictedBytes;
            return l;
        }
        finally {
            if (targetIsLatched) {
                target.releaseLatch();
            }
            if (parentIsLatched) {
                parent.releaseLatch();
            }
        }
    }

    private void skip(IN target, EvictionDebugStats stats) {
    }

    private void putBack(IN target, EvictionDebugStats stats) {
        if (target.isInDirtyLRU()) {
            this.dirtyAddBack(target);
        } else {
            this.addBack(target);
        }
        if (stats != null) {
            stats.incNumPutBack();
        }
    }

    private void strippedPutBack(IN target, EvictionDebugStats stats) {
        if (target.isInDirtyLRU()) {
            this.dirtyAddBack(target);
        } else {
            this.addBack(target);
        }
        if (stats != null) {
            stats.incNumStripped();
        }
        if (target.isBIN()) {
            this.nBINsStripped.increment();
        }
    }

    private void binDeltaPutBack(IN target, EvictionDebugStats stats) {
        if (target.isInDirtyLRU()) {
            this.dirtyAddBack(target);
        } else {
            this.addBack(target);
        }
        if (stats != null) {
            stats.incNumMutated();
        }
        this.nBINsMutated.increment();
    }

    private void moveToDirtyLRU(IN target, EvictionDebugStats stats) {
        if (stats != null) {
            stats.incNumMoved(target.isBIN());
        }
        this.dirtyAddFront(target);
    }

    private long findParentAndRetry(IN target, boolean backgroundIO, Evictor.EvictionSource source, EvictionDebugStats stats) {
        Tree tree = target.getDatabase().getTree();
        SearchResult result = tree.getParentINForChildIN(target, true, CacheMode.UNCHANGED, -1, null, false);
        if (result.exactParentFound) {
            return this.processTarget(null, target, result.parent, result.index, backgroundIO, source, stats);
        }
        if (result.parent != null) {
            result.parent.releaseLatch();
        }
        return 0L;
    }

    private long evict(IN target, IN parent, int index, boolean backgroundIO, Evictor.EvictionSource source, EvictionDebugStats stats) {
        DatabaseImpl db = target.getDatabase();
        EnvironmentImpl dbEnv = db.getDbEnvironment();
        long targetLsn = -1L;
        boolean newTargetLsn = false;
        if (target.getDirty()) {
            boolean logProvisional = this.coordinateWithCheckpoint(target, parent);
            targetLsn = target.log(dbEnv.getLogManager(), this.allowBinDeltas, true, logProvisional, backgroundIO, parent);
            newTargetLsn = true;
        } else {
            targetLsn = parent.getLsn(index);
        }
        assert (targetLsn != -1L);
        if (targetLsn != -1L) {
            dbEnv.getInMemoryINs().remove(target);
            long evictedBytes = target.getBudgetedMemorySize();
            if (newTargetLsn) {
                parent.updateNode(index, null, targetLsn, 0, null);
            } else {
                parent.updateNode(index, null, null);
            }
            this.nNodesEvicted.increment();
            this.incEvictStats(source, target);
            if (stats != null) {
                stats.incNumEvicted(target.isBIN());
            }
            return evictedBytes;
        }
        this.addBack(target);
        return 0L;
    }

    private long evictRoot(RootEvictor rootEvictor, boolean backgroundIO, Evictor.EvictionSource source, EvictionDebugStats stats) {
        ChildReference rootRef = rootEvictor.rootRef;
        IN target = (IN)rootRef.getTarget();
        DatabaseImpl db = target.getDatabase();
        EnvironmentImpl dbEnv = db.getDbEnvironment();
        INList inList = dbEnv.getInMemoryINs();
        boolean logProvisional = this.coordinateWithCheckpoint(target, null);
        if (target.getDirty()) {
            long newLsn = target.log(dbEnv.getLogManager(), false, false, logProvisional, backgroundIO, null);
            rootRef.setLsn(newLsn);
            rootEvictor.flushed = true;
        }
        inList.remove(target);
        long evictBytes = target.getBudgetedMemorySize();
        rootRef.clearTarget();
        this.nRootNodesEvicted.increment();
        this.incEvictStats(source, target);
        if (stats != null) {
            stats.incNumEvicted(false);
        }
        return evictBytes;
    }

    private boolean coordinateWithCheckpoint(IN target, IN parent) {
        EnvironmentImpl dbEnv = target.getDatabase().getDbEnvironment();
        Checkpointer ckpter = dbEnv.getCheckpointer();
        if (ckpter == null) {
            return false;
        }
        return ckpter.coordinateEvictionWithCheckpoint(target, parent);
    }

    @Override
    public synchronized void addEnvironment(EnvironmentImpl env) {
        if (this.isShared) {
            int numEnvs = this.envInfos.size();
            for (int i = 0; i < numEnvs; ++i) {
                EnvInfo info = this.envInfos.get(i);
                if (info.env != env) continue;
                return;
            }
        } else {
            throw EnvironmentFailureException.unexpectedState();
        }
        EnvInfo info = new EnvInfo();
        info.env = env;
        info.ins = env.getInMemoryINs();
        this.envInfos.add(info);
    }

    @Override
    public synchronized void removeEnvironment(EnvironmentImpl env) {
        if (this.isShared) {
            int numEnvs = this.envInfos.size();
            for (int i = 0; i < numEnvs; ++i) {
                EnvInfo info = this.envInfos.get(i);
                if (info.env != env) continue;
                try {
                    for (int j = 0; j < this.numLRULists; ++j) {
                        this.mixedLRUSet[j].removeINsForEnv(env);
                        this.dirtyLRUSet[j].removeINsForEnv(env);
                    }
                }
                catch (AssertionError e) {
                    System.out.println("YYYYYYYYYY " + e);
                    ((Throwable)((Object)e)).printStackTrace(System.out);
                    throw e;
                }
                this.envInfos.remove(i);
                return;
            }
        } else {
            throw EnvironmentFailureException.unexpectedState();
        }
    }

    @Override
    public synchronized boolean checkEnv(EnvironmentImpl env) {
        if (this.isShared) {
            int numEnvs = this.envInfos.size();
            for (int i = 0; i < numEnvs; ++i) {
                EnvInfo info = this.envInfos.get(i);
                if (env != info.env) continue;
                return true;
            }
            return false;
        }
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public StatGroup loadStats(StatsConfig config) {
        if (this.isShared) {
            this.sharedCacheEnvs.set(this.envInfos.size());
        }
        StatGroup copy = super.loadStats(config);
        copy.addAll(this.getINListStats(config));
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatGroup getINListStats(StatsConfig config) {
        if (this.isShared) {
            StatGroup totalINListStats = new StatGroup("temp", "temp");
            if (config.getFast()) {
                return totalINListStats;
            }
            ArrayList<EnvInfo> copy = null;
            LRUEvictor lRUEvictor = this;
            synchronized (lRUEvictor) {
                copy = new ArrayList<EnvInfo>(this.envInfos);
            }
            for (EnvInfo ei : copy) {
                totalINListStats.addAll(ei.env.getInMemoryINs().loadStats());
            }
            return totalINListStats;
        }
        return this.firstEnvImpl.getInMemoryINs().loadStats();
    }

    @Override
    public void noteINListChange(int nINs) {
    }

    class RootEvictor
    implements WithRootLatched {
        IN target;
        boolean backgroundIO;
        Evictor.EvictionSource source;
        EvictionDebugStats stats = null;
        ChildReference rootRef;
        boolean flushed = false;
        long evictedBytes = 0L;

        RootEvictor() {
        }

        @Override
        public IN doWork(ChildReference root) throws DatabaseException {
            IN rootIN = (IN)root.getTarget();
            if (rootIN == null) {
                return null;
            }
            this.rootRef = root;
            rootIN.latch(CacheMode.UNCHANGED);
            if (rootIN == this.target && rootIN.isRoot()) {
                this.evictedBytes = LRUEvictor.this.processTarget(this, null, null, -1, this.backgroundIO, this.source, this.stats);
            } else {
                rootIN.releaseLatch();
            }
            return null;
        }
    }

    private static class EnvInfo {
        EnvironmentImpl env;
        INList ins;

        private EnvInfo() {
        }
    }

    static class LRUList {
        private static final boolean doExpensiveCheck = false;
        private final int id;
        private int size = 0;
        private IN front = null;
        private IN back = null;

        LRUList(int id) {
            this.id = id;
        }

        synchronized void addBack(IN node) {
            assert (node.getNextLRUNode() == null);
            assert (node.getPrevLRUNode() == null);
            assert (!node.isDIN() && !node.isDBIN());
            node.setNextLRUNode(node);
            if (this.back != null) {
                node.setPrevLRUNode(this.back);
                this.back.setNextLRUNode(node);
            } else {
                assert (this.front == null);
                node.setPrevLRUNode(node);
            }
            this.back = node;
            if (this.front == null) {
                this.front = this.back;
            }
            ++this.size;
        }

        synchronized void addFront(IN node) {
            assert (node.getNextLRUNode() == null);
            assert (node.getPrevLRUNode() == null);
            assert (!node.isDIN() && !node.isDBIN());
            node.setPrevLRUNode(node);
            if (this.front != null) {
                node.setNextLRUNode(this.front);
                this.front.setPrevLRUNode(node);
            } else {
                assert (this.back == null);
                node.setNextLRUNode(node);
            }
            this.front = node;
            if (this.back == null) {
                this.back = this.front;
            }
            ++this.size;
        }

        synchronized void moveBack(IN node) {
            if (node.getNextLRUNode() == null) {
                assert (node.getPrevLRUNode() == null);
                return;
            }
            if (node.getNextLRUNode() == node) {
                assert (this.back == node);
                assert (node.getPrevLRUNode().getNextLRUNode() == node);
            } else {
                assert (this.front != this.back);
                assert (this.size > 1);
                if (node.getPrevLRUNode() == node) {
                    assert (this.front == node);
                    assert (node.getNextLRUNode().getPrevLRUNode() == node);
                    this.front = node.getNextLRUNode();
                    this.front.setPrevLRUNode(this.front);
                } else {
                    assert (this.front != node && this.back != node);
                    assert (node.getPrevLRUNode().getNextLRUNode() == node);
                    assert (node.getNextLRUNode().getPrevLRUNode() == node);
                    node.getPrevLRUNode().setNextLRUNode(node.getNextLRUNode());
                    node.getNextLRUNode().setPrevLRUNode(node.getPrevLRUNode());
                }
                node.setNextLRUNode(node);
                node.setPrevLRUNode(this.back);
                this.back.setNextLRUNode(node);
                this.back = node;
            }
        }

        synchronized void moveFront(IN node) {
            if (node.getNextLRUNode() == null) {
                assert (node.getPrevLRUNode() == null);
                return;
            }
            if (node.getPrevLRUNode() == node) {
                assert (this.front == node);
                assert (node.getNextLRUNode().getPrevLRUNode() == node);
            } else {
                assert (this.front != this.back);
                assert (this.size > 1);
                if (node.getNextLRUNode() == node) {
                    assert (this.back == node);
                    assert (node.getPrevLRUNode().getNextLRUNode() == node);
                    this.back = node.getPrevLRUNode();
                    this.back.setNextLRUNode(this.back);
                } else {
                    assert (this.front != node && this.back != node);
                    assert (node.getPrevLRUNode().getNextLRUNode() == node);
                    assert (node.getNextLRUNode().getPrevLRUNode() == node);
                    node.getPrevLRUNode().setNextLRUNode(node.getNextLRUNode());
                    node.getNextLRUNode().setPrevLRUNode(node.getPrevLRUNode());
                }
                node.setPrevLRUNode(node);
                node.setNextLRUNode(this.front);
                this.front.setPrevLRUNode(node);
                this.front = node;
            }
        }

        synchronized IN removeFront() {
            if (this.front == null) {
                assert (this.back == null);
                return null;
            }
            IN res = this.front;
            if (this.front == this.back) {
                assert (this.front.getNextLRUNode() == this.front);
                assert (this.front.getPrevLRUNode() == this.front);
                assert (this.size == 1);
                this.front = null;
                this.back = null;
            } else {
                assert (this.size > 1);
                this.front = this.front.getNextLRUNode();
                this.front.setPrevLRUNode(this.front);
            }
            res.setNextLRUNode(null);
            res.setPrevLRUNode(null);
            --this.size;
            return res;
        }

        synchronized boolean remove(IN node) {
            if (node.getNextLRUNode() == null) {
                assert (node.getPrevLRUNode() == null);
                return false;
            }
            if (this.front == this.back) {
                assert (this.size == 1);
                assert (this.front == node);
                assert (this.front.getNextLRUNode() == this.front);
                assert (this.front.getPrevLRUNode() == this.front);
                this.front = null;
                this.back = null;
            } else if (node.getPrevLRUNode() == node) {
                assert (this.front == node);
                assert (node.getNextLRUNode().getPrevLRUNode() == node);
                this.front = node.getNextLRUNode();
                this.front.setPrevLRUNode(this.front);
            } else if (node.getNextLRUNode() == node) {
                assert (this.back == node);
                assert (node.getPrevLRUNode().getNextLRUNode() == node);
                this.back = node.getPrevLRUNode();
                this.back.setNextLRUNode(this.back);
            } else {
                assert (this.size > 2);
                assert (this.front != this.back);
                assert (this.front != node && this.back != node);
                assert (node.getPrevLRUNode().getNextLRUNode() == node);
                assert (node.getNextLRUNode().getPrevLRUNode() == node);
                node.getPrevLRUNode().setNextLRUNode(node.getNextLRUNode());
                node.getNextLRUNode().setPrevLRUNode(node.getPrevLRUNode());
            }
            node.setNextLRUNode(null);
            node.setPrevLRUNode(null);
            --this.size;
            return true;
        }

        synchronized void removeINsForEnv(EnvironmentImpl env) {
            if (this.front == null) {
                assert (this.back == null);
                return;
            }
            IN node = this.front;
            while (true) {
                IN nextNode = node.getNextLRUNode();
                IN prevNode = node.getPrevLRUNode();
                if (node.getDatabase().getDbEnvironment() == env) {
                    node.setNextLRUNode(null);
                    node.setPrevLRUNode(null);
                    if (this.front == this.back) {
                        assert (this.size == 1);
                        assert (this.front == node);
                        assert (nextNode == this.front);
                        assert (prevNode == this.front);
                        this.front = null;
                        this.back = null;
                        --this.size;
                        break;
                    }
                    if (prevNode == node) {
                        assert (this.size > 1);
                        assert (this.front == node);
                        assert (nextNode.getPrevLRUNode() == node);
                        this.front = nextNode;
                        this.front.setPrevLRUNode(this.front);
                        node = this.front;
                        --this.size;
                        continue;
                    }
                    if (nextNode == node) {
                        assert (this.size > 1);
                        assert (this.back == node);
                        assert (prevNode.getNextLRUNode() == node);
                        this.back = prevNode;
                        this.back.setNextLRUNode(this.back);
                        --this.size;
                        break;
                    }
                    assert (this.size > 2);
                    assert (this.front != this.back);
                    assert (this.front != node && this.back != node);
                    assert (prevNode.getNextLRUNode() == node);
                    assert (nextNode.getPrevLRUNode() == node);
                    prevNode.setNextLRUNode(nextNode);
                    nextNode.setPrevLRUNode(prevNode);
                    node = nextNode;
                    --this.size;
                    continue;
                }
                if (nextNode == node) break;
                node = nextNode;
            }
        }

        synchronized boolean contains(IN node) {
            return node.getNextLRUNode() != null;
        }

        private boolean contains2(IN node) {
            if (this.front == null) {
                assert (this.back == null);
                return false;
            }
            IN curr = this.front;
            while (true) {
                if (curr == node) {
                    return true;
                }
                if (curr.getNextLRUNode() == curr) break;
                curr = curr.getNextLRUNode();
            }
            return false;
        }

        int getSize() {
            return this.size;
        }

        synchronized void getStats(EnvironmentImpl env, LRUDebugStats stats) {
            if (this.front == null) {
                assert (this.back == null);
                return;
            }
            IN curr = this.front;
            while (true) {
                if (env == null || curr.getEnv() == env) {
                    ++stats.size;
                    if (curr.getDirty()) {
                        ++stats.dirtySize;
                    }
                    if (curr.isBIN()) {
                        ++stats.numBINs;
                        if (curr.getDirty()) {
                            ++stats.numDirtyBINs;
                        }
                        if (!curr.hasResidentChildren()) {
                            ++stats.numStrippedBINs;
                            if (curr.getDirty()) {
                                ++stats.numDirtyStrippedBINs;
                            }
                        }
                    }
                }
                if (curr.getNextLRUNode() == curr) break;
                curr = curr.getNextLRUNode();
            }
        }
    }

    static class LRUDebugStats {
        int size;
        int dirtySize;
        int numBINs;
        int numDirtyBINs;
        int numStrippedBINs;
        int numDirtyStrippedBINs;

        LRUDebugStats() {
        }

        void reset() {
            this.size = 0;
            this.dirtySize = 0;
            this.numBINs = 0;
            this.numDirtyBINs = 0;
            this.numStrippedBINs = 0;
            this.numDirtyStrippedBINs = 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Clean/Dirty INs = ");
            sb.append(this.size - this.dirtySize);
            sb.append("/");
            sb.append(this.dirtySize);
            sb.append(" BINs = ");
            sb.append(this.numBINs - this.numDirtyBINs);
            sb.append("/");
            sb.append(this.numDirtyBINs);
            sb.append(" Stripped BINs = ");
            sb.append(this.numStrippedBINs - this.numDirtyStrippedBINs);
            sb.append("/");
            sb.append(this.numDirtyStrippedBINs);
            return sb.toString();
        }
    }

    static class EvictionDebugStats {
        boolean inMixedLRU;
        boolean withParent;
        long mixedSize;
        long dirtySize;
        int numSelectedMixed;
        int numSelectedDirty;
        int numPutBackMixed;
        int numPutBackDirty;
        int numBINsStripped1Mixed;
        int numBINsStripped2Mixed;
        int numBINsStripped1Dirty;
        int numBINsStripped2Dirty;
        int numBINsMutatedMixed;
        int numBINsMutatedDirty;
        int numUINsMoved1;
        int numUINsMoved2;
        int numBINsMoved1;
        int numBINsMoved2;
        int numUINsEvictedMixed;
        int numUINsEvictedDirty;
        int numBINsEvictedMixed;
        int numBINsEvictedDirty;

        EvictionDebugStats() {
        }

        void reset() {
            this.inMixedLRU = true;
            this.withParent = false;
            this.mixedSize = 0L;
            this.dirtySize = 0L;
            this.numSelectedMixed = 0;
            this.numSelectedDirty = 0;
            this.numPutBackMixed = 0;
            this.numPutBackDirty = 0;
            this.numBINsStripped1Mixed = 0;
            this.numBINsStripped2Mixed = 0;
            this.numBINsStripped1Dirty = 0;
            this.numBINsStripped2Dirty = 0;
            this.numBINsMutatedMixed = 0;
            this.numBINsMutatedDirty = 0;
            this.numUINsMoved1 = 0;
            this.numUINsMoved2 = 0;
            this.numBINsMoved1 = 0;
            this.numBINsMoved2 = 0;
            this.numUINsEvictedMixed = 0;
            this.numUINsEvictedDirty = 0;
            this.numBINsEvictedMixed = 0;
            this.numBINsEvictedDirty = 0;
        }

        void incNumSelected() {
            if (this.inMixedLRU) {
                ++this.numSelectedMixed;
            } else {
                ++this.numSelectedDirty;
            }
        }

        void incNumPutBack() {
            if (this.inMixedLRU) {
                ++this.numPutBackMixed;
            } else {
                ++this.numPutBackDirty;
            }
        }

        void incNumStripped() {
            if (this.inMixedLRU) {
                if (this.withParent) {
                    ++this.numBINsStripped2Mixed;
                } else {
                    ++this.numBINsStripped1Mixed;
                }
            } else if (this.withParent) {
                ++this.numBINsStripped2Dirty;
            } else {
                ++this.numBINsStripped1Dirty;
            }
        }

        void incNumMutated() {
            if (this.inMixedLRU) {
                ++this.numBINsMutatedMixed;
            } else {
                ++this.numBINsMutatedDirty;
            }
        }

        void incNumMoved(boolean isBIN) {
            if (this.withParent) {
                if (isBIN) {
                    ++this.numBINsMoved2;
                } else {
                    ++this.numUINsMoved2;
                }
            } else if (isBIN) {
                ++this.numBINsMoved1;
            } else {
                ++this.numUINsMoved1;
            }
        }

        void incNumEvicted(boolean isBIN) {
            if (this.inMixedLRU) {
                if (isBIN) {
                    ++this.numBINsEvictedMixed;
                } else {
                    ++this.numUINsEvictedMixed;
                }
            } else if (isBIN) {
                ++this.numBINsEvictedDirty;
            } else {
                ++this.numUINsEvictedDirty;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Eviction stats MIXED: size = ");
            sb.append(this.mixedSize);
            sb.append("\n");
            sb.append("selected = ");
            sb.append(this.numSelectedMixed);
            sb.append(" | ");
            sb.append("put back = ");
            sb.append(this.numPutBackMixed);
            sb.append(" | ");
            sb.append("stripped = ");
            sb.append(this.numBINsStripped1Mixed);
            sb.append("/");
            sb.append(this.numBINsStripped2Mixed);
            sb.append(" | ");
            sb.append("mutated = ");
            sb.append(this.numBINsMutatedMixed);
            sb.append(" | ");
            sb.append("moved = ");
            sb.append(this.numBINsMoved1);
            sb.append("/");
            sb.append(this.numBINsMoved2);
            sb.append(" - ");
            sb.append(this.numUINsMoved1);
            sb.append("/");
            sb.append(this.numUINsMoved2);
            sb.append(" | ");
            sb.append("evicted = ");
            sb.append(this.numBINsEvictedMixed);
            sb.append(" - ");
            sb.append(this.numUINsEvictedMixed);
            sb.append("\n");
            sb.append("Eviction stats DIRTY: size = ");
            sb.append(this.dirtySize);
            sb.append("\n");
            sb.append("selected = ");
            sb.append(this.numSelectedDirty);
            sb.append(" | ");
            sb.append("put back = ");
            sb.append(this.numPutBackDirty);
            sb.append(" | ");
            sb.append("stripped = ");
            sb.append(this.numBINsStripped1Dirty);
            sb.append("/");
            sb.append(this.numBINsStripped2Dirty);
            sb.append(" | ");
            sb.append("mutated = ");
            sb.append(this.numBINsMutatedDirty);
            sb.append(" | ");
            sb.append("evicted = ");
            sb.append(this.numBINsEvictedDirty);
            sb.append(" - ");
            sb.append(this.numUINsEvictedDirty);
            sb.append("\n");
            return sb.toString();
        }
    }
}

