/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;

class Arbiter {
    private final MemoryBudget.Totals memBudgetTotals;
    private TestHook<Boolean> runnableHook;
    private final long evictBytesSetting;
    private volatile boolean everFull;
    private final StatGroup stats;
    private final LongStat requiredEvictBytesStat;

    Arbiter(EnvironmentImpl envImpl) {
        DbConfigManager configManager = envImpl.getConfigManager();
        this.evictBytesSetting = configManager.getLong(EnvironmentParams.EVICTOR_EVICT_BYTES);
        this.stats = new StatGroup("Cache", "Current size, allocations, and eviction activity.");
        this.requiredEvictBytesStat = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_REQUIRED_EVICT_BYTES);
        this.memBudgetTotals = envImpl.getMemoryBudget().getTotals();
    }

    public StatGroup loadStats(StatsConfig config) {
        long overBudget = this.memBudgetTotals.getCacheUsage() - this.memBudgetTotals.getMaxMemory();
        this.requiredEvictBytesStat.set(Math.max(0L, overBudget));
        return this.stats.cloneGroup(config.getClear());
    }

    boolean isOverBudget() {
        return this.memBudgetTotals.getCacheUsage() > this.memBudgetTotals.getMaxMemory();
    }

    boolean needCriticalEviction() {
        long over = this.memBudgetTotals.getCacheUsage() - this.memBudgetTotals.getMaxMemory();
        return over > this.memBudgetTotals.getCriticalThreshold();
    }

    boolean stillNeedsEviction() {
        return this.memBudgetTotals.getCacheUsage() + this.evictBytesSetting > this.memBudgetTotals.getMaxMemory();
    }

    public boolean isCacheFull() {
        boolean isNowFull;
        boolean bl = isNowFull = this.memBudgetTotals.getCacheUsage() + 2L * this.evictBytesSetting >= this.memBudgetTotals.getMaxMemory();
        if (isNowFull) {
            this.everFull = true;
        }
        return isNowFull;
    }

    public boolean wasCacheEverFull() {
        return this.everFull;
    }

    long getEvictionPledge() {
        long maxMem;
        long currentUsage = this.memBudgetTotals.getCacheUsage();
        long overBudget = currentUsage - (maxMem = this.memBudgetTotals.getMaxMemory());
        boolean doRun = overBudget > 0L;
        long requiredEvictBytes = 0L;
        if (doRun && currentUsage - (requiredEvictBytes = overBudget + this.evictBytesSetting) < maxMem / 2L) {
            requiredEvictBytes = overBudget + maxMem / 2L;
        }
        if (this.runnableHook != null) {
            doRun = this.runnableHook.getHookValue();
            requiredEvictBytes = doRun ? maxMem : 0L;
        }
        return requiredEvictBytes;
    }

    void setRunnableHook(TestHook<Boolean> hook) {
        this.runnableHook = hook;
    }
}

