/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.ForwardCursor;
import com.sleepycat.je.OperationStatus;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import oracle.kv.FaultException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.Key;
import oracle.kv.LoginCredentials;
import oracle.kv.Value;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.server.LoggerUtils;

public class Load
implements KVStoreLogin.CredentialsProvider {
    public static final String COMMAND_NAME = "load";
    public static final String COMMAND_DESC = "loads data into a store from a backup";
    public static final String COMMAND_ARGS = "-source <backupDir> " + CommandParser.getHostUsage() + " " + CommandParser.getPortUsage() + "\n\t" + CommandParser.getStoreUsage() + " " + CommandParser.getUserUsage() + " " + CommandParser.getSecurityUsage() + "\n\t" + CommandParser.optional("-status <pathToFile>");
    File envDir;
    Environment env;
    Topology topo;
    File statusFile;
    HashSet<String> loadedDatabases;
    PrintStream output;
    boolean verboseOutput;
    RecordListMap recordList;
    int maxPartitionBytes;
    long totalBytesThreshold;
    private KVStoreLogin storeLogin;
    private LoginCredentials loginCreds;
    KVStore userStore;
    KVStore internalStore;
    ExecutorService threadPool;
    BlockingQueue<FutureHolder> taskWaitQueue;
    Future<Long> taskWait;
    private static final int NUM_THREADS = 20;
    private static final int TASK_QUEUE_SIZE = 40;
    private static final int DEFAULT_MAX_PARTITION_BYTES = 5000000;
    private static final int RETRY_COUNT = 5;

    public Load(File env, String storeName, String targetHost, int targetPort, String user, String securityFile, String statusFile, boolean verboseOutput, PrintStream output) throws Exception {
        this.envDir = env;
        this.statusFile = statusFile != null ? new File(statusFile) : null;
        this.verboseOutput = verboseOutput;
        this.output = output;
        String[] hosts = new String[]{targetHost + ":" + targetPort};
        this.prepareAuthentication(user, securityFile);
        KVStoreConfig kvConfig = new KVStoreConfig(storeName, hosts[0]);
        kvConfig.setSecurityProperties(this.storeLogin.getSecurityProperties());
        this.userStore = KVStoreFactory.getStore(kvConfig, this.loginCreds, KVStoreLogin.makeReauthenticateHandler(this));
        this.internalStore = KVStoreImpl.makeInternalHandle(this.userStore);
        this.verbose("Opened store " + storeName);
        this.topo = TopologyLocator.get(hosts, 10, KVStoreImpl.getLoginManager(this.userStore), null);
        this.threadPool = Executors.newFixedThreadPool(20, new KVThreadFactory("Load", null));
        this.taskWaitQueue = new ArrayBlockingQueue<FutureHolder>(40);
        this.taskWait = this.threadPool.submit(new TaskWaiter());
        this.recordList = new RecordListMap();
        this.totalBytesThreshold = Runtime.getRuntime().maxMemory() / 4L;
        this.maxPartitionBytes = 5000000;
        this.verbose("Using byte threshold of " + this.totalBytesThreshold);
    }

    @Override
    public LoginCredentials getCredentials() {
        return this.loginCreds;
    }

    public void setStatusFile(File status) {
        this.statusFile = status;
    }

    public File getStatusFile() {
        return this.statusFile;
    }

    public void setOutput(PrintStream output) {
        this.output = output;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public void setVerbose(boolean verboseOutput) {
        this.verboseOutput = verboseOutput;
    }

    public boolean getVerbose() {
        return this.verboseOutput;
    }

    public void setPartitionBytes(int value) {
        this.maxPartitionBytes = value;
    }

    public int getPartitionBytes() {
        return this.maxPartitionBytes;
    }

    private void message(String msg) {
        if (this.output != null) {
            this.output.println(msg);
        }
    }

    private void verbose(String msg) {
        if (this.verboseOutput) {
            this.message(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long run() throws Exception {
        try {
            this.open();
        }
        catch (Exception e) {
            System.err.println("Could not open backup source directory: " + e);
            return 0L;
        }
        try {
            List<String> dbs = this.env.getDatabaseNames();
            for (String db : dbs) {
                if (!PartitionId.isPartitionName(db)) {
                    this.verbose("Skipping non-partition database: " + db);
                    continue;
                }
                if (this.isLoaded(db)) {
                    this.verbose("Skipping already loaded database: " + db);
                    continue;
                }
                this.verbose("Starting database scan: " + db);
                this.scanDatabase(db);
                this.setLoaded(db);
                this.verbose("Completed database scan: " + db);
            }
            this.recordList.createTasks();
            this.verbose("Done scanning databases, waiting for write tasks");
            long l = this.waitForTasks();
            return l;
        }
        finally {
            this.writeStatusFile();
            this.close();
        }
    }

    private void prepareAuthentication(String user, String securityFile) throws Exception {
        this.storeLogin = new KVStoreLogin(user, securityFile);
        try {
            this.storeLogin.loadSecurityProperties();
        }
        catch (IllegalArgumentException iae) {
            this.message(iae.getMessage());
        }
        if (this.storeLogin.foundSSLTransport()) {
            this.loginCreds = this.storeLogin.makeShellLoginCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDatabase(String dbName) throws Exception {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(false);
        dbConfig.setReadOnly(true);
        Database db = null;
        ForwardCursor cursor = null;
        try {
            db = this.env.openDatabase(null, dbName, dbConfig);
            cursor = db.openCursor(new DiskOrderedCursorConfig());
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                if (this.taskWait.isDone()) {
                    this.message("Task Waiter has exited, aborting load");
                    this.waitForTasks();
                }
                this.recordList.insert(key, data);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
    }

    private long waitForTasks() throws Exception {
        this.verbose("Collecting results from write tasks");
        try {
            this.taskWaitQueue.put(new FutureHolder(null));
            return this.taskWait.get();
        }
        catch (ExecutionException e) {
            this.message("waitForTasks: exception from a task: " + e);
            throw e;
        }
        catch (InterruptedException ie) {
            this.message("waitForTasks: task was interrupted: " + ie);
            throw ie;
        }
    }

    private void close() {
        this.env.close();
        if (this.userStore != null) {
            this.userStore.close();
        }
    }

    private void setLoaded(String dbname) {
        if (this.loadedDatabases != null) {
            this.loadedDatabases.add(dbname);
        }
    }

    private boolean isLoaded(String dbname) {
        return this.loadedDatabases != null && this.loadedDatabases.contains(dbname);
    }

    private void loadStatusFile() {
        if (this.statusFile != null) {
            this.loadedDatabases = new HashSet();
            if (this.statusFile.exists()) {
                try {
                    String inputLine;
                    FileReader fr = new FileReader(this.statusFile);
                    BufferedReader br = new BufferedReader(fr);
                    while ((inputLine = br.readLine()) != null) {
                        this.loadedDatabases.add(inputLine);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load from status file " + this.statusFile, e);
                }
                this.verbose("Loaded status from file " + this.statusFile);
            }
        }
    }

    private void writeStatusFile() {
        if (this.loadedDatabases != null) {
            try (PrintWriter writer = null;){
                FileOutputStream fos = new FileOutputStream(this.statusFile);
                writer = new PrintWriter(fos);
                for (String dbname : this.loadedDatabases) {
                    writer.printf("%s\n", dbname);
                }
            }
        }
    }

    private void open() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(false);
        envConfig.setAllowCreate(false);
        envConfig.setReadOnly(true);
        this.env = new Environment(this.envDir, envConfig);
        this.verbose("Opened source backup directory " + this.envDir);
        this.loadStatusFile();
    }

    private int writeListToStore(List<KV> list) {
        int num = 0;
        block2: for (KV kv : list) {
            for (int i = 0; i < 5; ++i) {
                try {
                    this.internalStore.putIfAbsent(kv.key, kv.value);
                    ++num;
                    continue block2;
                }
                catch (FaultException fe) {
                    if (i != 4) continue;
                    throw fe;
                }
            }
        }
        return num;
    }

    public static void main(String[] args) throws Exception {
        LoadParser lp = new LoadParser(args);
        lp.parseArgs();
        Load load = new Load(new File(lp.getSourceDir()), lp.getStoreName(), lp.getHostname(), lp.getRegistryPort(), lp.getUserName(), lp.getSecurityFile(), lp.getStatusFile(), lp.getVerbose(), System.out);
        try {
            long total = load.run();
            System.out.println("Load succeeded, wrote " + total + " records");
        }
        catch (Exception e) {
            System.err.println("Load operation failed with exception: " + LoggerUtils.getStackTrace(e));
        }
    }

    public static class LoadParser
    extends CommandParser {
        private static final String SOURCE_FLAG = "-source";
        private static final String STATUS_FLAG = "-status";
        private String source = null;
        private String status = null;

        LoadParser(String[] args) {
            super(args);
        }

        @Override
        public void usage(String errorMsg) {
            if (errorMsg != null) {
                System.err.println(errorMsg);
            }
            System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar load\n\t" + COMMAND_ARGS);
            System.exit(-1);
        }

        @Override
        protected boolean checkArg(String arg) {
            if (arg.equals(SOURCE_FLAG)) {
                this.source = this.nextArg(arg);
                return true;
            }
            if (arg.equals(STATUS_FLAG)) {
                this.status = this.nextArg(arg);
                return true;
            }
            return false;
        }

        @Override
        protected void verifyArgs() {
            if (this.getHostname() == null) {
                this.missingArg("-host");
            }
            if (this.getRegistryPort() == 0) {
                this.missingArg("-port");
            }
            if (this.getStoreName() == null) {
                this.missingArg("-store");
            }
            if (this.source == null) {
                this.missingArg(SOURCE_FLAG);
            }
        }

        public String getStatusFile() {
            return this.status;
        }

        public String getSourceDir() {
            return this.source;
        }
    }

    private class TaskWaiter
    implements Callable<Long> {
        long totalRecords;

        @Override
        public Long call() throws Exception {
            while (true) {
                FutureHolder holder;
                try {
                    holder = Load.this.taskWaitQueue.take();
                }
                catch (InterruptedException e) {
                    Load.this.verbose("Load program was interrupted");
                    throw new IllegalStateException(e);
                }
                if (holder == null || holder.getFuture() == null) {
                    Load.this.verbose("TaskWaitThread returning");
                    return this.totalRecords;
                }
                Future<Integer> future = holder.getFuture();
                try {
                    int result = future.get();
                    this.totalRecords += (long)result;
                }
                catch (ExecutionException e) {
                    Load.this.message("TaskWaiter: exception from a task: " + e);
                    throw e;
                }
                catch (InterruptedException ie) {
                    Load.this.message("TaskWaiter: task was interrupted: " + ie);
                    throw ie;
                }
            }
        }
    }

    class FutureHolder {
        Future<Integer> future;

        public FutureHolder(Future<Integer> future) {
            this.future = future;
        }

        public Future<Integer> getFuture() {
            return this.future;
        }
    }

    private class WriteTask
    implements Callable<Integer> {
        List<KV> list;

        public WriteTask(List<KV> list) {
            this.list = list;
        }

        @Override
        public Integer call() {
            return Load.this.writeListToStore(this.list);
        }
    }

    class RecordListMap {
        private final ConcurrentMap<PartitionId, RecordList> map = new ConcurrentHashMap<PartitionId, RecordList>();
        int totalBytes = 0;

        public void insert(DatabaseEntry key, DatabaseEntry data) {
            byte[] keyBytes = key.getData();
            byte[] valBytes = data.getData();
            PartitionId targetPartition = Load.this.topo.getPartitionId(keyBytes);
            RecordList list = (RecordList)this.map.get(targetPartition);
            if (list == null) {
                list = new RecordList();
                this.map.put(targetPartition, list);
            }
            list.add(keyBytes, valBytes);
            this.totalBytes += list.byteSize();
            if (list.byteSize() > Load.this.maxPartitionBytes) {
                this.createTaskFromList(list, targetPartition);
            }
            if ((long)this.totalBytes > Load.this.totalBytesThreshold) {
                this.createTasks();
            }
        }

        public void createTaskFromList(RecordList list, PartitionId id) {
            this.createTask(list.getList());
            this.totalBytes -= list.byteSize();
            this.map.remove(id);
        }

        public void createTasks() {
            for (Map.Entry entry : this.map.entrySet()) {
                this.createTaskFromList((RecordList)entry.getValue(), (PartitionId)entry.getKey());
            }
        }

        private void createTask(List<KV> list) {
            Load.this.verbose("Creating a task to write " + list.size() + " records");
            Future<Integer> future = Load.this.threadPool.submit(new WriteTask(list));
            try {
                Load.this.taskWaitQueue.put(new FutureHolder(future));
            }
            catch (InterruptedException e) {
                Load.this.verbose("Load program was interrupted");
                throw new IllegalStateException(e);
            }
        }

        class RecordList {
            private final List<KV> list = new ArrayList<KV>();
            private int bytes = 0;

            public void add(byte[] keyBytes, byte[] valBytes) {
                this.bytes += keyBytes.length + valBytes.length;
                Key kvkey = Key.fromByteArray(keyBytes);
                Value kvvalue = Value.fromByteArray(valBytes);
                this.list.add(new KV(kvkey, kvvalue));
            }

            public List<KV> getList() {
                return this.list;
            }

            public int byteSize() {
                return this.bytes;
            }
        }
    }

    class KV {
        public Key key;
        public Value value;

        public KV(Key key, Value value) {
            this.key = key;
            this.value = value;
        }
    }
}

