/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.table;

import oracle.kv.table.ArrayValue;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.EnumValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FloatValue;
import oracle.kv.table.IntegerValue;
import oracle.kv.table.LongValue;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.StringValue;

public class FieldRange {
    private final String fieldName;
    private final FieldDef field;
    private FieldValue start;
    private boolean startInclusive;
    private FieldValue end;
    private boolean endInclusive;

    public FieldRange(String fieldName, FieldDef field) {
        this.fieldName = fieldName;
        this.field = field;
    }

    public MultiRowOptions createMultiRowOptions() {
        return new MultiRowOptions(this);
    }

    public FieldValue getStart() {
        return this.start;
    }

    public boolean getStartInclusive() {
        return this.startInclusive;
    }

    public FieldValue getEnd() {
        return this.end;
    }

    public boolean getEndInclusive() {
        return this.endInclusive;
    }

    public FieldDef getDefinition() {
        return this.field;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FieldRange setStart(int value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        IntegerValue val = fieldToUse.createInteger(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStart(double value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        DoubleValue val = fieldToUse.createDouble(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStart(float value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        FloatValue val = fieldToUse.createFloat(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStart(long value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        LongValue val = fieldToUse.createLong(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStart(String value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        StringValue val = fieldToUse.createString(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setStartEnum(String value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        EnumValue val = fieldToUse.createEnum(value);
        return this.setStartValue(val, isInclusive);
    }

    public FieldRange setEnd(int value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        IntegerValue val = fieldToUse.createInteger(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEnd(double value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        DoubleValue val = fieldToUse.createDouble(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEnd(float value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        FloatValue val = fieldToUse.createFloat(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEnd(long value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        LongValue val = fieldToUse.createLong(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEnd(String value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        StringValue val = fieldToUse.createString(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setEndEnum(String value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        EnumValue val = fieldToUse.createEnum(value);
        return this.setEndValue(val, isInclusive);
    }

    public FieldRange setStart(FieldValue value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        if (!fieldToUse.isType(value.getType())) {
            throw new IllegalArgumentException("Value is not of correct type: " + (Object)((Object)value.getType()));
        }
        return this.setStartValue(value, isInclusive);
    }

    public FieldRange setEnd(FieldValue value, boolean isInclusive) {
        FieldDef fieldToUse = this.getFieldDef();
        if (!fieldToUse.isType(value.getType())) {
            throw new IllegalArgumentException("Value is not of correct type: " + (Object)((Object)value.getType()));
        }
        return this.setEndValue(value, isInclusive);
    }

    private FieldRange setStartValue(FieldValue value, boolean isInclusive) {
        if (this.field.isArray()) {
            ArrayValue array = this.field.createArray();
            array.add(value);
            value = array;
        }
        this.validate(value, this.end);
        this.start = value;
        this.startInclusive = isInclusive;
        return this;
    }

    private FieldRange setEndValue(FieldValue value, boolean isInclusive) {
        if (this.field.isArray()) {
            ArrayValue array = this.field.createArray();
            array.add(value);
            value = array;
        }
        this.validate(this.start, value);
        this.end = value;
        this.endInclusive = isInclusive;
        return this;
    }

    private void validate(FieldValue startVal, FieldValue endVal) {
        if (startVal != null && endVal != null && startVal.compareTo(endVal) > 0) {
            throw new IllegalArgumentException("FieldRange: start value must be less than the end value");
        }
    }

    private FieldDef getFieldDef() {
        if (this.field.isArray()) {
            return this.field.asArray().getElement();
        }
        return this.field;
    }
}

