/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry;

import java.io.IOException;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public abstract class ServerSocketFactory
implements RMIServerSocketFactory {
    private final AtomicInteger socketCount = new AtomicInteger(0);
    protected final String name;
    protected final int backlog;
    protected final int startPort;
    protected final int endPort;
    private int currentPort;
    private final int rangeSize;
    protected Logger connectionLogger;
    private static boolean disabled = false;

    protected ServerSocketFactory(String name, int backlog, int startPort, int endPort) {
        if (endPort < startPort) {
            throw new IllegalArgumentException("End port " + endPort + " must be >= startPort " + startPort);
        }
        this.name = name;
        this.backlog = backlog;
        this.startPort = startPort;
        this.endPort = endPort;
        this.currentPort = startPort;
        this.rangeSize = this.isUnconstrained() ? Integer.MAX_VALUE : endPort - startPort + 1;
    }

    public int getSocketCount() {
        return this.socketCount.get();
    }

    public static boolean isDisabled() {
        return disabled;
    }

    public static void setDisabled(boolean disable) {
        disabled = disable;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setConnectionLogger(Logger logger) {
        this.connectionLogger = logger;
    }

    public abstract ServerSocket prepareServerSocket() throws IOException;

    public abstract void discardServerSocket(ServerSocket var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.backlog;
        result = 31 * result + this.endPort;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.startPort;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerSocketFactory)) {
            return false;
        }
        ServerSocketFactory other = (ServerSocketFactory)obj;
        if (this.backlog != other.backlog) {
            return false;
        }
        if (this.startPort != other.startPort) {
            return false;
        }
        if (this.endPort != other.endPort) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    protected boolean isUnconstrained() {
        return this.startPort == 0 && this.endPort == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerSocket commonCreateServerSocket(int port) throws IOException {
        if (port != 0 || this.isUnconstrained()) {
            return this.createServerSocketInternal(port);
        }
        for (int portCount = this.rangeSize; portCount > 0; --portCount) {
            try {
                ServerSocket serverSocket = this.createServerSocketInternal(this.currentPort);
                return serverSocket;
            }
            catch (IOException iOException) {
                continue;
            }
            finally {
                this.currentPort = this.currentPort == this.endPort ? this.startPort : ++this.currentPort;
            }
        }
        throw new IOException("No free ports in the range: " + this.startPort + "," + this.endPort);
    }

    protected abstract ServerSocket instantiateServerSocket(int var1) throws IOException;

    protected abstract ServerSocket instantiateServerSocket(int var1, int var2) throws IOException;

    private ServerSocket createServerSocketInternal(int port) throws IOException {
        ServerSocket so = this.backlog > 0 ? this.instantiateServerSocket(port, this.backlog) : this.instantiateServerSocket(port);
        this.socketCount.incrementAndGet();
        return so;
    }
}

