/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.EnumValueImpl;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.EnumDef;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
class RecordValueImpl
extends ComplexValueImpl
implements RecordValue {
    private static final long serialVersionUID = 1L;
    protected final Map<String, FieldValue> valueMap;

    RecordValueImpl(RecordDef field) {
        super(field);
        this.valueMap = new TreeMap<String, FieldValue>(FieldComparator.instance);
    }

    RecordValueImpl(RecordDef field, Map<String, FieldValue> valueMap) {
        super(field);
        if (valueMap == null) {
            throw new IllegalArgumentException("Null valueMap passed to RecordValueImpl");
        }
        this.valueMap = valueMap;
    }

    RecordValueImpl(RecordValueImpl other) {
        super(other.field);
        this.valueMap = new TreeMap<String, FieldValue>(FieldComparator.instance);
        this.copyFields(other);
    }

    private RecordValueImpl() {
        super(null);
        this.valueMap = null;
    }

    @Override
    public FieldValue get(String fieldName) {
        return this.valueMap.get(fieldName);
    }

    @Override
    public RecordValue put(String name, int value) {
        FieldDef def = this.validateNameAndType(name, FieldDef.Type.INTEGER);
        this.valueMap.put(name, def.createInteger(value));
        return this;
    }

    @Override
    public RecordValue put(String name, long value) {
        FieldDef def = this.validateNameAndType(name, FieldDef.Type.LONG);
        this.valueMap.put(name, def.createLong(value));
        return this;
    }

    @Override
    public RecordValue put(String name, String value) {
        FieldDef def = this.validateNameAndType(name, FieldDef.Type.STRING);
        this.valueMap.put(name, def.createString(value));
        return this;
    }

    @Override
    public RecordValue put(String name, double value) {
        FieldDef def = this.validateNameAndType(name, FieldDef.Type.DOUBLE);
        this.valueMap.put(name, def.createDouble(value));
        return this;
    }

    @Override
    public RecordValue put(String name, float value) {
        FieldDef def = this.validateNameAndType(name, FieldDef.Type.FLOAT);
        this.valueMap.put(name, def.createFloat(value));
        return this;
    }

    @Override
    public RecordValue put(String name, boolean value) {
        FieldDef def = this.validateNameAndType(name, FieldDef.Type.BOOLEAN);
        this.valueMap.put(name, def.createBoolean(value));
        return this;
    }

    @Override
    public RecordValue put(String name, byte[] value) {
        FieldDef def = this.validateNameAndType(name, FieldDef.Type.BINARY);
        this.valueMap.put(name, def.createBinary(value));
        return this;
    }

    @Override
    public RecordValue putFixed(String name, byte[] value) {
        FieldDef def = this.validateNameAndType(name, FieldDef.Type.FIXED_BINARY);
        this.valueMap.put(name, def.createFixedBinary(value));
        return this;
    }

    @Override
    public RecordValue putEnum(String name, String value) {
        EnumDefImpl enumField = (EnumDefImpl)this.validateNameAndType(name, FieldDef.Type.ENUM);
        this.valueMap.put(name, enumField.createEnum(value));
        return this;
    }

    @Override
    public RecordValue putNull(String name) {
        FieldDef ft = this.getDefinition(name);
        if (ft == null) {
            throw new IllegalArgumentException("No such field in record " + this.getDefinition().getName() + ": " + name);
        }
        if (!this.getDefinition().isNullable(name)) {
            throw new IllegalArgumentException("Named field is not nullable: " + name);
        }
        this.valueMap.put(name, NullValueImpl.getInstance());
        return this;
    }

    @Override
    public RecordValue put(String name, FieldValue value) {
        if (value.isNull()) {
            return this.putNull(name);
        }
        this.validateNameAndType(name, value.getType());
        this.valueMap.put(name, value);
        return this;
    }

    @Override
    public RecordValueImpl putRecord(String name) {
        FieldDef def = this.validateNameAndType(name, FieldDef.Type.RECORD);
        RecordValue val = def.createRecord();
        this.valueMap.put(name, val);
        return (RecordValueImpl)val;
    }

    @Override
    public ArrayValueImpl putArray(String name) {
        FieldDef def = this.validateNameAndType(name, FieldDef.Type.ARRAY);
        ArrayValue val = def.createArray();
        this.valueMap.put(name, val);
        return (ArrayValueImpl)val;
    }

    @Override
    public MapValueImpl putMap(String name) {
        FieldDef def = this.validateNameAndType(name, FieldDef.Type.MAP);
        MapValue val = def.createMap();
        this.valueMap.put(name, val);
        return (MapValueImpl)val;
    }

    @Override
    public int size() {
        return this.valueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.valueMap.isEmpty();
    }

    @Override
    public RecordDefImpl getDefinition() {
        return (RecordDefImpl)super.getDefinition();
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.RECORD;
    }

    @Override
    public boolean isRecord() {
        return true;
    }

    @Override
    public RecordValue asRecord() {
        return this;
    }

    @Override
    public RecordValueImpl clone() {
        return new RecordValueImpl(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RecordValueImpl)) {
            return false;
        }
        RecordValueImpl otherValue = (RecordValueImpl)other;
        if (this.size() == otherValue.size() && this.field.equals(otherValue.getDefinition())) {
            for (Map.Entry<String, FieldValue> entry : this.valueMap.entrySet()) {
                if (entry.getValue().equals(otherValue.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int code = this.size();
        for (Map.Entry<String, FieldValue> entry : this.valueMap.entrySet()) {
            code += entry.getKey().hashCode() + entry.getValue().hashCode();
        }
        return code;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof RecordValueImpl) {
            RecordValueImpl otherImpl = (RecordValueImpl)other;
            if (!this.field.equals(otherImpl.field)) {
                throw new IllegalArgumentException("Cannot compare RecordValues with different definitions");
            }
            return this.compare(otherImpl, this.getFieldsInternal());
        }
        throw new ClassCastException("Object is not an RecordValue");
    }

    public int compare(RecordValueImpl other, List<String> fieldList) {
        for (String fieldName : fieldList) {
            FieldValueImpl val = (FieldValueImpl)this.get(fieldName);
            FieldValueImpl otherVal = (FieldValueImpl)other.get(fieldName);
            if (val != null) {
                if (otherVal == null) {
                    return 1;
                }
                int comp = val.compareTo(otherVal);
                if (comp == 0) continue;
                return comp;
            }
            if (otherVal == null) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        for (String fieldName : this.getFieldsInternal()) {
            FieldValueImpl val = (FieldValueImpl)this.get(fieldName);
            if (val == null) continue;
            node.put(fieldName, val.toJsonNode());
        }
        return node;
    }

    @Override
    public FieldValue remove(String name) {
        return this.valueMap.remove(name);
    }

    @Override
    public void copyFrom(RecordValue source) {
        this.copyFrom(source, false);
    }

    void copyFrom(RecordValue source, boolean ignoreDefinition) {
        if (!ignoreDefinition && !this.getDefinition().equals(source.getDefinition())) {
            throw new IllegalArgumentException("Definition of source record does not match this object");
        }
        for (String fieldName : this.getFieldsInternal()) {
            FieldValue val = source.get(fieldName);
            if (val == null) continue;
            this.putField(fieldName, val);
        }
    }

    @Override
    public boolean contains(String fieldName) {
        return this.valueMap.containsKey(fieldName);
    }

    public void clear() {
        this.valueMap.clear();
    }

    RecordValue putEnum(String name, int value) {
        EnumDefImpl enumField = (EnumDefImpl)this.validateNameAndType(name, FieldDef.Type.ENUM);
        this.valueMap.put(name, enumField.createEnum(value));
        return this;
    }

    public FieldValue put(String name, String value, FieldDef.Type type) {
        FieldDef newField = this.validateNameAndType(name, type);
        FieldValue val = this.create(value, newField);
        this.valueMap.put(name, val);
        return val;
    }

    void copyFields(RecordValueImpl from) {
        for (Map.Entry<String, FieldValue> entry : from.valueMap.entrySet()) {
            this.putField(entry.getKey(), entry.getValue().clone());
        }
    }

    FieldDef getDefinition(String name) {
        return this.getDefinition().getField(name);
    }

    int getNumFields() {
        return this.getDefinition().getNumFields();
    }

    FieldDef getField(String fieldName) {
        return this.getDefinition().getField(fieldName);
    }

    FieldMapEntry getFieldMapEntry(String fieldName) {
        return this.getDefinition().getFieldMapEntry(fieldName, false);
    }

    @Override
    public List<String> getFields() {
        return Collections.unmodifiableList(this.getFieldsInternal());
    }

    protected List<String> getFieldsInternal() {
        return this.getDefinition().getFieldsInternal();
    }

    void validate() {
    }

    @Override
    Object toAvroValue(Schema schema) {
        Schema recordSchema = RecordValueImpl.getRecordSchema(schema);
        GenericData.Record record = new GenericData.Record(recordSchema);
        RecordDefImpl def = this.getDefinition();
        for (Map.Entry<String, FieldMapEntry> entry : def.getFieldMap().getFields().entrySet()) {
            String fieldName = entry.getKey();
            FieldValueImpl fv = (FieldValueImpl)this.get(fieldName);
            if (fv == null) {
                fv = entry.getValue().getDefaultValue();
            }
            if (fv.isNull()) {
                record.put(fieldName, null);
                continue;
            }
            Schema s = recordSchema.getField(fieldName).schema();
            record.put(fieldName, fv.toAvroValue(s));
        }
        return record;
    }

    @Override
    void addJsonFields(JsonParser jp, boolean exact) {
        int numFields = 0;
        try {
            JsonToken t = null;
            while ((t = jp.nextToken()) != JsonToken.END_OBJECT && t != null) {
                JsonToken token;
                String fieldname = jp.getCurrentName();
                if (fieldname == null) continue;
                FieldMapEntry fme = this.getFieldMapEntry(fieldname);
                if (fme == null) {
                    if (exact) {
                        throw new IllegalArgumentException("Unexpected field in JSON input: " + fieldname);
                    }
                    token = jp.nextToken();
                    if (token == JsonToken.START_OBJECT) {
                        RecordValueImpl.skipToJsonToken(jp, JsonToken.END_OBJECT);
                        continue;
                    }
                    if (token != JsonToken.START_ARRAY) continue;
                    RecordValueImpl.skipToJsonToken(jp, JsonToken.END_ARRAY);
                    continue;
                }
                token = jp.nextToken();
                if (token == JsonToken.VALUE_NULL) {
                    if (fme.isNullable()) {
                        this.putNull(fieldname);
                        ++numFields;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid null value in JSON input for field " + fieldname);
                }
                switch (fme.getField().getType()) {
                    case INTEGER: {
                        this.put(fieldname, jp.getIntValue());
                        break;
                    }
                    case LONG: {
                        this.put(fieldname, jp.getLongValue());
                        break;
                    }
                    case DOUBLE: {
                        this.put(fieldname, jp.getDoubleValue());
                        break;
                    }
                    case FLOAT: {
                        this.put(fieldname, jp.getFloatValue());
                        break;
                    }
                    case STRING: {
                        this.put(fieldname, jp.getText());
                        break;
                    }
                    case BINARY: {
                        this.put(fieldname, jp.getBinaryValue());
                        break;
                    }
                    case FIXED_BINARY: {
                        this.putFixed(fieldname, jp.getBinaryValue());
                        break;
                    }
                    case BOOLEAN: {
                        this.put(fieldname, jp.getBooleanValue());
                        break;
                    }
                    case ARRAY: {
                        ArrayValueImpl array = this.putArray(fieldname);
                        array.addJsonFields(jp, exact);
                        break;
                    }
                    case MAP: {
                        MapValueImpl map = this.putMap(fieldname);
                        map.addJsonFields(jp, exact);
                        break;
                    }
                    case RECORD: {
                        RecordValueImpl record = this.putRecord(fieldname);
                        record.addJsonFields(jp, exact);
                        break;
                    }
                    case ENUM: {
                        this.putEnum(fieldname, jp.getText());
                    }
                }
                ++numFields;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
        if (exact && this.getNumFields() != numFields) {
            throw new IllegalArgumentException("Not enough fields for value in JSON input.Found " + numFields + ", expected " + this.getNumFields());
        }
        if (numFields == 0) {
            throw new IllegalArgumentException("No fields found, illegal or empty JSON input");
        }
    }

    static RecordValueImpl fromAvroValue(FieldDef definition, Object obj, Schema schema) {
        Schema recordSchema = RecordValueImpl.getRecordSchema(schema);
        GenericRecord r = (GenericRecord)obj;
        RecordValueImpl record = new RecordValueImpl((RecordDef)definition);
        RecordDefImpl defImpl = (RecordDefImpl)definition;
        for (Map.Entry<String, FieldMapEntry> entry : defImpl.getFieldMap().getFields().entrySet()) {
            FieldMapEntry fme = entry.getValue();
            String fieldName = entry.getKey();
            Object o = r.get(fieldName);
            if (o != null) {
                Schema fieldSchema = recordSchema.getField(fieldName).schema();
                record.put(fieldName, FieldValueImpl.fromAvroValue(fme.getField(), o, fieldSchema));
                continue;
            }
            if (fme.isNullable()) {
                record.putNull(fieldName);
                continue;
            }
            record.put(fieldName, fme.getDefaultValue());
        }
        return record;
    }

    private static Schema getRecordSchema(Schema schema) {
        return RecordValueImpl.getUnionSchema(schema, Schema.Type.RECORD);
    }

    private void putField(String name, FieldValue value) {
        this.valueMap.put(name, value);
    }

    FieldDef validateNameAndType(String name, FieldDef.Type type) {
        FieldDef ft = this.getDefinition(name);
        if (ft == null) {
            throw new IllegalArgumentException("No such field in record " + this.getDefinition().getName() + ": " + name);
        }
        if (ft.getType() != type) {
            throw new IllegalArgumentException("Incorrect type for field " + name + ", type is " + (Object)((Object)type) + ", expected " + (Object)((Object)ft.getType()));
        }
        return ft;
    }

    private FieldValue create(String value, FieldDef field1) {
        switch (field1.getType()) {
            case INTEGER: {
                return new IntegerValueImpl(Integer.parseInt(value));
            }
            case LONG: {
                return new LongValueImpl(Long.parseLong(value));
            }
            case STRING: {
                return new StringValueImpl(value);
            }
            case DOUBLE: {
                return new DoubleValueImpl(Double.parseDouble(value));
            }
            case FLOAT: {
                return new FloatValueImpl(Float.parseFloat(value));
            }
            case BOOLEAN: {
                return new BooleanValueImpl(value);
            }
            case ENUM: {
                return new EnumValueImpl((EnumDef)field1, value);
            }
        }
        throw new IllegalArgumentException("Type not yet implemented: " + (Object)((Object)field1.getType()));
    }
}

