/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.util.Collections;
import java.util.List;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.JsonUtils;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.RecordDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
class RecordDefImpl
extends FieldDefImpl
implements RecordDef {
    private static final long serialVersionUID = 1L;
    final FieldMap fieldMap;
    private final String name;

    RecordDefImpl(String name, FieldMap fieldMap, String description) {
        super(FieldDef.Type.RECORD, description);
        if (fieldMap == null || fieldMap.isEmpty()) {
            throw new IllegalArgumentException("Record has no fields and cannot be built");
        }
        this.name = name;
        this.fieldMap = fieldMap;
    }

    RecordDefImpl(String name, FieldMap fieldMap) {
        this(name, fieldMap, null);
    }

    private RecordDefImpl(RecordDefImpl impl) {
        super(impl);
        this.name = impl.name;
        this.fieldMap = new FieldMap(impl.fieldMap);
    }

    private RecordDefImpl() {
        this.fieldMap = null;
        this.name = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRecord() {
        return true;
    }

    @Override
    public RecordDef asRecord() {
        return this;
    }

    @Override
    public List<String> getFields() {
        return Collections.unmodifiableList(this.fieldMap.getFieldOrder());
    }

    @Override
    public FieldDef getField(String name1) {
        return this.fieldMap.get(name1);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof RecordDefImpl) {
            RecordDefImpl otherDef = (RecordDefImpl)other;
            if (this == otherDef) {
                return true;
            }
            if (this.name.equals(otherDef.name)) {
                return this.fieldMap.equals(otherDef.fieldMap);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.fieldMap.hashCode() + this.name.hashCode();
    }

    @Override
    void toJson(ObjectNode node) {
        node.put("name", this.name);
        super.toJson(node);
        this.fieldMap.putFields(node);
    }

    @Override
    public RecordDefImpl clone() {
        return new RecordDefImpl(this);
    }

    @Override
    public RecordValueImpl createRecord() {
        return new RecordValueImpl(this);
    }

    @Override
    public boolean isNullable(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, true);
        return fme.isNullable();
    }

    @Override
    public FieldValue getDefaultValue(String fieldName) {
        FieldMapEntry fme = this.getFieldMapEntry(fieldName, true);
        return fme.getDefaultValue();
    }

    FieldMap getFieldMap() {
        return this.fieldMap;
    }

    int getNumFields() {
        return this.fieldMap.size();
    }

    List<String> getFieldsInternal() {
        return this.fieldMap.getFieldOrder();
    }

    @Override
    public JsonNode mapTypeToAvro(ObjectNode node) {
        if (node == null) {
            node = JsonUtils.createObjectNode();
        }
        node.put("type", "record");
        node.put("name", this.name);
        ArrayNode array = node.putArray("fields");
        for (String fname : this.fieldMap.getFieldOrder()) {
            FieldMapEntry entry = this.getFieldMapEntry(fname, true);
            ObjectNode fnode = array.addObject();
            fnode.put("name", fname);
            entry.createAvroTypeAndDefault(fnode);
        }
        return node;
    }

    FieldMapEntry getFieldMapEntry(String fieldName, boolean mustExist) {
        FieldMapEntry fme = this.fieldMap.getFieldMapEntry(fieldName);
        if (fme != null) {
            return fme;
        }
        if (mustExist) {
            throw new IllegalArgumentException("Field does not exist in table definition: " + fieldName);
        }
        return null;
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isObject()) {
            throw new IllegalArgumentException("Default value for type RECORD is not a record");
        }
        if (node.size() != 0) {
            throw new IllegalArgumentException("Default value for record must be null or an empty record");
        }
        return this.createRecord();
    }
}

