/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.List;
import java.util.Map;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordDef;

public class PrimaryKeyImpl
extends RowImpl
implements PrimaryKey {
    private static final long serialVersionUID = 1L;

    PrimaryKeyImpl(RecordDef field, TableImpl table) {
        super(field, table);
    }

    PrimaryKeyImpl(RecordDef field, TableImpl table, Map<String, FieldValue> fields) {
        super(field, table, fields);
    }

    private PrimaryKeyImpl(PrimaryKeyImpl other) {
        super(other);
    }

    @Override
    public PrimaryKeyImpl clone() {
        return new PrimaryKeyImpl(this);
    }

    @Override
    public PrimaryKey asPrimaryKey() {
        return this;
    }

    @Override
    public boolean isPrimaryKey() {
        return true;
    }

    @Override
    FieldDef validateNameAndType(String name, FieldDef.Type type) {
        FieldDef def = super.validateNameAndType(name, type);
        if (!this.table.getPrimaryKey().contains(name)) {
            throw new IllegalArgumentException("Field is not part of PrimaryKey: " + name);
        }
        return def;
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            return other != null && other instanceof PrimaryKeyImpl;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    int getNumFields() {
        return this.table.getPrimaryKey().size();
    }

    @Override
    FieldDef getField(String fieldName) {
        FieldDef def = this.getDefinition().getField(fieldName);
        if (def != null && this.table.getPrimaryKey().contains(fieldName)) {
            return def;
        }
        return null;
    }

    @Override
    FieldMapEntry getFieldMapEntry(String fieldName) {
        FieldMapEntry fme = this.getDefinition().getFieldMapEntry(fieldName, false);
        if (fme != null && this.table.getPrimaryKey().contains(fieldName)) {
            return fme;
        }
        return null;
    }

    @Override
    public List<String> getFields() {
        return this.table.getPrimaryKey();
    }

    @Override
    protected List<String> getFieldsInternal() {
        return this.table.getPrimaryKeyInternal();
    }

    @Override
    public int getDataSize() {
        throw new IllegalArgumentException("It is not possible to get data size from a PrimaryKey");
    }

    @Override
    void validate() {
        List<String> key = this.table.getPrimaryKey();
        int numFound = 0;
        for (int i = 0; i < key.size(); ++i) {
            String s = key.get(i);
            if (this.get(s) == null) continue;
            if (i != numFound) {
                throw new IllegalArgumentException("PrimaryKey is missing fields more significant than field: " + s);
            }
            ++numFound;
        }
        if (numFound != this.size()) {
            throw new IllegalArgumentException("PrimaryKey contains a field that is not part of the key");
        }
    }
}

