/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.RowImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Table;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class IndexImpl
implements Index,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final TableImpl table;
    private final List<String> fields;
    private IndexStatus status;

    public IndexImpl(String name, TableImpl table, List<String> fields, String description) {
        this.name = name;
        this.table = table;
        this.fields = fields;
        this.description = description;
        this.status = IndexStatus.TRANSIENT;
        this.validate();
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IndexKeyImpl createIndexKey() {
        return new IndexKeyImpl(this);
    }

    @Override
    public IndexKeyImpl createIndexKey(RecordValue value) {
        IndexKeyImpl key = new IndexKeyImpl(this);
        TableImpl.populateRecord(key, value);
        return key;
    }

    @Override
    public IndexKey createIndexKeyFromJson(String jsonInput, boolean exact) {
        return this.createIndexKeyFromJson(new ByteArrayInputStream(jsonInput.getBytes()), exact);
    }

    @Override
    public IndexKey createIndexKeyFromJson(InputStream jsonInput, boolean exact) {
        IndexKeyImpl key = this.createIndexKey();
        this.table.createFromJson(key, jsonInput, exact);
        return key;
    }

    @Override
    public FieldRange createFieldRange(String fieldName) {
        FieldDef def = this.table.getField(fieldName);
        if (def == null) {
            throw new IllegalArgumentException("Field does not exist in table definition: " + fieldName);
        }
        if (!this.containsField(fieldName)) {
            throw new IllegalArgumentException("Field does not exist in index: " + fieldName);
        }
        return new FieldRange(fieldName, def);
    }

    public boolean isKeyOnly() {
        for (String field : this.fields) {
            if (this.table.isKeyComponent(field)) continue;
            return false;
        }
        return true;
    }

    public boolean isMultiKey() {
        return this.findArray() != null;
    }

    public IndexStatus getStatus() {
        return this.status;
    }

    public void setStatus(IndexStatus status) {
        this.status = status;
    }

    public TableImpl getTableImpl() {
        return this.table;
    }

    List<String> getFieldsInternal() {
        return this.fields;
    }

    private String findArray() {
        for (String fieldName : this.fields) {
            if (!this.table.getField(fieldName).isArray()) continue;
            return fieldName;
        }
        return null;
    }

    public byte[] extractIndexKey(byte[] key, byte[] data, boolean keyOnly) {
        RowImpl row = this.table.createRowFromBytes(key, data, keyOnly);
        if (row != null) {
            return this.serializeIndexKey(row);
        }
        return null;
    }

    public List<byte[]> extractIndexKeys(byte[] key, byte[] data, boolean keyOnly) {
        RowImpl row = this.table.createRowFromBytes(key, data, keyOnly);
        if (row != null) {
            String arrayField = this.findArray();
            assert (arrayField != null);
            int arraySize = row.get(arrayField).asArray().size();
            ArrayList<byte[]> returnList = new ArrayList<byte[]>(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                returnList.add(this.serializeIndexKey(row, i));
            }
            return returnList;
        }
        return null;
    }

    public void toJsonNode(ObjectNode node) {
        node.put("name", this.name);
        node.put("description", this.description);
        ArrayNode fieldArray = node.putArray("fields");
        for (String s : this.fields) {
            fieldArray.add(s);
        }
    }

    private void validate() {
        TableImpl.validateComponent(this.name, false);
        boolean hasArray = false;
        if (this.fields.isEmpty()) {
            throw new IllegalCommandException("Index requires at least one field");
        }
        for (String field : this.fields) {
            if (field == null || field.length() == 0) {
                throw new IllegalCommandException("Invalid (null or empty) index field name");
            }
            FieldDef def = this.table.getField(field);
            if (def == null) {
                throw new IllegalCommandException("Index field not found in table: " + field);
            }
            if (!def.isValidIndexField()) {
                throw new IllegalCommandException("Field type is not valid in an index: " + (Object)((Object)def.getType()) + ", field name: " + field);
            }
            if (!def.isArray()) continue;
            if (hasArray) {
                throw new IllegalCommandException("Indexes may contain only one array field");
            }
            hasArray = true;
        }
        this.table.checkForDuplicateIndex(this);
    }

    public String toString() {
        return "Index[" + this.name + ", " + this.table.getId() + ", " + (Object)((Object)this.status) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeIndexKey(RecordValueImpl record, int arrayIndex) {
        String s;
        FieldValue val;
        TupleOutput out = null;
        out = new TupleOutput();
        Iterator<String> i$ = this.fields.iterator();
        while (i$.hasNext() && (val = record.get(s = i$.next())) != null) {
            FieldDef def = this.table.getField(s);
            if (def.getType() == FieldDef.Type.ARRAY) {
                def = ((ArrayDefImpl)def).getElement();
                val = ((ArrayValueImpl)val).get(arrayIndex);
            }
            if (val.isNull()) {
                byte[] byArray = null;
                return byArray;
            }
            switch (def.getType()) {
                case INTEGER: {
                    out.writeSortedPackedInt(val.asInteger().get());
                    break;
                }
                case STRING: {
                    out.writeString(val.asString().get());
                    break;
                }
                case LONG: {
                    out.writeSortedPackedLong(val.asLong().get());
                    break;
                }
                case DOUBLE: {
                    out.writeSortedDouble(val.asDouble().get());
                    break;
                }
                case FLOAT: {
                    out.writeSortedFloat(val.asFloat().get());
                    break;
                }
                case ENUM: {
                    out.writeSortedPackedInt(val.asEnum().getIndex());
                    break;
                }
                case ARRAY: 
                case BINARY: 
                case BOOLEAN: 
                case FIXED_BINARY: 
                case MAP: 
                case RECORD: {
                    throw new IllegalStateException("Type not supported in indexes: " + (Object)((Object)def.getType()));
                }
            }
        }
        byte[] byArray = out.toByteArray();
        return byArray;
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public byte[] serializeIndexKey(RecordValueImpl record) {
        return this.serializeIndexKey(record, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexKeyImpl rowFromIndexKey(byte[] data, boolean partialOK) {
        IndexKeyImpl ikey = this.createIndexKey();
        TupleInput input = null;
        try {
            input = new TupleInput(data);
            for (String s : this.fields) {
                if (input.available() <= 0) break;
                FieldDef def = this.table.getField(s);
                switch (def.getType()) {
                    case INTEGER: {
                        ikey.put(s, input.readSortedPackedInt());
                        break;
                    }
                    case STRING: {
                        ikey.put(s, input.readString());
                        break;
                    }
                    case LONG: {
                        ikey.put(s, input.readSortedPackedLong());
                        break;
                    }
                    case DOUBLE: {
                        ikey.put(s, input.readSortedDouble());
                        break;
                    }
                    case FLOAT: {
                        ikey.put(s, input.readSortedFloat());
                        break;
                    }
                    case ENUM: {
                        ikey.putEnum(s, input.readSortedPackedInt());
                        break;
                    }
                    case ARRAY: {
                        ArrayValueImpl array = ikey.putArray(s);
                        this.readArrayElement(array, input);
                        break;
                    }
                    case BINARY: 
                    case BOOLEAN: 
                    case FIXED_BINARY: 
                    case MAP: 
                    case RECORD: {
                        throw new IllegalStateException("Type not supported in indexes: " + (Object)((Object)def.getType()));
                    }
                }
            }
            if (!partialOK && ikey.size() != this.fields.size()) {
                throw new IllegalStateException("Missing fields from index data");
            }
            IndexKeyImpl indexKeyImpl = ikey;
            return indexKeyImpl;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private void readArrayElement(ArrayValueImpl array, TupleInput input) {
        switch (array.getDefinition().getElement().getType()) {
            case INTEGER: {
                array.add(input.readSortedPackedInt());
                break;
            }
            case STRING: {
                array.add(input.readString());
                break;
            }
            case LONG: {
                array.add(input.readSortedPackedLong());
                break;
            }
            case DOUBLE: {
                array.add(input.readSortedDouble());
                break;
            }
            case FLOAT: {
                array.add(input.readSortedFloat());
                break;
            }
            case ENUM: {
                array.addEnum(input.readSortedPackedInt());
                break;
            }
            default: {
                throw new IllegalStateException("Type not supported in indexes: ");
            }
        }
    }

    boolean containsField(String fieldName) {
        for (String s : this.fields) {
            if (!s.equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static enum IndexStatus {
        TRANSIENT{

            @Override
            public boolean isTransient() {
                return true;
            }
        }
        ,
        POPULATING{

            @Override
            public boolean isPopulating() {
                return true;
            }
        }
        ,
        READY{

            @Override
            public boolean isReady() {
                return true;
            }
        };


        public boolean isTransient() {
            return false;
        }

        public boolean isPopulating() {
            return false;
        }

        public boolean isReady() {
            return false;
        }
    }
}

