/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
public class FieldMap
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, FieldMapEntry> fields;
    private final List<String> fieldOrder;

    FieldMap() {
        this.fields = new TreeMap<String, FieldMapEntry>(FieldComparator.instance);
        this.fieldOrder = new LinkedList<String>();
    }

    FieldMap(FieldMap other) {
        this.fields = FieldMap.copyMap(other.fields);
        this.fieldOrder = FieldMap.copyFieldOrder(other.fieldOrder);
    }

    FieldMap(Map<String, FieldMapEntry> fields, List<String> fieldOrder) {
        this.fields = FieldMap.copyMap(fields);
        this.fieldOrder = FieldMap.copyFieldOrder(fieldOrder);
    }

    private static Map<String, FieldMapEntry> copyMap(Map<String, FieldMapEntry> map) {
        TreeMap<String, FieldMapEntry> newMap = new TreeMap<String, FieldMapEntry>(FieldComparator.instance);
        for (Map.Entry<String, FieldMapEntry> entry : map.entrySet()) {
            newMap.put(entry.getKey(), entry.getValue().clone());
        }
        return newMap;
    }

    private static List<String> copyFieldOrder(List<String> other) {
        LinkedList<String> newList = new LinkedList<String>();
        for (String s : other) {
            newList.add(s);
        }
        return newList;
    }

    Map<String, FieldMapEntry> getFields() {
        return this.fields;
    }

    List<String> getFieldOrder() {
        return this.fieldOrder;
    }

    FieldDef get(String name) {
        FieldMapEntry fme = this.fields.get(name);
        return fme != null ? fme.getField() : null;
    }

    void put(String name, FieldMapEntry field) {
        this.fieldOrder.add(name);
        this.fields.put(name, field);
    }

    void put(String name, FieldDef field, boolean nullable, FieldValue defaultValue) {
        this.fieldOrder.add(name);
        this.put(name, new FieldMapEntry((FieldDefImpl)field, nullable, (FieldValueImpl)defaultValue));
    }

    boolean exists(String name) {
        return this.fields.containsKey(name);
    }

    FieldMapEntry remove(String name) {
        this.fieldOrder.remove(name);
        return this.fields.remove(name);
    }

    public boolean isEmpty() {
        return this.fieldOrder.isEmpty();
    }

    int size() {
        return this.fieldOrder.size();
    }

    public FieldMap clone() {
        return new FieldMap(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldMap) {
            FieldMap other = (FieldMap)obj;
            if (this.fieldOrder.size() == other.fieldOrder.size()) {
                for (int i = 0; i < this.fieldOrder.size(); ++i) {
                    String otherName;
                    String name = this.fieldOrder.get(i);
                    if (name.equals(otherName = other.fieldOrder.get(i)) && this.fields.get(name).equals(other.fields.get(name))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int code = this.fieldOrder.size();
        for (Map.Entry<String, FieldMapEntry> entry : this.fields.entrySet()) {
            code += entry.getKey().hashCode() + entry.getValue().hashCode();
        }
        return code;
    }

    void putFields(ObjectNode node) {
        ArrayNode array = node.putArray("fields");
        for (String fname : this.getFieldOrder()) {
            FieldMapEntry entry = this.getFieldMapEntry(fname);
            ObjectNode fnode = array.addObject();
            fnode.put("name", fname);
            entry.toJson(fnode);
        }
    }

    FieldMapEntry getFieldMapEntry(String name) {
        return this.fields.get(name);
    }
}

