/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.table.BooleanValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.BooleanNode;

@Persistent(version=1)
class BooleanValueImpl
extends FieldValueImpl
implements BooleanValue {
    private static final long serialVersionUID = 1L;
    private boolean value;

    BooleanValueImpl(boolean value) {
        this.value = value;
    }

    BooleanValueImpl(String value) {
        this.value = Boolean.parseBoolean(value);
    }

    private BooleanValueImpl() {
    }

    public static BooleanValueImpl create(boolean value) {
        return new BooleanValueImpl(value);
    }

    @Override
    public boolean get() {
        return this.value;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.BOOLEAN;
    }

    @Override
    public BooleanValueImpl clone() {
        return new BooleanValueImpl(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof BooleanValueImpl) {
            return this.value == ((BooleanValueImpl)other).get();
        }
        return false;
    }

    public int hashCode() {
        return Boolean.valueOf(this.value).hashCode();
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof BooleanValueImpl) {
            return Boolean.valueOf(this.value).compareTo(((BooleanValueImpl)other).value);
        }
        throw new ClassCastException("Object is not an BooleanValue");
    }

    @Override
    public JsonNode toJsonNode() {
        return this.value ? BooleanNode.TRUE : BooleanNode.FALSE;
    }

    @Override
    public BooleanValue asBoolean() {
        return this;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }
}

