/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.IOException;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.CollectionBuilder;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.JsonUtils;
import oracle.kv.impl.api.table.TableBuilderBase;
import oracle.kv.table.ArrayDef;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ObjectNode;

public class ArrayBuilder
extends CollectionBuilder {
    ArrayBuilder(String description) {
        super(description);
    }

    ArrayBuilder() {
    }

    @Override
    public String getBuilderType() {
        return "Array";
    }

    @Override
    public ArrayDef build() {
        if (this.field == null) {
            throw new IllegalArgumentException("Array has no field and cannot be built");
        }
        return new ArrayDefImpl((FieldDefImpl)this.field, this.description);
    }

    @Override
    TableBuilderBase generateAvroSchemaFields(Schema schema, String name1, JsonNode defaultValue, String desc) {
        Schema elementSchema = schema.getElementType();
        super.generateAvroSchemaFields(elementSchema, elementSchema.getName(), null, elementSchema.getDoc());
        return this;
    }

    public String toJsonString(boolean pretty) {
        ObjectWriter writer = JsonUtils.createWriter(pretty);
        ObjectNode o = JsonUtils.createObjectNode();
        ArrayDefImpl tmp = new ArrayDefImpl((FieldDefImpl)this.field, this.description);
        tmp.toJson(o);
        try {
            return writer.writeValueAsString(o);
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
    }
}

