/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ReturnResultValueVersion;
import oracle.kv.impl.api.ops.TableOperationHandler;
import oracle.kv.impl.topo.PartitionId;

public class PutIfPresent
extends Put {
    public PutIfPresent(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice) {
        this(keyBytes, value, prevValChoice, 0L);
    }

    public PutIfPresent(byte[] keyBytes, Value value, ReturnValueVersion.Choice prevValChoice, long tableId) {
        super(InternalOperation.OpCode.PUT_IF_PRESENT, keyBytes, value, prevValChoice, tableId);
    }

    PutIfPresent(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.PUT_IF_PRESENT, in, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        this.checkPermission();
        TableOperationHandler.checkTable(operationHandler, this.getTableId());
        ReturnResultValueVersion prevVal = new ReturnResultValueVersion(this.getReturnValueVersionChoice());
        Version newVersion = operationHandler.putIfPresent(txn, partitionId, this.getKeyBytes(), this.getValueBytes(), prevVal);
        return new Result.PutResult(this.getOpCode(), prevVal.getValueVersion(), newVersion);
    }
}

