/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.DatabaseEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.Depth;
import oracle.kv.KeyRange;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.util.UserDataControl;

abstract class MultiKeyOperation
extends InternalOperation {
    private static final OperationHandler.KVAuthorizer UNIVERSAL_AUTHORIZER = new OperationHandler.KVAuthorizer(){

        @Override
        public boolean allowAccess(DatabaseEntry keyEntry) {
            return true;
        }

        @Override
        public boolean allowFullAccess() {
            return true;
        }
    };
    private final byte[] parentKey;
    private final KeyRange subRange;
    private final Depth depth;

    MultiKeyOperation(InternalOperation.OpCode opCode, byte[] parentKey, KeyRange subRange, Depth depth) {
        super(opCode);
        this.parentKey = parentKey;
        this.subRange = subRange;
        this.depth = depth;
    }

    MultiKeyOperation(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        short keyLen = in.readShort();
        if (keyLen < 0) {
            this.parentKey = null;
        } else {
            this.parentKey = new byte[keyLen];
            in.readFully(this.parentKey);
        }
        this.subRange = in.read() == 0 ? null : new KeyRange(in, serialVersion);
        this.depth = Depth.getDepth(in.readUnsignedByte());
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (this.parentKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.parentKey.length);
            out.write(this.parentKey);
        }
        if (this.subRange == null) {
            out.write(0);
        } else {
            out.write(1);
            this.subRange.writeFastExternal(out, serialVersion);
        }
        out.writeByte(this.depth.ordinal());
    }

    OperationHandler.KVAuthorizer checkPermission() {
        if (this.parentKey != null && this.isPrivateAccess(this.parentKey) && !this.isInternalRequestor()) {
            throw new UnauthorizedException("Illegal access to internal keyspace");
        }
        if (this.parentKey != null && !this.mayBePrivateAccess(this.parentKey) || this.isInternalRequestor()) {
            return UNIVERSAL_AUTHORIZER;
        }
        return new OperationHandler.KVAuthorizer(){

            @Override
            public boolean allowAccess(DatabaseEntry keyEntry) {
                return !MultiKeyOperation.this.isPrivateAccess(keyEntry.getData());
            }

            @Override
            public boolean allowFullAccess() {
                return false;
            }
        };
    }

    byte[] getParentKey() {
        return this.parentKey;
    }

    KeyRange getSubRange() {
        return this.subRange;
    }

    Depth getDepth() {
        return this.depth;
    }

    @Override
    public String toString() {
        return super.toString() + " parentKey: " + UserDataControl.displayKey(this.parentKey) + " subRange: " + UserDataControl.displayKeyRange(this.subRange) + " depth: " + (Object)((Object)this.depth);
    }
}

