/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.Depth;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.topo.PartitionId;

public class MultiDelete
extends MultiKeyOperation {
    private static final short LOB_SERIAL_VERSION = 2;
    private final byte[] lobSuffixBytes;

    public MultiDelete(byte[] parentKey, KeyRange subRange, Depth depth, byte[] lobSuffixBytes) {
        super(InternalOperation.OpCode.MULTI_DELETE, parentKey, subRange, depth);
        this.lobSuffixBytes = lobSuffixBytes;
    }

    MultiDelete(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.MULTI_DELETE, in, serialVersion);
        if (serialVersion >= 2) {
            short suffixLen = in.readShort();
            if (suffixLen == 0) {
                this.lobSuffixBytes = null;
            } else {
                this.lobSuffixBytes = new byte[suffixLen];
                in.readFully(this.lobSuffixBytes);
            }
        } else {
            this.lobSuffixBytes = null;
        }
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 2) {
            if (this.lobSuffixBytes != null && this.lobSuffixBytes.length > 0) {
                out.writeShort(this.lobSuffixBytes.length);
                out.write(this.lobSuffixBytes);
            } else {
                out.writeShort(0);
            }
        }
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        OperationHandler.KVAuthorizer kvAuth = this.checkPermission();
        int result = operationHandler.multiDelete(txn, partitionId, this.getParentKey(), this.getSubRange(), this.getDepth(), this.lobSuffixBytes, kvAuth);
        return new Result.MultiDeleteResult(this.getOpCode(), result);
    }
}

