/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.lob;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.Key;
import oracle.kv.KeyValueVersion;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.lob.DeleteOperation;
import oracle.kv.impl.api.lob.WriteOperation;
import oracle.kv.impl.util.UserDataControl;
import oracle.kv.lob.KVLargeObject;
import oracle.kv.lob.PartialLOBException;

public class PutOperation
extends WriteOperation {
    PutOperation(KVStoreImpl kvsImpl, Key appLobKey, InputStream lobStream, Durability durability, long chunkTimeout, TimeUnit timeoutUnit) {
        super(kvsImpl, appLobKey, lobStream, durability, chunkTimeout, timeoutUnit);
    }

    Version execute(boolean requirePresent, boolean requireAbsent) throws IOException {
        KeyValueVersion appLobKVV;
        Version metadataVV = null;
        try {
            appLobKVV = this.createAppLobKVV(requirePresent, requireAbsent);
            if (appLobKVV == null) {
                return null;
            }
            this.initMetadata();
            this.lobProps.startPut();
            metadataVV = this.persistMetadata();
        }
        catch (ResumePutException e) {
            appLobKVV = e.appLobKVV;
            metadataVV = e.metadataVersion;
            this.setupForResume(e.metadataVersion);
        }
        metadataVV = this.putChunks(this.lobSize, null, metadataVV);
        this.lobProps.endPut();
        this.updateMetadata(metadataVV);
        return appLobKVV.getVersion();
    }

    private KeyValueVersion createAppLobKVV(boolean requirePresent, boolean requireAbsent) throws ResumePutException {
        ValueVersion prevVV;
        this.internalLOBKey = PutOperation.createInternalLobKey();
        Value appLobValue = PutOperation.ilkToValue(this.internalLOBKey);
        if (requirePresent) {
            prevVV = this.kvsImpl.get(this.appLOBKey, Consistency.ABSOLUTE, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
            if (prevVV == null) {
                return null;
            }
        } else {
            prevVV = new ReturnValueVersion(ReturnValueVersion.Choice.ALL);
            Version appLobVersion = this.kvsImpl.putIfAbsent(this.appLOBKey, appLobValue, (ReturnValueVersion)prevVV, CHUNK_DURABILITY, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
            if (appLobVersion != null) {
                return new KeyValueVersion(this.appLOBKey, appLobValue, appLobVersion);
            }
        }
        Key extantInternalLobKey = PutOperation.valueToILK(prevVV.getValue());
        Value extantAppLobValue = PutOperation.ilkToValue(extantInternalLobKey);
        Version extantAppLobVersion = prevVV.getVersion();
        ValueVersion metadataVV = this.kvsImpl.get(extantInternalLobKey, Consistency.ABSOLUTE, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
        if (metadataVV == null) {
            this.internalLOBKey = extantInternalLobKey;
            return new KeyValueVersion(this.appLOBKey, extantAppLobValue, extantAppLobVersion);
        }
        this.initMetadata(metadataVV.getValue());
        if (!this.lobProps.isPartiallyDeleted()) {
            if (!this.lobProps.isComplete()) {
                if (this.lobProps.isPartiallyAppended()) {
                    throw new PartialLOBException("Partially appended LOB. Key: " + UserDataControl.displayKey(this.appLOBKey) + " Internal key: " + this.internalLOBKey, KVLargeObject.LOBState.PARTIAL_APPEND, false);
                }
                this.internalLOBKey = extantInternalLobKey;
                KeyValueVersion kvv = new KeyValueVersion(this.appLOBKey, extantAppLobValue, extantAppLobVersion);
                throw new ResumePutException(kvv, metadataVV.getVersion());
            }
            if (requireAbsent) {
                return null;
            }
        }
        new DeleteOperation(this.kvsImpl, this.appLOBKey, this.lobDurability, this.chunkTimeoutMs, TimeUnit.MILLISECONDS).execute(true);
        Version replaceAppLobVersion = this.kvsImpl.putIfVersion(this.appLOBKey, appLobValue, prevVV.getVersion(), null, CHUNK_DURABILITY, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
        if (replaceAppLobVersion == null) {
            String msg = "Concurrent LOB put detected for key: " + UserDataControl.displayKey(this.appLOBKey);
            throw new ConcurrentModificationException(msg);
        }
        return new KeyValueVersion(this.appLOBKey, appLobValue, replaceAppLobVersion);
    }

    private Version persistMetadata() {
        Value propsArray = this.lobProps.serialize();
        Version storedVersion = this.kvsImpl.putIfAbsent(this.internalLOBKey, propsArray, null, this.lobDurability, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
        if (storedVersion == null) {
            String msg = "Metadata for internal key: " + this.internalLOBKey + " already exists for key: " + this.appLOBKey;
            throw new ConcurrentModificationException(msg);
        }
        return storedVersion;
    }

    private static Key createInternalLobKey() {
        return Key.createKey(Arrays.asList("", "lob", UUID.randomUUID().toString()));
    }

    private class ResumePutException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Version metadataVersion;
        private final KeyValueVersion appLobKVV;

        public ResumePutException(KeyValueVersion applobKVV, Version metadataVersion) {
            this.appLobKVV = applobKVV;
            this.metadataVersion = metadataVersion;
        }
    }
}

