/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

public class ClientId
extends ResourceId {
    private static final String CLIENT_PREFIX = "c";
    private static final long serialVersionUID = 1L;
    final long clientNum;

    public ClientId(long clientNum) {
        this.clientNum = clientNum;
    }

    public ClientId(ObjectInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.clientNum = in.readLong();
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeLong(this.clientNum);
    }

    @Override
    public ResourceId.ResourceType getType() {
        return ResourceId.ResourceType.CLIENT;
    }

    public String toString() {
        return CLIENT_PREFIX + this.clientNum;
    }

    @Override
    public Topology.Component<?> getComponent(Topology topology) {
        throw new UnsupportedOperationException("Method not meaningful for " + (Object)((Object)this.getType()));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientId other = (ClientId)obj;
        return this.clientNum == other.clientNum;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.clientNum ^ this.clientNum >>> 32);
        return result;
    }
}

