/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop;

import java.io.IOException;
import oracle.kv.Key;
import oracle.kv.Value;
import oracle.kv.avro.AvroCatalog;
import oracle.kv.avro.GenericAvroBinding;
import oracle.kv.hadoop.AvroFormatter;
import oracle.kv.hadoop.KVInputSplit;
import oracle.kv.hadoop.KVRecordReaderBase;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class KVAvroRecordReader
extends KVRecordReaderBase<Key, IndexedRecord> {
    private Class<?> formatterClass;
    private AvroFormatter formatter = null;
    private GenericAvroBinding binding;

    @Override
    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        KVInputSplit kvInputSplit = (KVInputSplit)split;
        super.initialize(split, context);
        String formatterClassName = kvInputSplit.getFormatterClassName();
        if (formatterClassName != null && !"".equals(formatterClassName)) {
            try {
                this.formatterClass = Class.forName(formatterClassName);
                this.formatter = (AvroFormatter)this.formatterClass.newInstance();
            }
            catch (Exception E) {
                IllegalArgumentException iae = new IllegalArgumentException("Couldn't find formatter class: " + formatterClassName);
                iae.initCause(E);
                throw iae;
            }
        }
        AvroCatalog catalog = this.kvstore.getAvroCatalog();
        this.binding = catalog.getGenericMultiBinding(catalog.getCurrentSchemas());
    }

    public IndexedRecord getCurrentValue() throws IOException, InterruptedException {
        if (this.current == null) {
            return null;
        }
        if (this.formatter != null) {
            return this.formatter.toAvroRecord(this.current, this.kvstore);
        }
        Value value = this.current.getValue();
        GenericRecord record = null;
        if (value != null) {
            record = this.binding.toObject(value);
        }
        return record;
    }

    public Key getCurrentKey() throws IOException, InterruptedException {
        if (this.current == null) {
            return null;
        }
        return this.current.getKey();
    }
}

