/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.JEVersion;

public abstract class DatabaseException
extends RuntimeException {
    private static final long serialVersionUID = 1535562945L;
    private String extraInfo = null;

    public DatabaseException(Throwable t) {
        super(DatabaseException.getVersionHeader() + t.toString(), t);
    }

    public DatabaseException(String message) {
        super(DatabaseException.getVersionHeader() + message);
    }

    public DatabaseException(String message, Throwable t) {
        super(DatabaseException.getVersionHeader() + message, t);
    }

    public static String getVersionHeader() {
        return "(JE " + JEVersion.CURRENT_VERSION + ") ";
    }

    public void addErrorMessage(String newExtraInfo) {
        this.extraInfo = this.extraInfo == null ? " " + newExtraInfo : this.extraInfo + ' ' + newExtraInfo;
    }

    @Override
    public String getMessage() {
        if (this.extraInfo == null) {
            return super.getMessage();
        }
        return super.getMessage() + this.extraInfo;
    }
}

