from shutil import copy
from os import mkdir
from os.path import exists

import sys
print "\nsys.path=" 
print sys.path

userName =  "%USER_NAME%"
passWord = "%PASS_WORD%" 
port = "%PORT%"
hostname = "%HOST_NAME%"
targetServer = "%ADMIN_SERVER%"
domainPath = "%DOMAIN_PATH%"
jdbcDecriptorFile = "%JDBC_DESCRIPTOR_FILE%"
newSystemModuleName = "%JDBC_MODULE_NAME%"

try:
	connect( userName, passWord, "t3://" + hostname + ":" + port )
except Exception, e:
	print e 
	dumpStack()

edit()
startEdit(60000, 120000 )

existingSystemModuleName = ""

servermb=getMBean("Servers/" + targetServer )
if servermb is None:
	print '@@@ No server MBean found: ' + targetServer 
else:
	print 'Prepare JDBC module for target server ' + targetServer 

#Search for the system module using default name implied by descriptor file name
jdbcMySystemResourceList = find (  newSystemModuleName, "JDBCSystemResource" )
if jdbcMySystemResourceList.size() > 0 :
	modulePath = jdbcMySystemResourceList[0].split('/')
	existingSystemModuleName = modulePath[2]
else:
	#try find a system module which has the same descriptor name
	cd ('/JDBCSystemResources')
	descriptorPath = find( 'DescriptorFileName' )
	for path in descriptorPath:
		values = path.split()
		if values[2]=='jdbc/' + newSystemModuleName +'-jdbc.xml':
			modulePath = values[0].split('/')	   		
			print 'Found module: ' + modulePath[2]
			existingSystemModuleName = modulePath[2]
			break

if len( existingSystemModuleName ) > 0 :
	print 'Updating JDBC System module ' + existingSystemModuleName
	cd ( '/JDBCSystemResources/' + existingSystemModuleName )

	#Touch the Notes attribute for the system module so that an XML is saved 
	#into domain/config/pending when we call save()
	notes = 'JDBC Resource has been updated from OEPE'
	cmo.setNotes(notes)
	targetName=cmo.getDescriptorFileName()
else:
	print 'Creating ' + newSystemModuleName
	jdbcMySystemResource = create (  newSystemModuleName, "JDBCSystemResource" )
	jdbcMySystemResource.setName( newSystemModuleName )
	print( jdbcMySystemResource )
	
	cd ( '/JDBCSystemResources/')
	cd( newSystemModuleName )
	#WebLogic may generate a JDBC system module config XML with different name from the source
	targetName=cmo.getDescriptorFileName()
	 
	#Touch the Notes attribute for the system module so that an XML is saved 
	#into domain/config/pending when we call save()
	notes = '' + newSystemModuleName
	cmo.setNotes(notes)
	cd('JDBCResource')
	cd( newSystemModuleName )
	cmo.setName(newSystemModuleName)
	jdbcMySystemResource.addTarget(servermb)

#Save the change into [domain]/pending/jdbc 
try:
	save()
except Exception, e:
	print e
	print '[ERROR]save JDBC system module changes'
	dumpStack()
	
print "Copy JDBC Descriptor from " + jdbcDecriptorFile + " to target " + domainPath +  "/pending/" +  targetName

try:
	if exists(domainPath +  "/pending/jdbc" )== False :
		os.mkdir( domainPath +  "/pending/jdbc" )
except Exception, e:
	print e 
	print "Found " + domainPath +  "/pending/jdbc"

try:
	copy( jdbcDecriptorFile, domainPath +  "/pending/" + targetName);
	activate()
except Exception, e:
	print e 
	print '[ERROR]activate JDBC system module changes'
	dumpStack()

#A simple workaround to make sure the WLS MBean edit tree (used by WLS Console)
#picks up the changes just activated
print 'Synchronizing WebLogic MBean edit tree'
startEdit(60000, 120000 )
undo('true', 'y')
stopEdit('y')
disconnect()