package oracle.eclipse.tools.debug;

import java.beans.BeanInfo;
import java.io.IOException;

import javax.faces.application.Resource;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;

public class OepeViewHandler extends ViewHandlerWrapper {

	private ViewHandler parent;

	public OepeViewHandler(final ViewHandler parent) {
		this.parent = parent;
	}

	@Override
	public ViewDeclarationLanguage getViewDeclarationLanguage(
			FacesContext context, String viewId) {
		ViewDeclarationLanguage vdl = super.getViewDeclarationLanguage(context,
				viewId);
		return new WrappingViewDeclarationLanguage(vdl);
	}

	@Override
	public ViewHandler getWrapped() {
		return this.parent;
	}

	public static class WrappingViewDeclarationLanguage extends
			ViewDeclarationLanguage {

		private ViewDeclarationLanguage vdl;

		public WrappingViewDeclarationLanguage(final ViewDeclarationLanguage vdl) {
			this.vdl = vdl;
		}

		@Override
		public BeanInfo getComponentMetadata(FacesContext context,
				Resource componentResource) {
			return this.vdl.getComponentMetadata(context, componentResource);
		}

		@Override
		public ViewMetadata getViewMetadata(FacesContext context, String viewId) {
			return this.vdl.getViewMetadata(context, viewId);
		}

		@Override
		public Resource getScriptComponentResource(FacesContext context,
				Resource componentResource) {
			return this.vdl.getScriptComponentResource(context,
					componentResource);
		}

		@Override
		public UIViewRoot createView(FacesContext context, String viewId) {
			return this.vdl.createView(context, viewId);
		}

		@Override
		public UIViewRoot restoreView(FacesContext context, String viewId) {
			return this.vdl.restoreView(context, viewId);
		}

		@Override
		public void buildView(FacesContext context, UIViewRoot root)
				throws IOException {
			this.vdl.buildView(context, root);
		}

		@Override
		public void renderView(FacesContext context, UIViewRoot view)
				throws IOException {
			this.vdl.renderView(context, view);

		}

		@Override
		public StateManagementStrategy getStateManagementStrategy(
				FacesContext context, String viewId) {
			return this.vdl.getStateManagementStrategy(context, viewId);
		}

	}
}
