package oracle.eclipse.tools.debug;

import java.util.Map;

import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.FacesContextWrapper;
import javax.faces.context.Flash;
import javax.faces.lifecycle.Lifecycle;


public class OepeAdfFacesContextFactory extends FacesContextFactory {

	private static class OepeAdfFacesContextWrapper extends FacesContextWrapper {
		private final FacesContext facesContext;

		private OepeAdfFacesContextWrapper(FacesContext facesContext) {
			this.facesContext = facesContext;
			FacesContext.setCurrentInstance(this);
		}

		@Override
		public ExternalContext getExternalContext() {

			final ExternalContext externalContext = super.getExternalContext();
			return new ExternalContextWrapper() {

				@SuppressWarnings("unchecked")
				@Override
				public Map<String, Object> getRequestMap() {
					@SuppressWarnings("rawtypes")
					final Map requestMap = super.getRequestMap();
					return new ScopedMapDecorator(requestMap, "request", OepeAdfFacesContextWrapper.this);
				}

				@Override
				public Flash getFlash() {
					Flash flash = super.getFlash();
					return new FlashDecorator(flash);
				}

				@Override
				public ExternalContext getWrapped() {
					return externalContext;
				}
			};
		}

		@Override
		public FacesContext getWrapped() {
			return facesContext;
		}
	}

	private FacesContextFactory parent;

	public OepeAdfFacesContextFactory(final FacesContextFactory parent) {
		super();
		this.parent = parent;
	}

	@Override
	public FacesContext getFacesContext(Object context, Object request,
			Object response, Lifecycle lifecycle) throws FacesException {
		final FacesContext facesContext = this.parent.getFacesContext(context,
				request, response, lifecycle);
		return new OepeAdfFacesContextWrapper(facesContext);
	}

}
