package oracle.eclipse.tools.debug;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.faces.context.FacesContext;
import javax.faces.context.Flash;

public class FlashDecorator extends Flash {

	private Flash delegate;

	public FlashDecorator(Flash delegate) {
		this.delegate = delegate;
	}

	@Override
	public int size() {
		return this.delegate.size();
	}

	public boolean containsKey(Object key) {
		return delegate.containsKey(key);
	}

	public boolean containsValue(Object value) {
		return delegate.containsValue(value);
	}

	public void clear() {
		delegate.clear();
	}

	public void doPostPhaseActions(FacesContext arg0) {
		delegate.doPostPhaseActions(arg0);
	}

	public void doPrePhaseActions(FacesContext arg0) {
		delegate.doPrePhaseActions(arg0);
	}

	public int hashCode() {
		return delegate.hashCode();
	}

	public boolean equals(Object obj) {
		return delegate.equals(obj);
	}

	public boolean isEmpty() {
		return delegate.isEmpty();
	}

	public Object get(Object key) {
		return delegate.get(key);
	}

	public Set<java.util.Map.Entry<String, Object>> entrySet() {
		return delegate.entrySet();
	}

	public boolean isKeepMessages() {
		return delegate.isKeepMessages();
	}

	public boolean isRedirect() {
		return delegate.isRedirect();
	}

	public void keep(String key) {
		delegate.keep(key);
		ELVariableWriter.writeVariable(key, get(key), "flash", "kept", FacesContext.getCurrentInstance());
	}

	public Object put(String key, Object value) {
		ELVariableWriter.writeVariable(key, value, "flash", "declared", FacesContext.getCurrentInstance());
		return delegate.put(key, value);
	}

	public void putAll(Map<? extends String, ? extends Object> m) {
		delegate.putAll(m);
	}

	public Set<String> keySet() {
		return delegate.keySet();
	}

	public void putNow(String key, Object value) {
		ELVariableWriter.writeVariable(key, value, "flash", "declared now", FacesContext.getCurrentInstance());
		delegate.putNow(key, value);
	}

	public Object remove(Object key) {
		final Object oldValue = delegate.remove(key);
		System.out.printf(
				"REMOVE: Remove from %s map: key %s, old Value: %s\n",
				"flash", key, oldValue);
		return oldValue;
	}

	public void setKeepMessages(boolean arg0) {
		delegate.setKeepMessages(arg0);
	}

	public void setRedirect(boolean arg0) {
		delegate.setRedirect(arg0);
	}

	public String toString() {
		return delegate.toString();
	}

	public Collection<Object> values() {
		return delegate.values();
	}
}
