/*******************************************************************************
 * Copyright (c) 2010, 2012 Oracle and/or its affiliates
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Oracle and/or its affiliates.
 ******************************************************************************/
package com.tasktop.c2c.server.scm.domain;

/**
 * Temporary solution to slashes in revision names such as branches or tags.
 * 
 * @author phrebejk
 */
@SuppressWarnings("serial")
public class RevPathItem extends Item {

	private String filePath;
	private String revisionName;

	public RevPathItem() {
	}

	public RevPathItem(String revisionName, String filePath, String sha, Item.Type type) {
		super(sha, type);
		this.filePath = filePath;
		this.revisionName = revisionName;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public String getRevisionName() {
		return revisionName;
	}

	public void setRevisionName(String revisionName) {
		this.revisionName = revisionName;
	}

}
