<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:transform version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output encoding="iso-8859-15" method="html" indent="yes"
		standalone="yes" omit-xml-declaration="yes"
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" />

	<xsl:strip-space elements="*" />

	<xsl:template match="/">
	    <xsl:param name="requestUrl" />
	    <xsl:param name="queryString"/>
	    <xsl:param name="serverRelativePath" />
		<html>
			<head>
				<style>
					.tableNameHeading {
					margin-top:2em;
					margin-bottom:1em;
					border-top: 2px solid gray;
					border-bottom: 1px solid #C0C0C0;
					background-color:#F5F5FF;
					}

					.tableComment {
					background-color:#e4efff; margin-bottom:20px;
					}

					.tableDefinition {
					padding:2px; border-collapse:collapse; margin-top:1em;
					}

					.tdTableDefinition {
					padding-right:10px;
					vertical-align:top;
					border-bottom:1px solid #C0C0C0;
					}

					.tdColName {
					width:20em;
					}

					.tdDataType {
					width:10em;
					}

					.tdPkFlag {
					width:4em;
					}

					.tdNullFlag {
					width:9em;
					}

					.tdTableHeading {
					padding:2px;
					font-weight:bold;
					vertical-align:top;
					border-bottom: 1px solid #C0C0C0;
					background-color: rgb(240,240,240);
					}

					.subTitle {
					font-size:110%;
					font-variant:small-caps;
					}
				</style>

				<title>
					<xsl:call-template name="write-name" />
				</title>
			</head>
			<body>
				<!-- <xsl:call-template name="create-toc"/> -->
				<h2>Summary for facelet compilation unit</h2>
				<h3><xsl:value-of select="/faceletTagReport/compilationUnit"/></h3>
				<h3><xsl:value-of select="$requestUrl" /></h3>
				<h3>Tag Errors</h3>
				<xsl:call-template name="table-for-tagerrors"/>
                <h3>Facelet Inclusion Errors</h3>
                <xsl:call-template name="table-for-tagincludeerrors"/>
                 <h3>Facelet Inclusions</h3>
                <xsl:call-template name="table-for-inclusions" >
                    <xsl:with-param name="requestUrl" select="$requestUrl" />
                    <xsl:with-param name="serverRelativePath" select="$serverRelativePath"/>
                </xsl:call-template>
                <h3>Facelet Namespace Ranges</h3>
                <xsl:call-template name="table-for-namespace-ranges"/>
                <h3>Tag Ranges</h3>
                <xsl:call-template name="table-for-tag-ranges" />
                <h3>Attribute Ranges</h3>
                <xsl:call-template name="table-for-attribute-ranges" />
                <h3>ELText Ranges</h3>
                <xsl:call-template name="table-for-eltext-ranges" />
			</body>
		</html>
	</xsl:template>

	<xsl:template name="write-name" />
	<xsl:template name="table-for-tagerrors">
            <xsl:param name="elementPath"/>
			<table class="tableDefinition" width="100%">
				<tr>
					<td class="tdTableHeading tdColName">
						<xsl:text>Message</xsl:text>
					</td>
                    <td class="tdTableHeading tdColName">
                        <xsl:text>Line</xsl:text>
                    </td>
                    <td class="tdTableHeading tdColName">
                        <xsl:text>Column</xsl:text>
                    </td>
                    <td class="tdTableHeading tdColName">
                        <xsl:text>Start</xsl:text>
                    </td>
                    <td class="tdTableHeading tdColName">
                        <xsl:text>End</xsl:text>
                    </td>
					<!-- <td class="tdTableHeading tdDataType"><xsl:text>Type</xsl:text></td> -->
					<!-- <td class="tdTableHeading tdPkFlag"><xsl:text>PK</xsl:text></td> -->
					<!-- <td class="tdTableHeading tdNullFlag"><xsl:text>Nullable</xsl:text></td> -->
					<!-- <td class="tdTableHeading"><xsl:text>Comment</xsl:text></td> -->
				</tr>
                <xsl:for-each select="/faceletTagReport/tagerror">
                    <tr>
                        <td><xsl:value-of select="localizedMessage"/></td>
                        <td><xsl:value-of select="@row"/></td>
                        <td><xsl:value-of select="@column"/></td>
                        <td><xsl:value-of select="@startOffset"/></td>
                        <td><xsl:value-of select="@endOffset"/></td>
                    </tr>
                </xsl:for-each>
			</table>
	</xsl:template>
    <xsl:template name="table-for-tagincludeerrors">
            <xsl:param name="elementPath"/>
            <table class="tableDefinition" width="100%">
                <tr>
                    <td class="tdTableHeading tdColName">
                        <xsl:text>Column</xsl:text>
                    </td>
                    <td class="tdTableHeading tdDataType"><xsl:text>Type</xsl:text></td>
                    <td class="tdTableHeading tdPkFlag"><xsl:text>PK</xsl:text></td>
                    
                    <!-- <td class="tdTableHeading tdDataType"><xsl:text>Type</xsl:text></td> -->
                    <!-- <td class="tdTableHeading tdPkFlag"><xsl:text>PK</xsl:text></td> -->
                    <!-- <td class="tdTableHeading tdNullFlag"><xsl:text>Nullable</xsl:text></td> -->
                    <!-- <td class="tdTableHeading"><xsl:text>Comment</xsl:text></td> -->
                </tr>
                <xsl:for-each select="/faceletTagReport/tagIncludeErrors">
                    <tr>
                        <td><xsl:value-of select="localizedMessage"/></td>
                        <td><xsl:value-of select="alias"/></td>
                        <td><xsl:value-of select="url"/></td>
                        
                    </tr>
                </xsl:for-each>
            </table>
    </xsl:template>
        <xsl:template name="table-for-inclusions">
            <xsl:param name="requestUrl"/>
            <xsl:param name="serverRelativePath"/>
            <table class="tableDefinition" width="100%">
                <tr>
                    <td class="tdTableHeading tdColName">
                        <xsl:text>Reference From</xsl:text>
                    </td>
                    <td class="tdTableHeading tdDataType"><xsl:text>Reference To</xsl:text></td>
                    <td class="tdTableHeading tdDataType"><xsl:text>Source Relative Path</xsl:text></td>
                    <!-- <td class="tdTableHeading tdNullFlag"><xsl:text>Nullable</xsl:text></td> -->
                    <!-- <td class="tdTableHeading"><xsl:text>Comment</xsl:text></td> -->
                </tr>
                <xsl:for-each select="/faceletTagReport/references/includeReferences">
                    <tr>
                        <td><xsl:value-of select="source"/></td>
                        <td><xsl:value-of select="references/includedDoc"/></td>
						<td>
						<a>
							<xsl:attribute name="href">
							<xsl:value-of select="$requestUrl" />
							<xsl:text>?filename=</xsl:text>
							<xsl:value-of	select="$serverRelativePath" />
                            <xsl:text>/</xsl:text>
							<xsl:value-of select="references/relativePathToIncluded" />
							</xsl:attribute>
							<xsl:value-of select="references/relativePathToIncluded" />
						</a>
						</td>
                        
                    </tr>
                </xsl:for-each>
            </table>
    </xsl:template>
    <xsl:template name="table-for-namespace-ranges">
            <xsl:param name="elementPath"/>
            <table class="tableDefinition" width="100%">
                <tr>
                    <td class="tdTableHeading tdColName">
                        <xsl:text>Uri</xsl:text>
                    </td>
                    <td class="tdTableHeading tdNullFlag"><xsl:text>Start Line</xsl:text></td>
                    <td class="tdTableHeading tdNullFlag"><xsl:text>Start Column</xsl:text></td>
                    <td class="tdTableHeading tdDataType"><xsl:text>Start Offset</xsl:text></td>
                    <td class="tdTableHeading tdNullFlag"><xsl:text>End Line</xsl:text></td>
                    <td class="tdTableHeading tdNullFlag"><xsl:text>End Column</xsl:text></td>
                    <td class="tdTableHeading tdDataType"><xsl:text>End Offset</xsl:text></td>
                </tr>
                <xsl:for-each select="/faceletTagReport/namespaceRanges/namespaceRange">
                    <tr>
                        <td><xsl:value-of select="uri"/></td>
                        <td><xsl:value-of select="ranges/@startLine"/></td>
                        <td><xsl:value-of select="ranges/@startColumn"/></td>
                        <td><xsl:value-of select="ranges/@startOffset"/></td>
                        <td><xsl:value-of select="ranges/@endLine"/></td>
                        <td><xsl:value-of select="ranges/@endColumn"/></td>
                        <td><xsl:value-of select="ranges/@endOffset"/></td>
                    </tr>
                </xsl:for-each>
            </table>
    </xsl:template>
    <xsl:template name="table-for-tag-ranges">
            <xsl:param name="elementPath"/>
            <table class="tableDefinition" width="100%">
                <tr>
                    <td class="tdTableHeading tdColName"><xsl:text>Uri</xsl:text></td>
                    <td class="tdTableHeading tdColName"><xsl:text>Name</xsl:text></td>
                    <td class="tdTableHeading tdNullFlag"><xsl:text>Start Line</xsl:text></td>
                    <td class="tdTableHeading tdNullFlag"><xsl:text>Start Column</xsl:text></td>
                    <td class="tdTableHeading tdDataType"><xsl:text>Start Offset</xsl:text></td>
                    <td class="tdTableHeading tdDataType"><xsl:text>Start Tag End Offset</xsl:text></td>
                    <td class="tdTableHeading tdNullFlag"><xsl:text>End Line</xsl:text></td>
                    <td class="tdTableHeading tdNullFlag"><xsl:text>End Column</xsl:text></td>
                    <td class="tdTableHeading tdDataType"><xsl:text>Close Tag Start Offset</xsl:text></td>
                    <td class="tdTableHeading tdDataType"><xsl:text>End Offset</xsl:text></td>
                    <td class="tdTableHeading tdColName"><xsl:text>Is Ignored?</xsl:text></td>
                </tr>
                <xsl:for-each select="/faceletTagReport/tagRanges/ranges/range">
                    <tr>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="tagIdentifier/uri"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="tagIdentifier/name"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@startLine"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@startColumn"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@startOffset"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@endOffsetOpenTag"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@endLine"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@endColumn"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@startOffsetCloseTag"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@endOffset"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="trimmed"/></td>
                    </tr>
                </xsl:for-each>
            </table>
    </xsl:template>
    <xsl:template name="table-for-attribute-ranges">
            <xsl:param name="elementPath"/>
            <table class="tableDefinition" width="100%">
                <tr>
                    <td class="tdTableHeading tdColName"><xsl:text>Attribute Name</xsl:text></td>
                    <td class="tdTableHeading tdColName"><xsl:text>From Offset</xsl:text></td>
<!--                     <td class="tdTableHeading tdColName"><xsl:text>To Offset</xsl:text></td> -->
                    <td class="tdTableHeading tdColName" width="80%"><xsl:text>EL Offsets</xsl:text></td>
                </tr>
                <xsl:for-each select="/faceletTagReport/tagRanges/ranges/range/attributes/valueRange">
                    <tr>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="../@name"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@startOffset"/></td>
<!--                         <td class="tdTableHeading tdDataType"><xsl:value-of select="@endOffset"/></td> -->
                        <td class="tdTableHeading tdDataType">
                            <xsl:if test="count(../elRange) &gt; 0">
	                            <table>
	                                <tr>
	                                    <td class="tdTableHeading tdColName"><xsl:text>Text</xsl:text></td>
	                                    <td class="tdTableHeading tdColName"><xsl:text>Start Offset</xsl:text></td>
	                                    <td class="tdTableHeading tdColName"><xsl:text>End Offset</xsl:text></td>
                                        <td class="tdTableHeading tdColName"><xsl:text>Sub-expressions</xsl:text></td>
	                                </tr>
	                                <xsl:for-each select="../elRange">
	                                    <tr>
	                                        <td class="tdTableHeading tdDataType"><xsl:value-of select="ELText"/></td>
	                                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@startOffset"/></td>
	                                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@endOffset"/></td>
                                            <td class="tdTableHeading tdDataType">
                                                <xsl:if test="count(modelSubExprs) &gt; 0">
                                                    <table>
					                                    <tr>
					                                        <td class="tdTableHeading tdColName"><xsl:text>Sub-expression</xsl:text></td>
					                                        <td class="tdTableHeading tdColName"><xsl:text>Start Offset</xsl:text></td>
					                                        <td class="tdTableHeading tdColName"><xsl:text>End Offset</xsl:text></td>
					                                        <td class="tdTableHeading tdColName"><xsl:text>Model</xsl:text></td>
                                                            <td class="tdTableHeading tdColName"><xsl:text>Model Start Offset</xsl:text></td>
					                                    </tr>
					                                    <xsl:for-each select="modelSubExprs">
					                                    <tr>
                                                            <td class="tdTableHeading tdColName"><xsl:value-of select="subexpression"/></td>
                                                            <td class="tdTableHeading tdColName"><xsl:value-of select="@startOffset"/></td>
                                                            <td class="tdTableHeading tdColName"><xsl:value-of select="@endOffset"/></td>
                                                            <td class="tdTableHeading tdColName"><xsl:value-of select="modelObjectName/@name"/></td>
                                                            <td class="tdTableHeading tdColName"><xsl:value-of select="modelObjectName/@startOffset"/></td>
                                                        </tr>
					                                    </xsl:for-each>
                                                    </table>
                                                </xsl:if>
                                            </td>

	                                    </tr>
	                                </xsl:for-each>
	                            </table>
	                        </xsl:if>
                        </td>
                    </tr>
                </xsl:for-each>
            </table>
    </xsl:template>

    <xsl:template name="table-for-eltext-ranges">
            <xsl:param name="elementPath"/>
            <table class="tableDefinition" width="100%">
                <tr>
                    <td class="tdTableHeading tdColName"><xsl:text>EL Text</xsl:text></td>
                    <td class="tdTableHeading tdColName"><xsl:text>Start Offset</xsl:text></td>
                    <td class="tdTableHeading tdColName" width="80%"><xsl:text>End Offsets</xsl:text></td>
                </tr>
                <xsl:for-each select="/faceletTagReport/elTextRanges">
                    <tr>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="ELText"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@startOffset"/></td>
                        <td class="tdTableHeading tdDataType"><xsl:value-of select="@endOffset"/></td>
                    </tr>
                </xsl:for-each>
            </table>
    </xsl:template>
</xsl:transform>
