/*******************************************************************************
 * Copyright (c) 2010, 2012 Tasktop Technologies
 * Copyright (c) 2010, 2011 SpringSource, a division of VMware
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Tasktop Technologies - initial API and implementation
 ******************************************************************************/
package com.tasktop.c2c.server.profile.domain.project;

import java.util.ArrayList;
import java.util.List;

import com.tasktop.c2c.server.cloud.domain.ServiceType;
import com.tasktop.c2c.server.common.service.domain.AbstractEntity;

@SuppressWarnings("serial")
public class Project extends AbstractEntity {
	private String identifier;
	private String name;
	private String description;
	private ProjectAccessibility accessibility;
	private ProjectPreferences projectPreferences;
	private List<ProjectService> projectServices;
	private Integer numWatchers;
	private Integer numCommiters;
	private Organization organization;
	private Boolean isTemplate;

	public Project() {
		// Default constructor, does nothing.
	}

	public String getIdentifier() {
		return identifier;
	}

	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public List<ProjectService> getProjectServices() {
		return projectServices;
	}

	public void setProjectServices(List<ProjectService> projectServices) {
		this.projectServices = projectServices;
	}

	public List<ProjectService> getProjectServicesOfType(ServiceType type) {
		List<ProjectService> results = new ArrayList<ProjectService>();

		for (ProjectService service : projectServices) {
			if (service.getServiceType().equals(type)) {
				results.add(service);
			}
		}
		return results;
	}

	/**
	 * @return the numWatchers
	 */
	public Integer getNumWatchers() {
		return numWatchers;
	}

	/**
	 * @param numWatchers
	 *            the numWatchers to set
	 */
	public void setNumWatchers(Integer numWatchers) {
		this.numWatchers = numWatchers;
	}

	/**
	 * @return the numCommiters
	 */
	public Integer getNumCommiters() {
		return numCommiters;
	}

	/**
	 * @param numCommiters
	 *            the numCommiters to set
	 */
	public void setNumCommiters(Integer numCommiters) {
		this.numCommiters = numCommiters;
	}

	public Organization getOrganization() {
		return organization;
	}

	public void setOrganization(Organization organization) {
		this.organization = organization;
	}

	public ProjectAccessibility getAccessibility() {
		return accessibility;
	}

	public void setAccessibility(ProjectAccessibility accessibility) {
		this.accessibility = accessibility;
	}

	/**
	 * @return the projectPreferences
	 */
	public ProjectPreferences getProjectPreferences() {
		return projectPreferences;
	}

	/**
	 * @param projectPreferences
	 *            the projectPreferences to set
	 */
	public void setProjectPreferences(ProjectPreferences projectPreferences) {
		this.projectPreferences = projectPreferences;
	}

	public Boolean isTemplate() {
		return isTemplate;
	}

	public void setTemplate(Boolean isTemplate) {
		this.isTemplate = isTemplate;
	}

}
