/*******************************************************************************
 * Copyright (c) 2010, 2012 Tasktop Technologies
 * Copyright (c) 2010, 2011 SpringSource, a division of VMware
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Tasktop Technologies - initial API and implementation
 ******************************************************************************/
package com.tasktop.c2c.server.profile.domain.build;

import java.io.Serializable;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@SuppressWarnings("serial")
@JsonIgnoreProperties(ignoreUnknown = true)
public class JobSummary implements Serializable {

	private String name;
	private String url;
	private String color;

	private List<BuildDetails> builds;

	private BuildDetails lastBuild;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getColor() {
		return color;
	}

	public void setColor(String color) {
		this.color = color;
	}

	public List<BuildDetails> getBuilds() {
		return builds;
	}

	public void setBuilds(List<BuildDetails> builds) {
		this.builds = builds;
	}

	/**
	 * @return the lastBuild
	 */
	public BuildDetails getLastBuild() {
		return lastBuild;
	}

	/**
	 * @param lastBuild
	 *            the lastBuild to set
	 */
	public void setLastBuild(BuildDetails lastBuild) {
		this.lastBuild = lastBuild;
	}

}
