create or replace
      trigger currencies_trigger
      before update on currencies
      for each row
      declare
         PRAGMA AUTONOMOUS_TRANSACTION;
         l_cnt number;
      begin
         select count(*)
           into l_cnt
           from currencies
          where primary_currency='Y'
             and country = :new.country;
         if ( l_cnt > 1 )
         then
             raise_application_error
             (-20000, 'only one allowed');
         end if;
     end;

