/*******************************************************************************
 * Copyright (c) 2010, 2012 Tasktop Technologies
 * Copyright (c) 2010, 2011 SpringSource, a division of VMware
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Tasktop Technologies - initial API and implementation
 ******************************************************************************/
package com.tasktop.c2c.server.common.service;

/**
 * Simple container class for the profile configuration. Mainly about where services are publicly exposed.
 * 
 * @author cmorgan (Tasktop Technologies Inc.)
 * 
 */
public abstract class BaseProfileConfiguration {

	public static final String PROJECTS_WEB_PATH = "#projects";

	private String profileApplicationProtocol;
	private String webHost;
	private String serviceProxyPath;
	private String baseContextPath;
	private boolean prefixHostnameWithOrgId = false;
	private boolean prefixPathWithOrgId = false;

	public String getProfileApplicationProtocol() {
		return profileApplicationProtocol;
	}

	public void setProfileApplicationProtocol(String profileApplicationProtocol) {
		this.profileApplicationProtocol = profileApplicationProtocol;
	}

	public String getBaseWebHost() {
		return webHost;
	}

	public String getWebHost() {
		return getOrganizationHostPrefix() + webHost;
	}

	public void setWebHost(String webHost) {
		this.webHost = webHost;
	}

	public String getServiceProxyPath() {
		return serviceProxyPath;
	}

	public void setServiceProxyPath(String serviceProxyPath) {
		this.serviceProxyPath = prefixPathIfMissing(serviceProxyPath);
	}

	public String getBaseContextPath() {
		return baseContextPath;
	}

	public void setBaseContextPath(String baseContextPath) {
		this.baseContextPath = prefixPathIfMissing(baseContextPath);
	}

	public String getProfileBaseUrl() {
		String baseUrl = getProfileApplicationProtocol() + "://";
		baseUrl += getWebHost() + getBaseContextPath();

		if (prefixPathWithOrgId && getCurrentTenantOrganizationIdentifer() != null) {
			baseUrl += "/" + getCurrentTenantOrganizationIdentifer();
		}

		return baseUrl;
	}

	public String getTenantUrl() {
		String tenantUrl = getProfileBaseUrl();
		return tenantUrl.endsWith("/") ? tenantUrl : tenantUrl + "/";
	}

	private String getOrganizationHostPrefix() {
		String orgHostPrefix = "";
		if (prefixHostnameWithOrgId && getCurrentTenantOrganizationIdentifer() != null) {
			orgHostPrefix += getCurrentTenantOrganizationIdentifer() + ".";
		}
		return orgHostPrefix;
	}

	public String getUpdateSiteUrl() {
		return profileApplicationProtocol + "://" + webHost + "/updateSite";
	}

	public String getServiceUrlPrefix(String projectIdentifier) {
		return getProfileBaseUrl() + getServiceProxyUrlPath(projectIdentifier);
	}

	public String getHostedScmUrlPrefix(String projectId) {
		return getProfileBaseUrl() + getHostedScmUrlPath(projectId);
	}

	public String getHostedScmUrlPath(String projectId) {
		return getServiceProxyUrlPath(projectId) + "scm/";
	}

	public String getServiceProxyUrlPath(String projectIdentifier) {
		return getServiceProxyPath() + "/" + projectIdentifier + "/";
	}

	public boolean isPrefixHostnameWithOrgId() {
		return prefixHostnameWithOrgId;
	}

	public void setPrefixHostnameWithOrgId(boolean prefixHostnameWithOrgId) {
		this.prefixHostnameWithOrgId = prefixHostnameWithOrgId;
	}

	private String prefixPathIfMissing(String path) {
		if (!path.startsWith("/") && !path.isEmpty()) {
			path = "/" + path;
		}
		return path;
	}

	public boolean isPrefixPathWithOrgId() {
		return prefixPathWithOrgId;
	}

	public void setPrefixPathWithOrgId(boolean prefixPathWithOrgId) {
		this.prefixPathWithOrgId = prefixPathWithOrgId;
	}

	/**
	 * @return
	 */
	public abstract String getCurrentTenantOrganizationIdentifer();

}
