/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.scopeanalysis;

import com.python.pydev.analysis.messages.AbstractMessage;
import com.python.pydev.analysis.scopeanalysis.AbstractScopeAnalyzerVisitor;
import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.GenAndTok;
import com.python.pydev.analysis.visitors.ScopeItems;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;
import org.python.pydev.shared_core.structure.Tuple4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeAnalyzerVisitorWithoutImports
extends AbstractScopeAnalyzerVisitor {
    public static final String FOUND_ADDITIONAL_INFO_IN_AST_ENTRY = "FOUND_ADDITIONAL_INFO_IN_AST_ENTRY";
    protected String completeNameToFind = "";
    protected String nameToFind = "";
    private List<Tuple3<Found, Integer, ASTEntry>> foundOccurrences = new ArrayList<Tuple3<Found, Integer, ASTEntry>>();
    private FastStack<ASTEntry> parents;
    private List<Found> undefinedFound = new ArrayList<Found>();
    private Found hitAsUndefined = null;
    private boolean finished = false;
    private int currLine;
    private int currCol;

    public ScopeAnalyzerVisitorWithoutImports(IPythonNature nature, String moduleName, IModule current, IProgressMonitor monitor, PySelection ps) throws BadLocationException {
        this(nature, moduleName, current, ps.getDoc(), monitor, (String)ps.getCurrToken().o1, ps.getAbsoluteCursorOffset(), ps.getActivationTokenAndQual(true));
    }

    protected ScopeAnalyzerVisitorWithoutImports(IPythonNature nature, String moduleName, IModule current, IDocument document, IProgressMonitor monitor, String pNameToFind, int absoluteCursorOffset, String[] tokenAndQual) throws BadLocationException {
        super(nature, moduleName, current, document, monitor);
        if (document != null) {
            IRegion region = document.getLineInformationOfOffset(absoluteCursorOffset);
            this.currLine = document.getLineOfOffset(absoluteCursorOffset);
            this.currCol = absoluteCursorOffset - region.getOffset();
        }
        this.nameToFind = pNameToFind;
        this.completeNameToFind = String.valueOf(tokenAndQual[0]) + tokenAndQual[1];
    }

    @Override
    protected void onLastScope(ScopeItems m) {
        for (Found found : this.probablyNotDefined) {
            ASTEntry parent;
            if (this.checkFound(found, parent = this.peekParent()) == null) {
                String rep = found.getSingle().generator.getRepresentation();
                if (!FullRepIterable.containsPart((String)rep, (String)this.nameToFind)) continue;
                this.undefinedFound.add(found);
                continue;
            }
            this.hitAsUndefined = found;
        }
    }

    @Override
    public void onAddUnusedMessage(SimpleNode node, Found found) {
    }

    @Override
    public void onAddReimportMessage(Found newFound) {
    }

    @Override
    public void onAddUnresolvedImport(IToken token) {
    }

    @Override
    protected void onAfterAddToNamesToIgnore(ScopeItems currScopeItems, Tuple<IToken, Found> tup) {
        if (tup.o1 instanceof SourceToken) {
            this.checkFound((Found)tup.o2, this.peekParent());
        }
    }

    @Override
    protected Tuple<IToken, Found> findInNamesToIgnore(String rep, IToken token) {
        Tuple<IToken, Found> found = this.scope.findInNamesToIgnore(rep);
        if (found != null) {
            ((Found)found.o2).getSingle().references.add(token);
            this.checkToken((Found)found.o2, token, this.peekParent());
        }
        return found;
    }

    @Override
    protected void onFoundUnresolvedImportPart(IToken token, String rep, Found foundAs) {
        this.onAddUndefinedMessage(token, foundAs);
    }

    @Override
    protected void onAddUndefinedVarInImportMessage(IToken token, Found foundAs) {
        this.onAddUndefinedMessage(token, foundAs);
    }

    @Override
    protected void onAddAssignmentToBuiltinMessage(IToken token, String representation) {
    }

    @Override
    protected void onAddToProbablyNotDefined(IToken token, Found foundForProbablyNotDefined) {
        super.onAddToProbablyNotDefined(token, foundForProbablyNotDefined);
        this.onAddUndefinedMessage(token, foundForProbablyNotDefined);
    }

    @Override
    protected void onNotDefinedFoundLater(Found foundInProbablyNotDefined, Found laterFound) {
        super.onNotDefinedFoundLater(foundInProbablyNotDefined, laterFound);
        if (this.hitAsUndefined == foundInProbablyNotDefined) {
            this.hitAsUndefined = null;
        }
        Tuple3 tup = new Tuple3((Object)laterFound, (Object)-1, (Object)this.peekParent());
        laterFound.addGeneratorsFromFound(foundInProbablyNotDefined);
        this.addFoundOccurrence((Tuple3<Found, Integer, ASTEntry>)tup);
    }

    @Override
    protected void onAddUndefinedMessage(IToken token, Found found) {
        ASTEntry parent = this.peekParent();
        if (this.checkFound(found, parent) == null) {
            if (token.getRepresentation().equals(this.nameToFind)) {
                this.undefinedFound.add(found);
            }
        } else {
            this.hitAsUndefined = found;
        }
    }

    protected ASTEntry popParent(SimpleNode node) {
        return (ASTEntry)this.parents.pop();
    }

    protected ASTEntry peekParent() {
        ASTEntry parent = null;
        if (this.parents.size() > 0) {
            parent = (ASTEntry)this.parents.peek();
        }
        return parent;
    }

    @Override
    protected void onAfterStartScope(int newScopeType, SimpleNode node) {
        if (this.parents == null) {
            this.parents = new FastStack(10);
        }
        if (this.parents.size() == 0) {
            this.parents.push((Object)new ASTEntry(null, node));
        } else {
            this.parents.push((Object)new ASTEntry((ASTEntry)this.parents.peek(), node));
        }
    }

    @Override
    protected void onBeforeEndScope(SimpleNode node) {
    }

    @Override
    protected void onAfterVisitAssign(Assign node) {
    }

    protected void checkFinished() {
        if (!this.finished) {
            this.finished = true;
            this.endScope(null);
        }
    }

    @Override
    protected void onAfterEndScope(SimpleNode node, ScopeItems m) {
        block4: {
            block3: {
                ASTEntry parent = this.popParent(node);
                if (this.hitAsUndefined != null) break block3;
                for (String rep : new FullRepIterable(this.completeNameToFind, true)) {
                    List<Found> foundItems = m.getAll(rep);
                    for (Found found : foundItems) {
                        if (this.checkFound(found, parent) == null) continue;
                        return;
                    }
                }
                break block4;
            }
            String foundRep = this.hitAsUndefined.getSingle().generator.getRepresentation();
            if (foundRep.indexOf(46) != -1 && !FullRepIterable.containsPart((String)foundRep, (String)this.nameToFind)) break block4;
            for (Found f : this.undefinedFound) {
                if (!f.getSingle().generator.getRepresentation().startsWith(foundRep) || this.foundOccurrences.size() != 1) continue;
                Tuple3<Found, Integer, ASTEntry> hit = this.foundOccurrences.get(0);
                Tuple3 foundOccurrence = new Tuple3((Object)f, (Object)((Integer)hit.o2), (Object)((ASTEntry)hit.o3));
                this.addFoundOccurrence((Tuple3<Found, Integer, ASTEntry>)foundOccurrence);
            }
        }
    }

    protected Found checkFound(Found found, ASTEntry parent) {
        if (found == null) {
            return null;
        }
        List<GenAndTok> all = found.getAll();
        try {
            for (GenAndTok gen : all) {
                for (IToken tok2 : gen.getAllTokens()) {
                    if (!this.checkToken(found, tok2, parent)) continue;
                    return found;
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    protected boolean checkToken(Found found, IToken generator, ASTEntry parent) {
        int startLine = AbstractMessage.getStartLine(generator, this.document) - 1;
        int endLine = AbstractMessage.getEndLine(generator, this.document, false) - 1;
        String rep = generator.getRepresentation();
        int startCol = AbstractMessage.getStartCol(generator, this.document, rep, true) - 1;
        int endCol = AbstractMessage.getEndCol(generator, this.document, rep, false) - 1;
        if (this.currLine >= startLine && this.currLine <= endLine && this.currCol >= startCol && this.currCol <= endCol) {
            int colDelta = 0;
            if (this.currLine == startLine || this.currLine == endLine) {
                colDelta = this.currCol - startCol;
            }
            Tuple3 foundOccurrence = new Tuple3((Object)found, (Object)colDelta, (Object)parent);
            this.addFoundOccurrence((Tuple3<Found, Integer, ASTEntry>)foundOccurrence);
            return true;
        }
        return false;
    }

    private void addFoundOccurrence(Tuple3<Found, Integer, ASTEntry> foundOccurrence) {
        this.foundOccurrences.add(foundOccurrence);
    }

    public List<IToken> getTokenOccurrences() {
        ArrayList<IToken> ret = new ArrayList<IToken>();
        List<ASTEntry> entryOccurrences = this.getEntryOccurrences();
        for (ASTEntry entry : entryOccurrences) {
            ret.add((IToken)AbstractVisitor.makeToken((SimpleNode)entry.node, (String)this.moduleName));
        }
        return ret;
    }

    public List<ASTEntry> getEntryOccurrences() {
        this.checkFinished();
        HashSet<Tuple3> s = new HashSet<Tuple3>();
        ArrayList<Tuple4<IToken, Integer, ASTEntry, Found>> complete = this.getCompleteTokenOccurrences();
        ArrayList<ASTEntry> ret = new ArrayList<ASTEntry>();
        for (Tuple4<IToken, Integer, ASTEntry, Found> tup : complete) {
            ImportFrom f;
            IToken token = (IToken)tup.o1;
            if (!(token instanceof SourceToken)) continue;
            SourceToken sourceToken = (SourceToken)tup.o1;
            SimpleNode ast = sourceToken.getAst();
            String representation = null;
            if (ast instanceof ImportFrom) {
                f = (ImportFrom)ast;
                aliasType[] aliasTypeArray = f.names;
                int n = f.names.length;
                int n2 = 0;
                while (n2 < n) {
                    aliasType t = aliasTypeArray[n2];
                    NameTok importName = NodeUtils.getNameForAlias((aliasType)t);
                    String importRep = NodeUtils.getFullRepresentationString((SimpleNode)importName);
                    if (importRep.equals(this.nameToFind)) {
                        ast = importName;
                        representation = importRep;
                        break;
                    }
                    ++n2;
                }
            } else if (ast instanceof Import) {
                representation = NodeUtils.getFullRepresentationString((SimpleNode)ast);
                f = (Import)ast;
                NameTok importName = NodeUtils.getNameForRep((aliasType[])f.names, (String)representation);
                if (importName != null) {
                    ast = importName;
                }
            } else {
                representation = NodeUtils.getFullRepresentationString((SimpleNode)ast);
            }
            if (representation == null) continue;
            if (this.nameToFind.equals(representation)) {
                ASTEntry entry;
                if (ast instanceof Attribute) {
                    ast = (SimpleNode)NodeUtils.getAttributeParts((Attribute)((Attribute)ast)).get(0);
                    entry = new ASTEntry((ASTEntry)tup.o3, ast);
                    entry.setAdditionalInfo(FOUND_ADDITIONAL_INFO_IN_AST_ENTRY, tup.o4);
                    ret.add(entry);
                    continue;
                }
                entry = new ASTEntry((ASTEntry)tup.o3, ast);
                entry.setAdditionalInfo(FOUND_ADDITIONAL_INFO_IN_AST_ENTRY, tup.o4);
                ret.add(entry);
                continue;
            }
            if (!FullRepIterable.containsPart((String)representation, (String)this.nameToFind)) continue;
            Name nameAst = new Name(this.nameToFind, 2, false);
            List strings = StringUtils.dotSplit((String)representation);
            int plus = 0;
            for (String string : strings) {
                if (string.equals(this.nameToFind) && plus + this.nameToFind.length() >= (Integer)tup.o2) break;
                plus += string.length() + 1;
            }
            nameAst.beginColumn = AbstractMessage.getStartCol(token, this.document) + plus;
            nameAst.beginLine = AbstractMessage.getStartLine(token, this.document);
            Tuple3 t = new Tuple3((Object)this.nameToFind, (Object)nameAst.beginColumn, (Object)nameAst.beginLine);
            if (s.contains(t)) continue;
            s.add(t);
            ASTEntry entry = new ASTEntry((ASTEntry)tup.o3, (SimpleNode)nameAst);
            entry.setAdditionalInfo(FOUND_ADDITIONAL_INFO_IN_AST_ENTRY, tup.o4);
            ret.add(entry);
        }
        return ret;
    }

    protected ArrayList<Tuple4<IToken, Integer, ASTEntry, Found>> getCompleteTokenOccurrences() {
        HashSet<IToken> f = new HashSet<IToken>();
        ArrayList<Tuple4<IToken, Integer, ASTEntry, Found>> ret = new ArrayList<Tuple4<IToken, Integer, ASTEntry, Found>>();
        for (Tuple3<Found, Integer, ASTEntry> found : this.foundOccurrences) {
            List<GenAndTok> all = ((Found)found.o1).getAll();
            for (GenAndTok tok : all) {
                Tuple4 tup4 = new Tuple4((Object)tok.generator, found.o2, found.o3, found.o1);
                if (!f.contains(tok.generator)) {
                    f.add(tok.generator);
                    ret.add((Tuple4<IToken, Integer, ASTEntry, Found>)tup4);
                }
                for (IToken t : tok.references) {
                    tup4 = new Tuple4((Object)t, found.o2, found.o3, found.o1);
                    if (f.contains(t)) continue;
                    f.add(t);
                    ret.add((Tuple4<IToken, Integer, ASTEntry, Found>)tup4);
                }
            }
            this.onGetCompleteTokenOccurrences(found, f, ret);
        }
        return ret;
    }

    protected void onGetCompleteTokenOccurrences(Tuple3<Found, Integer, ASTEntry> found, Set<IToken> f, ArrayList<Tuple4<IToken, Integer, ASTEntry, Found>> ret) {
    }
}

