/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.util.UIUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.editor.IPyEditListener;
import org.python.pydev.utils.PyFileListing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditionalInfoIntegrityChecker
implements IPyEditListener {
    public static IntegrityInfo checkIntegrity(IPythonNature nature, IProgressMonitor monitor, boolean fix) throws MisconfigurationException {
        IntegrityInfo info = new IntegrityInfo();
        StringBuffer buffer = info.desc;
        info.nature = nature;
        info.modulesManager = nature.getAstManager().getModulesManager();
        info.additionalProjectInfo = (AdditionalProjectInterpreterInfo)AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature);
        if (info.additionalProjectInfo == null) {
            buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"Unable to get additional project info for: %s (gotten null)", (Object[])new Object[]{nature.getProject()}));
            info.allOk = false;
        }
        PythonPathHelper pythonPathHelper = (PythonPathHelper)info.modulesManager.getPythonPathHelper();
        List pythonpath = pythonPathHelper.getPythonpath();
        buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"Checking the integrity of the project: %s\n\n", (Object[])new Object[]{nature.getProject().getName()}));
        buffer.append("Pythonpath:\n");
        for (String string : pythonpath) {
            buffer.append(string);
            buffer.append("\n");
        }
        buffer.append("\n");
        HashSet<ModulesKey> expectedModuleNames = new HashSet<ModulesKey>();
        for (String string : pythonpath) {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                Collection modulesBelow = PythonPathHelper.getModulesBelow((File)file, (IProgressMonitor)monitor).getFoundPyFileInfos();
                for (PyFileListing.PyFileInfo fileInfo : modulesBelow) {
                    File moduleFile = fileInfo.getFile();
                    String modName = pythonPathHelper.resolveModule(FileUtils.getFileAbsolutePath((File)moduleFile), true);
                    if (modName != null) {
                        expectedModuleNames.add(new ModulesKey(modName, moduleFile));
                        buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"Found module: %s - %s\n", (Object[])new Object[]{modName, moduleFile}));
                        continue;
                    }
                    if (!PythonPathHelper.isValidModuleLastPart((String)StringUtils.stripExtension((String)moduleFile.getName()))) continue;
                    info.allOk = false;
                    buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"Unable to resolve module: %s (gotten null module name)\n", (Object[])new Object[]{moduleFile}));
                }
                continue;
            }
            info.allOk = false;
            buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"File %s is referenced in the pythonpath but does not exist.", (Object[])new Object[]{file}));
        }
        AdditionalInfoIntegrityChecker.check(expectedModuleNames, info, fix);
        return info;
    }

    private static void check(HashSet<ModulesKey> expectedModuleNames, IntegrityInfo info, boolean fix) throws MisconfigurationException {
        StringBuffer buffer = info.desc;
        ModulesKey[] onlyDirectModules = info.modulesManager.getOnlyDirectModules();
        TreeSet<ModulesKey> inModulesManager = new TreeSet<ModulesKey>(Arrays.asList(onlyDirectModules));
        Set<String> allAdditionalInfoTrackedModules = info.additionalProjectInfo.getAllModulesWithTokens();
        for (ModulesKey key : inModulesManager) {
            if (expectedModuleNames.contains(key)) continue;
            info.allOk = false;
            info.modulesNotInDisk.add(key);
            buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"ModulesKey %s exists in memory but not in the disk.\n", (Object[])new Object[]{key}));
        }
        for (String s : allAdditionalInfoTrackedModules) {
            if (expectedModuleNames.contains(new ModulesKey(s, null))) continue;
            info.allOk = false;
            info.additionalModulesNotInDisk.add(s);
            buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"The module %s exists in the additional info memory but not in the disk.\n", (Object[])new Object[]{s}));
        }
        for (ModulesKey key : expectedModuleNames) {
            if (!inModulesManager.contains(key)) {
                info.allOk = false;
                info.modulesNotInMemory.add(key);
                buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"ModulesKey %s exists in the disk but not in memory.\n", (Object[])new Object[]{key}));
            }
            if (allAdditionalInfoTrackedModules.contains(key.name)) continue;
            try {
                AbstractModule mod = AbstractModule.createModule((String)key.name, (File)key.file, (IPythonNature)info.nature, (boolean)true);
                if (!(mod instanceof SourceModule)) continue;
                SourceModule module = (SourceModule)mod;
                if (module == null || module.getAst() == null) {
                    buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"Warning: cannot parse: %s - %s (so, it's ok not having additional info on it)\n", (Object[])new Object[]{key.name, key.file}));
                    continue;
                }
                try {
                    Iterator innerEntriesForAST = (Iterator)AbstractAdditionalDependencyInfo.getInnerEntriesForAST((SimpleNode)module.getAst()).o2;
                    if (!innerEntriesForAST.hasNext()) continue;
                    info.allOk = false;
                    info.moduleNotInAdditionalInfo.add(module);
                    buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"The additional info index of the module: %s is not updated.\n", (Object[])new Object[]{key.name}));
                }
                catch (Exception e) {
                    buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"Unexpected error happened on: %s - %s: %s\n", (Object[])new Object[]{key.name, key.file, e.getMessage()}));
                }
            }
            catch (IOException iOException) {
                buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"Warning: cannot parse: %s - %s (so, it's ok not having additional info on it)\n", (Object[])new Object[]{key.name, key.file}));
            }
        }
        if (info.allOk) {
            buffer.append("All checks OK!\n");
        } else if (fix) {
            buffer.append("Fixing:\n");
            buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"Removing modules from memory: %s\n", (Object[])new Object[]{info.modulesNotInDisk}));
            info.modulesManager.removeModules(info.modulesNotInDisk);
            buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"Adding to memory modules: %s\n", (Object[])new Object[]{info.modulesNotInMemory}));
            for (ModulesKey key : info.modulesNotInMemory) {
                buffer.append("Adding modules ...\n");
                info.modulesManager.addModule(key);
            }
            buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"Removing from additional info: %s\n", (Object[])new Object[]{info.additionalModulesNotInDisk}));
            for (String s : info.additionalModulesNotInDisk) {
                info.additionalProjectInfo.removeInfoFromModule(s, true);
            }
            buffer.append(org.python.pydev.shared_core.string.StringUtils.format((String)"Adding to additional info modules found in disk: %s\n", (Object[])new Object[]{info.moduleNotInAdditionalInfo}));
            for (SourceModule mod : info.moduleNotInAdditionalInfo) {
                info.additionalProjectInfo.addAstInfo(mod.getAst(), mod.getModulesKey(), true);
            }
        }
    }

    public void onCreateActions(ListResourceBundle resources, BaseEditor baseEditor, IProgressMonitor monitor) {
        PyEdit edit = (PyEdit)baseEditor;
        edit.addOfflineActionListener("--internal-test-modules", (IAction)new Action(){

            public void run() {
                List allPythonNatures = PythonNature.getAllPythonNatures();
                StringBuffer buf = new StringBuffer();
                try {
                    for (IPythonNature nature : allPythonNatures) {
                        buf.append(AdditionalInfoIntegrityChecker.checkIntegrity(nature, (IProgressMonitor)new NullProgressMonitor(), true));
                    }
                }
                catch (MisconfigurationException e) {
                    buf.append(e.getMessage());
                }
                UIUtils.showString((String)buf.toString());
            }
        }, "Used just for testing (do not use).", true);
    }

    public void onDispose(BaseEditor edit, IProgressMonitor monitor) {
    }

    public void onSave(BaseEditor edit, IProgressMonitor monitor) {
    }

    public void onSetDocument(IDocument document, BaseEditor edit, IProgressMonitor monitor) {
    }

    public static class IntegrityInfo {
        public boolean allOk = true;
        public StringBuffer desc = new StringBuffer();
        public IPythonNature nature;
        public IModulesManager modulesManager;
        public List<ModulesKey> modulesNotInDisk = new ArrayList<ModulesKey>();
        public List<ModulesKey> modulesNotInMemory = new ArrayList<ModulesKey>();
        public AdditionalProjectInterpreterInfo additionalProjectInfo;
        public List<SourceModule> moduleNotInAdditionalInfo = new ArrayList<SourceModule>();
        public List<String> additionalModulesNotInDisk = new ArrayList<String>();

        public String toString() {
            return this.desc.toString();
        }
    }
}

