/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class ProjectUtils {
    public static List<IProject> getWebProjects(IProject project) {
        ArrayList<IProject> webProjects = new ArrayList<IProject>();
        IProject earProject = WtpProjectUtil.findReferencingEarProject((IProject)project);
        Set projects = null;
        if (earProject != null) {
            projects = WtpProjectUtil.findProjectsReferencedByEar((IProject)earProject);
            for (IProject proj : projects) {
                if (!WtpProjectUtil.isDynamicWebProject((IProject)proj) || webProjects.contains(proj)) continue;
                webProjects.add(proj);
            }
        }
        if (WtpProjectUtil.isDynamicWebProject((IProject)project) && !webProjects.contains(project)) {
            webProjects.add(project);
        }
        return webProjects;
    }

    public static boolean isWebProject(IProject project) {
        return WtpProjectUtil.isDynamicWebProject((IProject)project);
    }

    public static List<IProject> getADFWebProjects(IProject project) {
        ArrayList<IProject> webProjects = new ArrayList<IProject>();
        IProject earProject = WtpProjectUtil.findReferencingEarProject((IProject)project);
        Set projects = null;
        if (earProject != null) {
            projects = WtpProjectUtil.findProjectsReferencedByEar((IProject)earProject);
            for (IProject proj : projects) {
                if (!ProjectUtils.isADFWebProject(proj) || webProjects.contains(proj)) continue;
                webProjects.add(proj);
            }
        }
        if (ProjectUtils.isADFWebProject(project) && !webProjects.contains(project)) {
            webProjects.add(project);
        }
        return webProjects;
    }

    public static boolean isADFWebProject(IProject project) {
        Project proj = (Project)project.getAdapter(Project.class);
        if (proj != null) {
            ITechnologyExtension techExt = proj.getTechnologyExtensionById("adf.web");
            return techExt != null;
        }
        return false;
    }

    public static IContainer getWebContentContainer(IProject project) {
        IVirtualFolder rootFolder;
        IVirtualComponent component;
        if (project != null && (component = ComponentCore.createComponent((IProject)project)) != null && (rootFolder = component.getRootFolder()) != null) {
            return rootFolder.getUnderlyingFolder();
        }
        return null;
    }

    public static IPath computeWebContentRelativePath(IResource resource) {
        if (resource != null) {
            IContainer webContentContainer = ProjectUtils.getWebContentContainer(resource.getProject());
            return ProjectUtils.desanitizePath(webContentContainer != null ? resource.getFullPath().makeRelativeTo(webContentContainer.getFullPath()) : resource.getFullPath());
        }
        return null;
    }

    private static IPath desanitizePath(IPath path) {
        return path.toString().charAt(0) == '/' ? path : new Path("/").append(path);
    }

    public static IResource computeWebContentResource(IProject project, IPath relativePath) {
        IContainer webContentContainer;
        if (project != null && relativePath != null && !relativePath.isAbsolute() && (webContentContainer = ProjectUtils.getWebContentContainer(project)) != null) {
            return webContentContainer.findMember(relativePath);
        }
        return null;
    }
}

