/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;

public final class AdfExpressionPrefixUtil {
    public static final AdfExpressionPrefixUtil INSTANCE = new AdfExpressionPrefixUtil();
    private static final String EMPTY_PREFIX = "";
    private static final String BACK_BEAN_SCOPE_PREFIX = "backingBeanScope.";
    private static final String PAGE_FLOW_SCOPE_PREFIX = "pageFlowScope.";
    private static final String VIEW_SCOPE_PREFIX = "viewScope.";
    private static final Map<Variable.SCOPE, String> ADF_PREFIX_MAP;

    static {
        HashMap<Variable.SCOPE, String> adfPrefixMap = new HashMap<Variable.SCOPE, String>();
        adfPrefixMap.put(Variable.SCOPE.ADF_BACKING_BEAN_SCOPE, BACK_BEAN_SCOPE_PREFIX);
        adfPrefixMap.put(Variable.SCOPE.ADF_PAGE_SCOPE, PAGE_FLOW_SCOPE_PREFIX);
        adfPrefixMap.put(Variable.SCOPE.ADF_VIEW_SCOPE, VIEW_SCOPE_PREFIX);
        ADF_PREFIX_MAP = Collections.unmodifiableMap(adfPrefixMap);
    }

    private AdfExpressionPrefixUtil() {
    }

    public String getAdfExpressionPrefix(ValueReference valueRef) {
        Variable var = valueRef.getVariable();
        if (var == null) {
            return EMPTY_PREFIX;
        }
        Variable.SCOPE scope = var.getScope();
        String prefix = ADF_PREFIX_MAP.get(scope);
        return prefix == null ? EMPTY_PREFIX : prefix;
    }

    public String getAdfExpressionPrefix(MethodReference methodRef) {
        ValueReference valueRef = methodRef.getValueReference();
        if (valueRef == null) {
            return EMPTY_PREFIX;
        }
        return this.getAdfExpressionPrefix(valueRef);
    }
}

