/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.eclipse.tools.common.util.fileio.ZipUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class ADFGlassfishUtil {
    public static final String GLASSFISH_RUNTIME_TYPE_ID = "org.glassfish.jst.server.runtime.glassfish";
    public static final String GLASSFISH_RUNTIME_COMP_ID = "glassfish";
    public static final String GLASSFISH_WEB_FACET = "glassfish.web";
    public static final String GLASSFISH_ADF_RT_COMPONENT_ID = "oracle.glassfish.adf";
    public static final String[] GLASSFISH_RUNTIME_TYPE_IDS = new String[]{"org.glassfish.jst.server.runtime.glassfish4", "org.glassfish.jst.server.runtime.glassfish31"};
    public static final String GLASSFISH_JSF_LIB_ID = "glassfish-system-library-provider-jsf";
    private static final String ORACLE_VERSION = "Oracle-Version";

    public static File getDomainPath(IServer server) {
        Map map = server.getAttribute("generic_server_instance_properties", new HashMap());
        File domainPath = new File((String)map.get("sunappserver.domainpath"));
        return domainPath;
    }

    public static String getAdmin(IServer server) {
        Map map = server.getAttribute("generic_server_instance_properties", new HashMap());
        return (String)map.get("sunappserver.adminname");
    }

    public static String getAdminPort(IServer server) {
        Map map = server.getAttribute("generic_server_instance_properties", new HashMap());
        return (String)map.get("sunappserver.adminserverportnumber");
    }

    public static String getPassword(IServer server) {
        Map map = server.getAttribute("generic_server_instance_properties", new HashMap());
        return (String)map.get("sunappserver.adminpassword");
    }

    public static String getInstalledADFVersion(IServer server) {
        File domainPath = ADFGlassfishUtil.getDomainPath(server);
        if (domainPath.exists()) {
            return ADFGlassfishUtil.getInstalledADFVersion(domainPath);
        }
        return null;
    }

    public static String getInstalledADFVersion(File domainPath) {
        File adfJar = new File(domainPath + "/lib/adf-share-security.jar");
        if (adfJar.exists()) {
            String jarVersion = ADFGlassfishUtil.getOracleVersion(adfJar);
            return jarVersion;
        }
        return null;
    }

    public static String getOracleVersion(File location) {
        try {
            return ADFGlassfishUtil.getVersion(location, ORACLE_VERSION);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String getMajorAndMinorVersion(String adfVersion) {
        StringTokenizer tokenizer = new StringTokenizer(adfVersion.trim(), ".", false);
        String majorMinotVer = String.valueOf(tokenizer.nextToken()) + "." + tokenizer.nextToken();
        return majorMinotVer;
    }

    public static String getVersion(File location, String token) throws IOException {
        block16: {
            ZipFile zip = ZipUtil.open((File)location);
            try {
                String string;
                ZipEntry zipentry = ZipUtil.getZipEntry((ZipFile)zip, (String)"META-INF/MANIFEST.MF");
                if (zipentry == null) break block16;
                InputStream in = zip.getInputStream(zipentry);
                try {
                    string = ADFGlassfishUtil.getVersion(in, token);
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return string;
            }
            finally {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static String getVersion(InputStream stream, String token) {
        Scanner scanner = new Scanner(stream);
        String coherenceVersion = null;
        boolean isCoherence = false;
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                StringTokenizer tokenizer = new StringTokenizer(line, ":", false);
                String key = null;
                if (!tokenizer.hasMoreTokens() || !token.equals(key = tokenizer.nextToken())) continue;
                String string = tokenizer.nextToken().trim();
                return string;
            }
        }
        finally {
            scanner.close();
        }
        return isCoherence ? coherenceVersion : null;
    }

    public static String getGlassfishAdfVersion(IProject project) {
        IRuntime runtime;
        IFacetedProject fproj = null;
        try {
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
        }
        if (fproj != null && (runtime = fproj.getPrimaryRuntime()) != null) {
            return ADFGlassfishUtil.getRuntimeComponentVersion(runtime, GLASSFISH_ADF_RT_COMPONENT_ID);
        }
        return null;
    }

    public static String getRuntimeComponentVersion(IRuntime runtime, String rtComponentType) {
        List runtimeComponents;
        String ret = null;
        if (runtime != null && (runtimeComponents = runtime.getRuntimeComponents()) != null) {
            for (IRuntimeComponent runtimeComponent : runtimeComponents) {
                IRuntimeComponentVersion runtimeComponentVersion = runtimeComponent.getRuntimeComponentVersion();
                if (runtimeComponentVersion == null || !runtimeComponentVersion.getRuntimeComponentType().getId().equals(rtComponentType)) continue;
                ret = runtimeComponentVersion.getVersionString();
                break;
            }
        }
        return ret;
    }

    public static String getGlassfishWebFacetVersion(IRuntime runtime) {
        String glassfishRuntimeCompVersionString = ADFGlassfishUtil.getRuntimeComponentVersion(runtime, GLASSFISH_RUNTIME_COMP_ID);
        if (glassfishRuntimeCompVersionString.equals("4")) {
            return "4.0";
        }
        return glassfishRuntimeCompVersionString;
    }

    public static List<IRuntimeType> getGlassfishRuntimeTypes() {
        ArrayList<IRuntimeType> ret = new ArrayList<IRuntimeType>();
        String[] stringArray = GLASSFISH_RUNTIME_TYPE_IDS;
        int n = GLASSFISH_RUNTIME_TYPE_IDS.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IRuntimeType gfRuntimeType = ServerCore.findRuntimeType((String)id);
            if (gfRuntimeType != null) {
                ret.add(gfRuntimeType);
            }
            ++n2;
        }
        return ret;
    }
}

