/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.common.technology;

import java.io.File;
import oracle.eclipse.tools.adf.common.JRFVersion;
import oracle.eclipse.tools.adf.common.util.ADFGlassfishUtil;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IDocumentService;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.app.services.IAppService;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDescriptor;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import org.eclipse.core.resources.IProject;

public class ADFCommonTechnologyExtension
extends AbstractTechnologyExtension {
    public static final String JRF_VERSION_TESTING_KEY = "jrfVersionForTesting";
    private String _jrfVersion;

    public ADFCommonTechnologyExtension(Project project, ITechnologyDescriptor techDescriptor) {
        super(project, techDescriptor);
    }

    public JRFVersion getJRFVersion() {
        String version = this.getVersion();
        return version != null ? new JRFVersion(this.getVersion()) : null;
    }

    public String getVersion() {
        if (this._jrfVersion == null) {
            WebLogicServerInstall wls = WebLogicServerInstall.getWebLogicServerInstall((IProject)this.getProject().getEclipseProject());
            if (wls != null) {
                this._jrfVersion = JRFRuntimeUtil.getJRFRuntimeImplVersion((File)wls.getLocation());
            } else {
                IProject project = this.getProject().getEclipseProject();
                this._jrfVersion = ADFGlassfishUtil.getGlassfishAdfVersion(project);
            }
            if (this._jrfVersion == null) {
                this._jrfVersion = System.getProperty(JRF_VERSION_TESTING_KEY);
                if (this._jrfVersion == null) {
                    return super.getVersion();
                }
            }
        }
        return this._jrfVersion;
    }

    public <T extends IAppService> T getAppService(Class<T> serviceType) {
        return (T)super.getAppService(serviceType);
    }

    public IDocumentService getDocumentService(Class<? extends IDocumentService> serviceType, IDocument forDocument) {
        return super.getDocumentService(serviceType, forDocument);
    }

    public IProject getCurrentEARProject() {
        return WtpProjectUtil.findReferencingEarProject((IProject)this.getProject().getEclipseProject());
    }
}

