/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.actions;

import com.python.pydev.actions.LabelProviderWithDecoration;
import com.python.pydev.actions.OutlineEntry;
import com.python.pydev.actions.ShowOutlineLabelProvider;
import com.python.pydev.refactoring.IPyRefactoring2;
import com.python.pydev.ui.hierarchy.HierarchyNodeModel;
import com.python.pydev.ui.hierarchy.TreeNodeContentProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.IModule;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.actions.refactoring.PyRefactorAction;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.model.Location;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.DefinitionsASTIteratorVisitor;
import org.python.pydev.shared_core.structure.DataAndImageTreeNode;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.quick_outline.BaseQuickOutlineSelectionDialog;
import org.python.pydev.shared_ui.quick_outline.IOutlineEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PyOutlineSelectionDialog
extends BaseQuickOutlineSelectionDialog {
    private PyEdit pyEdit;
    private HashMap<SimpleNode, HierarchyNodeModel> nodeToModel;
    private SimpleNode ast;
    protected final Job jobCalculateParents = new Job("Calculate parents"){

        public IStatus run(IProgressMonitor monitor) {
            PyOutlineSelectionDialog.this.rootWithParents = PyOutlineSelectionDialog.this.root.createCopy(null);
            if (PyOutlineSelectionDialog.this.nodeToModel == null) {
                PyOutlineSelectionDialog.this.nodeToModel = new HashMap();
                ArrayList gathered = new ArrayList();
                PyOutlineSelectionDialog.this.gatherClasses((DataAndImageTreeNode<IOutlineEntry>)PyOutlineSelectionDialog.this.rootWithParents, monitor, gathered);
                monitor.beginTask("Calculate parents", gathered.size() + 1);
                IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
                IPyRefactoring2 r2 = (IPyRefactoring2)pyRefactoring;
                for (Tuple t : gathered) {
                    SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 1);
                    try {
                        ClassDef classDef = (ClassDef)t.o1;
                        PySelection ps = new PySelection(PyOutlineSelectionDialog.this.pyEdit.getDocument(), classDef.name.beginLine - 1, classDef.name.beginColumn - 1);
                        try {
                            RefactoringRequest refactoringRequest = PyRefactorAction.createRefactoringRequest((IProgressMonitor)subProgressMonitor, (PyEdit)PyOutlineSelectionDialog.this.pyEdit, (PySelection)ps);
                            HierarchyNodeModel model = r2.findClassHierarchy(refactoringRequest, true);
                            PyOutlineSelectionDialog.this.nodeToModel.put(((OutlineEntry)((DataAndImageTreeNode)t.o2).data).node, model);
                        }
                        catch (MisconfigurationException e) {
                            Log.log((Throwable)e);
                        }
                    }
                    finally {
                        subProgressMonitor.done();
                    }
                }
            }
            if (!monitor.isCanceled()) {
                PyOutlineSelectionDialog.this.fillHierarchy((DataAndImageTreeNode<IOutlineEntry>)PyOutlineSelectionDialog.this.rootWithParents);
            }
            if (!monitor.isCanceled()) {
                PyOutlineSelectionDialog.this.uiJobSetRootWithParentsInput.setPriority(10);
                PyOutlineSelectionDialog.this.uiJobSetRootWithParentsInput.schedule();
            } else {
                PyOutlineSelectionDialog.this.rootWithParents = null;
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    };

    private static ILabelProvider createLabelProvider() {
        try {
            return new LabelProviderWithDecoration(new ShowOutlineLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        }
        catch (Throwable throwable) {
            return new ShowOutlineLabelProvider();
        }
    }

    public PyOutlineSelectionDialog(Shell shell, SimpleNode ast, HashMap<SimpleNode, HierarchyNodeModel> nodeToModel) {
        super(shell, "com.python.pydev", PyOutlineSelectionDialog.createLabelProvider(), (ITreeContentProvider)new TreeNodeContentProvider());
        this.ast = ast;
        this.nodeToModel = nodeToModel;
        this.calculateHierarchy();
        this.setInput(this.root);
    }

    public PyOutlineSelectionDialog(Shell shell, PyEdit pyEdit) {
        super(shell, "com.python.pydev", PyOutlineSelectionDialog.createLabelProvider(), (ITreeContentProvider)new TreeNodeContentProvider());
        this.pyEdit = pyEdit;
        PySelection ps = this.pyEdit.createPySelection();
        this.startLineIndex = ps.getStartLineIndex() + 1;
        this.calculateHierarchy();
        this.setInput(this.root);
        if (this.initialSelection != null) {
            this.setInitialSelections(new Object[]{this.initialSelection});
        }
    }

    protected void calculateHierarchy() {
        if (this.root != null) {
            return;
        }
        if (this.ast == null && this.pyEdit != null) {
            this.ast = this.pyEdit.getAST();
        }
        if (this.ast == null) {
            return;
        }
        DefinitionsASTIteratorVisitor visitor = DefinitionsASTIteratorVisitor.create((SimpleNode)this.ast);
        if (visitor == null) {
            return;
        }
        HashMap<ASTEntry, DataAndImageTreeNode> entryToTreeNode = new HashMap<ASTEntry, DataAndImageTreeNode>();
        DataAndImageTreeNode root = new DataAndImageTreeNode(null, null, null);
        Iterator it = visitor.getOutline();
        while (it.hasNext()) {
            DataAndImageTreeNode n;
            ASTEntry next = (ASTEntry)it.next();
            if (next.parent != null) {
                DataAndImageTreeNode parent = (DataAndImageTreeNode)entryToTreeNode.get(next.parent);
                if (parent == null) {
                    Log.log((String)"Unexpected condition: child found before parent!");
                    parent = root;
                }
                n = new DataAndImageTreeNode(parent, (Object)new OutlineEntry(next), null);
            } else {
                n = new DataAndImageTreeNode(root, (Object)new OutlineEntry(next), null);
            }
            if (((OutlineEntry)n.data).node.beginLine <= this.startLineIndex) {
                this.initialSelection = n;
            }
            entryToTreeNode.put(next, n);
        }
        this.root = root;
    }

    protected void calculateHierarchyWithParents() {
        if (this.rootWithParents != null) {
            this.uiJobSetRootWithParentsInput.setPriority(10);
            this.uiJobSetRootWithParentsInput.schedule();
            return;
        }
        this.calculateHierarchy();
        if (this.root == null) {
            return;
        }
        this.jobCalculateParents.setPriority(10);
        this.jobCalculateParents.schedule();
    }

    private void fillHierarchy(DataAndImageTreeNode<IOutlineEntry> entry) {
        ArrayList copy = new ArrayList(entry.children);
        for (DataAndImageTreeNode nextEntry : copy) {
            HierarchyNodeModel model = this.nodeToModel.get(((OutlineEntry)nextEntry.data).node);
            this.addMethods((DataAndImageTreeNode<IOutlineEntry>)nextEntry, model);
            this.fillHierarchy((DataAndImageTreeNode<IOutlineEntry>)nextEntry);
        }
    }

    private void addMethods(DataAndImageTreeNode<IOutlineEntry> nextEntry, HierarchyNodeModel model) {
        if (model == null || model.parents == null) {
            return;
        }
        for (HierarchyNodeModel parent : model.parents) {
            DefinitionsASTIteratorVisitor visitor = DefinitionsASTIteratorVisitor.createForChildren((ClassDef)parent.ast);
            if (visitor == null) continue;
            Iterator outline = visitor.getOutline();
            while (outline.hasNext()) {
                ASTEntry entry = (ASTEntry)outline.next();
                if (entry.parent != null) continue;
                new DataAndImageTreeNode(nextEntry, (Object)new OutlineEntry(entry, parent), null);
            }
            this.addMethods(nextEntry, parent);
        }
    }

    private void gatherClasses(DataAndImageTreeNode<IOutlineEntry> entry, IProgressMonitor monitor, List<Tuple<ClassDef, DataAndImageTreeNode<IOutlineEntry>>> gathered) {
        if (entry.children.size() == 0) {
            return;
        }
        for (DataAndImageTreeNode nextEntry : entry.children) {
            if (((OutlineEntry)nextEntry.data).node instanceof ClassDef) {
                ClassDef classDef = (ClassDef)((OutlineEntry)nextEntry.data).node;
                gathered.add((Tuple<ClassDef, DataAndImageTreeNode<IOutlineEntry>>)new Tuple((Object)classDef, (Object)nextEntry));
            }
            this.gatherClasses((DataAndImageTreeNode<IOutlineEntry>)nextEntry, monitor, gathered);
        }
    }

    public int open() {
        Object[] result;
        int ret = super.open();
        if (ret == 0 && (result = this.getResult()) != null && result.length > 0) {
            DataAndImageTreeNode n = (DataAndImageTreeNode)result[0];
            OutlineEntry outlineEntry = (OutlineEntry)n.data;
            if (outlineEntry.model == null) {
                Location location = new Location(NodeUtils.getNameLineDefinition((SimpleNode)outlineEntry.node) - 1, NodeUtils.getNameColDefinition((SimpleNode)outlineEntry.node) - 1);
                new PyOpenAction().showInEditor((ITextEditor)this.pyEdit, location, location);
            } else {
                SourceModule sourceModule;
                File file;
                PyOpenAction pyOpenAction = new PyOpenAction();
                IModule m = outlineEntry.model.module;
                if (m instanceof SourceModule && (file = (sourceModule = (SourceModule)m).getFile()) != null) {
                    ItemPointer p = new ItemPointer((Object)file, outlineEntry.node);
                    pyOpenAction.run(p);
                }
            }
        }
        return ret;
    }
}

