/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlValueMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaXmlNodeMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlValueAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlValueMapping
extends AbstractJavaXmlNodeMapping<XmlValueAnnotation>
implements JavaXmlValueMapping {
    public GenericJavaXmlValueMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public String getKey() {
        return "xml-value";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlValue";
    }

    @Override
    protected boolean calculateDefaultXmlList() {
        return this.getPersistentAttribute().isJavaResourceAttributeCollectionType();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateSchemaType(messages, reporter);
    }

    protected void validateSchemaType(List<IMessage> messages, IReporter reporter) {
        XsdTypeDefinition xsdClassType = this.getClassMapping().getXsdTypeDefinition();
        if (xsdClassType == null) {
            return;
        }
        if (!xsdClassType.hasTextContent()) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_VALUE__NO_TEXT_CONTENT));
            return;
        }
        XsdTypeDefinition xsdType = xsdClassType.getBaseType();
        XsdTypeDefinition expectedSchemaType = this.getDataTypeXsdTypeDefinition();
        if (xsdType == null || expectedSchemaType == null) {
            return;
        }
        if (!xsdType.typeIsValid(expectedSchemaType, this.isXmlList())) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_VALUE__INVALID_SCHEMA_TYPE, this.getValueTypeName()));
        }
    }
}

