/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbElementFactoryMethod;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementRef;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.XmlRegistry;
import org.eclipse.jpt.jaxb.core.context.XmlRootElement;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaElementQName;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractQNameAnnotationProxy;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlElementRef
extends AbstractJavaContextNode
implements XmlElementRef {
    protected final Context context;
    protected final JaxbQName qName;
    protected Boolean specifiedRequired;
    protected String specifiedType;
    protected String defaultType;

    public GenericJavaXmlElementRef(JaxbContextNode parent, Context context) {
        super(parent);
        this.context = context;
        this.qName = this.buildQName();
        this.specifiedRequired = this.buildSpecifiedRequired();
        this.specifiedType = this.buildSpecifiedType();
        this.defaultType = this.buildDefaultType();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.qName.synchronizeWithResourceModel();
        this.setSpecifiedRequired_(this.buildSpecifiedRequired());
        this.setSpecifiedType_(this.buildSpecifiedType());
        this.setDefaultType_(this.buildDefaultType());
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
    }

    protected Context getContext() {
        return this.context;
    }

    protected JavaPersistentAttribute getPersistentAttribute() {
        return this.getContext().getAttributeMapping().getPersistentAttribute();
    }

    protected JavaClassMapping getClassMapping() {
        return this.getPersistentAttribute().getClassMapping();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getClassMapping().getJaxbPackage();
    }

    @Override
    public XmlElementRefAnnotation getAnnotation() {
        return this.context.getAnnotation();
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    protected JaxbQName buildQName() {
        return new XmlElementRefQName(this);
    }

    @Override
    public boolean isRequired() {
        return this.specifiedRequired == null ? this.isDefaultRequired() : this.specifiedRequired.booleanValue();
    }

    @Override
    public Boolean getSpecifiedRequired() {
        return this.specifiedRequired;
    }

    @Override
    public void setSpecifiedRequired(Boolean newSpecifiedRequired) {
        this.getAnnotation().setRequired(newSpecifiedRequired);
        this.setSpecifiedRequired_(newSpecifiedRequired);
    }

    protected void setSpecifiedRequired_(Boolean newSpecifiedRequired) {
        Boolean oldRequired = this.specifiedRequired;
        this.specifiedRequired = newSpecifiedRequired;
        this.firePropertyChanged("specifiedRequired", oldRequired, newSpecifiedRequired);
    }

    protected Boolean buildSpecifiedRequired() {
        return this.getAnnotation().getRequired();
    }

    @Override
    public boolean isDefaultRequired() {
        return false;
    }

    @Override
    public String getType() {
        return this.specifiedType == null ? this.getDefaultType() : this.specifiedType;
    }

    @Override
    public String getSpecifiedType() {
        return this.specifiedType;
    }

    @Override
    public void setSpecifiedType(String newSpecifiedType) {
        this.getAnnotation().setType(newSpecifiedType);
        this.setSpecifiedType_(newSpecifiedType);
    }

    protected void setSpecifiedType_(String newSpecifiedType) {
        String oldType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedType", oldType, newSpecifiedType);
    }

    protected String buildSpecifiedType() {
        return this.getAnnotation().getType();
    }

    @Override
    public String getDefaultType() {
        return this.defaultType;
    }

    protected void setDefaultType_(String newType) {
        String oldType = this.defaultType;
        this.defaultType = newType;
        this.firePropertyChanged("defaultType", oldType, newType);
    }

    protected String buildDefaultType() {
        return this.context.getDefaultType();
    }

    @Override
    public String getFullyQualifiedType() {
        return this.specifiedType == null ? this.getDefaultType() : this.getAnnotation().getFullyQualifiedTypeName();
    }

    @Override
    public Iterable<String> getReferencedXmlTypeNames() {
        if (this.specifiedType != null && !this.isTypeJAXBElement()) {
            return new SingleElementIterable((Object)this.getFullyQualifiedType());
        }
        return EmptyIterable.instance();
    }

    protected boolean isTypeJAXBElement() {
        return ObjectTools.equals((Object)"javax.xml.bind.JAXBElement", (Object)this.getFullyQualifiedType());
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        result = this.qName.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getAnnotation().getTextRange();
    }

    @Override
    public TextRange getTypeTextRange() {
        return this.getAnnotation().getTypeTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.qName.validate(messages, reporter);
        this.validateType(messages, reporter);
    }

    protected void validateType(List<IMessage> messages, IReporter reporter) {
        String fqType = this.getFullyQualifiedType();
        if (StringTools.isBlank((String)fqType)) {
            messages.add(this.buildValidationMessage(this.getTypeTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_REF__UNSPECIFIED_TYPE));
        } else if (!StringTools.isBlank((String)this.specifiedType) && JavaProjectTools.findType((IJavaProject)this.getJaxbProject().getJavaProject(), (String)fqType) != null) {
            JaxbTypeMapping typeMapping;
            String attributeValueType = this.getContext().getAttributeMapping().getValueTypeName();
            if (!TypeTools.isSubType((String)fqType, (String)attributeValueType, (IJavaProject)this.getJaxbProject().getJavaProject())) {
                messages.add(this.buildValidationMessage(this.getTypeTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_REF__ILLEGAL_TYPE, attributeValueType));
            }
            if ((typeMapping = this.getJaxbProject().getContextRoot().getTypeMapping(fqType)) != null && !typeMapping.hasRootElementInHierarchy()) {
                messages.add(this.buildValidationMessage(this.getTypeTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_REF__NO_ROOT_ELEMENT, attributeValueType));
            }
        }
    }

    public static interface Context {
        public JavaAttributeMapping getAttributeMapping();

        public XmlElementRefAnnotation getAnnotation();

        public String getDefaultType();

        public XmlElementWrapper getElementWrapper();
    }

    protected class QNameAnnotationProxy
    extends AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return GenericJavaXmlElementRef.this.getAnnotation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlElementRefQName
    extends AbstractJavaElementQName {
        protected XmlElementRefQName(JaxbContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JavaPersistentAttribute getPersistentAttribute() {
            return GenericJavaXmlElementRef.this.getPersistentAttribute();
        }

        protected boolean isTypeJAXBElement() {
            return GenericJavaXmlElementRef.this.isTypeJAXBElement();
        }

        protected JaxbTypeMapping getReferencedTypeMapping() {
            String fqTypeName = GenericJavaXmlElementRef.this.getFullyQualifiedType();
            return this.getJaxbProject().getContextRoot().getTypeMapping(fqTypeName);
        }

        @Override
        protected XmlElementWrapper getElementWrapper() {
            return GenericJavaXmlElementRef.this.context.getElementWrapper();
        }

        @Override
        protected String buildDefaultName() {
            XmlRootElement rootElement;
            if (this.isTypeJAXBElement()) {
                return super.buildDefaultName();
            }
            JaxbTypeMapping referencedTypeMapping = this.getReferencedTypeMapping();
            if (referencedTypeMapping != null && (rootElement = referencedTypeMapping.getXmlRootElement()) != null) {
                return rootElement.getQName().getName();
            }
            return "";
        }

        @Override
        protected String buildDefaultNamespace() {
            XmlRootElement rootElement;
            JaxbTypeMapping referencedTypeMapping = this.getReferencedTypeMapping();
            if (referencedTypeMapping != null && (rootElement = referencedTypeMapping.getXmlRootElement()) != null) {
                return rootElement.getQName().getNamespace();
            }
            return super.buildDefaultNamespace();
        }

        @Override
        protected void validateName(List<IMessage> messages, IReporter reporter) {
            if (this.isTypeJAXBElement()) {
                super.validateName(messages, reporter);
            }
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter) {
            super.validateReference(messages, reporter);
            if (!this.isTypeJAXBElement()) {
                return;
            }
            XmlRegistry registry = this.getJaxbPackage().getRegistry();
            if (registry == null) {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_REF__NO_REGISTRY));
                return;
            }
            for (JaxbElementFactoryMethod elementDecl : registry.getElementFactoryMethods()) {
                if (!ObjectTools.equals((Object)this.getName(), (Object)elementDecl.getQName().getName()) || !ObjectTools.equals((Object)this.getNamespace(), (Object)elementDecl.getQName().getNamespace())) continue;
                return;
            }
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ELEMENT_REF__NO_MATCHING_ELEMENT_DECL, this.getNamespace(), this.getName()));
        }
    }
}

