/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.sqltools.core.services;

import java.util.Map;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifierImpl;

public class OracleProcIdentifier
extends ProcIdentifierImpl {
    public static final String PROP_PACKAGE = "PACKAGE";
    public static final String PROP_PACKAGE_TYPE = "PACKAGE TYPE";
    public static final String PROP_PACKAGE_OVERLOAD_ORDER = "OVERLOAD ORDER";
    private String packageName;
    private String packageType;
    private Integer overloadOrder;

    public OracleProcIdentifier(int type, DatabaseIdentifier db, Map<String, String> map) {
        super(type, db, map);
        if (map.containsKey(PROP_PACKAGE)) {
            this.packageName = map.get(PROP_PACKAGE);
            this.packageType = map.get(PROP_PACKAGE_TYPE);
            String orderStr = map.get(PROP_PACKAGE_OVERLOAD_ORDER);
            if (orderStr != null) {
                this.overloadOrder = new Integer(orderStr);
            }
        }
    }

    public String getCallableStringWithoutGroupNumber(boolean quoted_id) {
        String call = super.getCallableStringWithoutGroupNumber(quoted_id);
        int lastDot = call.lastIndexOf(".");
        String callableString = call.substring(lastDot + 1);
        String ownerName = this.getOwnerName();
        if (this.packageName != null) {
            return String.valueOf(ownerName) + "." + this.packageName + "." + callableString;
        }
        return String.valueOf(ownerName) + "." + callableString;
    }

    public String getLongDisplayString() {
        String s = "";
        s = this.getType() == 3 && this.getTableName() != null && this.getTableName().length() > 0 ? "(" + this.getProfileName() + ")" + this.getOwnerName() + "." + this.getTableName() + "." + this.getDisplayString() : "(" + this.getProfileName() + ")" + this.getOwnerName() + "." + this.getDisplayString();
        return s;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public Integer getOverloadOrder() {
        return this.overloadOrder;
    }
}

